/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRailDetector
extends BlockRailBase {
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.create("shape", BlockRailBase.EnumRailDirection.class, new Predicate<BlockRailBase.EnumRailDirection>(){

        public boolean apply(BlockRailBase.EnumRailDirection p_apply_1_) {
            return p_apply_1_ != BlockRailBase.EnumRailDirection.NORTH_EAST && p_apply_1_ != BlockRailBase.EnumRailDirection.NORTH_WEST && p_apply_1_ != BlockRailBase.EnumRailDirection.SOUTH_EAST && p_apply_1_ != BlockRailBase.EnumRailDirection.SOUTH_WEST;
        }
    });
    public static final PropertyBool POWERED = PropertyBool.create("powered");

    public BlockRailDetector() {
        super(true);
        this.setDefaultState(this.blockState.getBaseState().withProperty(POWERED, false).withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH));
        this.setTickRandomly(true);
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 20;
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        if (!p_onEntityCollidedWithBlock_1_.isRemote && !p_onEntityCollidedWithBlock_3_.getValue(POWERED).booleanValue()) {
            this.updatePoweredState(p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_, p_onEntityCollidedWithBlock_3_);
        }
    }

    @Override
    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote && p_updateTick_3_.getValue(POWERED).booleanValue()) {
            this.updatePoweredState(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
        }
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return p_getWeakPower_1_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_1_.getValue(POWERED) == false ? 0 : (p_getStrongPower_4_ == EnumFacing.UP ? 15 : 0);
    }

    private void updatePoweredState(World p_updatePoweredState_1_, BlockPos p_updatePoweredState_2_, IBlockState p_updatePoweredState_3_) {
        boolean flag = p_updatePoweredState_3_.getValue(POWERED);
        boolean flag1 = false;
        List<EntityMinecart> list = this.findMinecarts(p_updatePoweredState_1_, p_updatePoweredState_2_, EntityMinecart.class, new Predicate[0]);
        if (!list.isEmpty()) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            p_updatePoweredState_1_.setBlockState(p_updatePoweredState_2_, p_updatePoweredState_3_.withProperty(POWERED, true), 3);
            this.updateConnectedRails(p_updatePoweredState_1_, p_updatePoweredState_2_, p_updatePoweredState_3_, true);
            p_updatePoweredState_1_.notifyNeighborsOfStateChange(p_updatePoweredState_2_, this, false);
            p_updatePoweredState_1_.notifyNeighborsOfStateChange(p_updatePoweredState_2_.down(), this, false);
            p_updatePoweredState_1_.markBlockRangeForRenderUpdate(p_updatePoweredState_2_, p_updatePoweredState_2_);
        }
        if (!flag1 && flag) {
            p_updatePoweredState_1_.setBlockState(p_updatePoweredState_2_, p_updatePoweredState_3_.withProperty(POWERED, false), 3);
            this.updateConnectedRails(p_updatePoweredState_1_, p_updatePoweredState_2_, p_updatePoweredState_3_, false);
            p_updatePoweredState_1_.notifyNeighborsOfStateChange(p_updatePoweredState_2_, this, false);
            p_updatePoweredState_1_.notifyNeighborsOfStateChange(p_updatePoweredState_2_.down(), this, false);
            p_updatePoweredState_1_.markBlockRangeForRenderUpdate(p_updatePoweredState_2_, p_updatePoweredState_2_);
        }
        if (flag1) {
            p_updatePoweredState_1_.scheduleUpdate(new BlockPos(p_updatePoweredState_2_), this, this.tickRate(p_updatePoweredState_1_));
        }
        p_updatePoweredState_1_.updateComparatorOutputLevel(p_updatePoweredState_2_, this);
    }

    protected void updateConnectedRails(World p_updateConnectedRails_1_, BlockPos p_updateConnectedRails_2_, IBlockState p_updateConnectedRails_3_, boolean p_updateConnectedRails_4_) {
        BlockRailBase.Rail blockrailbase$rail = new BlockRailBase.Rail(p_updateConnectedRails_1_, p_updateConnectedRails_2_, p_updateConnectedRails_3_);
        for (BlockPos blockpos : blockrailbase$rail.getConnectedRails()) {
            IBlockState iblockstate = p_updateConnectedRails_1_.getBlockState(blockpos);
            if (iblockstate == null) continue;
            iblockstate.neighborChanged(p_updateConnectedRails_1_, blockpos, iblockstate.getBlock(), p_updateConnectedRails_2_);
        }
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        super.onBlockAdded(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        this.updatePoweredState(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    @Override
    public IProperty<BlockRailBase.EnumRailDirection> getShapeProperty() {
        return SHAPE;
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        if (p_getComparatorInputOverride_1_.getValue(POWERED).booleanValue()) {
            List<EntityMinecart> carts = this.findMinecarts(p_getComparatorInputOverride_2_, p_getComparatorInputOverride_3_, EntityMinecart.class, new Predicate[0]);
            if (!carts.isEmpty() && carts.get(0).getComparatorLevel() > -1) {
                return carts.get(0).getComparatorLevel();
            }
            List<EntityMinecartCommandBlock> list = this.findMinecarts(p_getComparatorInputOverride_2_, p_getComparatorInputOverride_3_, EntityMinecartCommandBlock.class, new Predicate[0]);
            if (!list.isEmpty()) {
                return list.get(0).getCommandBlockLogic().getSuccessCount();
            }
            List<EntityMinecart> list1 = this.findMinecarts(p_getComparatorInputOverride_2_, p_getComparatorInputOverride_3_, EntityMinecart.class, EntitySelectors.HAS_INVENTORY);
            if (!list1.isEmpty()) {
                return Container.calcRedstoneFromInventory((IInventory)((Object)list1.get(0)));
            }
        }
        return 0;
    }

    protected <T extends EntityMinecart> List<T> findMinecarts(World p_findMinecarts_1_, BlockPos p_findMinecarts_2_, Class<T> p_findMinecarts_3_, Predicate<Entity> ... p_findMinecarts_4_) {
        AxisAlignedBB axisalignedbb = this.getDectectionBox(p_findMinecarts_2_);
        return p_findMinecarts_4_.length != 1 ? p_findMinecarts_1_.getEntitiesWithinAABB(p_findMinecarts_3_, axisalignedbb) : p_findMinecarts_1_.getEntitiesWithinAABB(p_findMinecarts_3_, axisalignedbb, p_findMinecarts_4_[0]);
    }

    private AxisAlignedBB getDectectionBox(BlockPos p_getDectectionBox_1_) {
        float f = 0.2f;
        return new AxisAlignedBB((float)p_getDectectionBox_1_.getX() + 0.2f, p_getDectectionBox_1_.getY(), (float)p_getDectectionBox_1_.getZ() + 0.2f, (float)(p_getDectectionBox_1_.getX() + 1) - 0.2f, (float)(p_getDectectionBox_1_.getY() + 1) - 0.2f, (float)(p_getDectectionBox_1_.getZ() + 1) - 0.2f);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(SHAPE, BlockRailBase.EnumRailDirection.byMetadata(p_getStateFromMeta_1_ & 7)).withProperty(POWERED, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(SHAPE).getMetadata();
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                }
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = p_withMirror_1_.getValue(SHAPE);
        block0 : switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                switch (blockrailbase$enumraildirection) {
                    case ASCENDING_NORTH: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
                return super.withMirror(p_withMirror_1_, p_withMirror_2_);
            }
            case FRONT_BACK: {
                switch (blockrailbase$enumraildirection) {
                    case ASCENDING_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, SHAPE, POWERED);
    }
}

