/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockRailPowered
extends BlockRailBase {
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.create("shape", BlockRailBase.EnumRailDirection.class, new Predicate<BlockRailBase.EnumRailDirection>(){

        public boolean apply(BlockRailBase.EnumRailDirection p_apply_1_) {
            return p_apply_1_ != BlockRailBase.EnumRailDirection.NORTH_EAST && p_apply_1_ != BlockRailBase.EnumRailDirection.NORTH_WEST && p_apply_1_ != BlockRailBase.EnumRailDirection.SOUTH_EAST && p_apply_1_ != BlockRailBase.EnumRailDirection.SOUTH_WEST;
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((BlockRailBase.EnumRailDirection)p_apply_1_);
        }
    });
    public static final PropertyBool POWERED = PropertyBool.create("powered");

    protected BlockRailPowered() {
        super(true);
        this.setDefaultState(this.blockState.getBaseState().withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH).withProperty(POWERED, false));
    }

    protected boolean findPoweredRailSignal(World p_findPoweredRailSignal_1_, BlockPos p_findPoweredRailSignal_2_, IBlockState p_findPoweredRailSignal_3_, boolean p_findPoweredRailSignal_4_, int p_findPoweredRailSignal_5_) {
        if (p_findPoweredRailSignal_5_ >= 8) {
            return false;
        }
        int lvt_6_1_ = p_findPoweredRailSignal_2_.getX();
        int lvt_7_1_ = p_findPoweredRailSignal_2_.getY();
        int lvt_8_1_ = p_findPoweredRailSignal_2_.getZ();
        boolean lvt_9_1_ = true;
        BlockRailBase.EnumRailDirection lvt_10_1_ = p_findPoweredRailSignal_3_.getValue(SHAPE);
        switch (lvt_10_1_) {
            case NORTH_SOUTH: {
                if (p_findPoweredRailSignal_4_) {
                    ++lvt_8_1_;
                    break;
                }
                --lvt_8_1_;
                break;
            }
            case EAST_WEST: {
                if (p_findPoweredRailSignal_4_) {
                    --lvt_6_1_;
                    break;
                }
                ++lvt_6_1_;
                break;
            }
            case ASCENDING_EAST: {
                if (p_findPoweredRailSignal_4_) {
                    --lvt_6_1_;
                } else {
                    ++lvt_6_1_;
                    ++lvt_7_1_;
                    lvt_9_1_ = false;
                }
                lvt_10_1_ = BlockRailBase.EnumRailDirection.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (p_findPoweredRailSignal_4_) {
                    --lvt_6_1_;
                    ++lvt_7_1_;
                    lvt_9_1_ = false;
                } else {
                    ++lvt_6_1_;
                }
                lvt_10_1_ = BlockRailBase.EnumRailDirection.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (p_findPoweredRailSignal_4_) {
                    ++lvt_8_1_;
                } else {
                    --lvt_8_1_;
                    ++lvt_7_1_;
                    lvt_9_1_ = false;
                }
                lvt_10_1_ = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (p_findPoweredRailSignal_4_) {
                    ++lvt_8_1_;
                    ++lvt_7_1_;
                    lvt_9_1_ = false;
                } else {
                    --lvt_8_1_;
                }
                lvt_10_1_ = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            }
        }
        if (this.isSameRailWithPower(p_findPoweredRailSignal_1_, new BlockPos(lvt_6_1_, lvt_7_1_, lvt_8_1_), p_findPoweredRailSignal_4_, p_findPoweredRailSignal_5_, lvt_10_1_)) {
            return true;
        }
        return lvt_9_1_ && this.isSameRailWithPower(p_findPoweredRailSignal_1_, new BlockPos(lvt_6_1_, lvt_7_1_ - 1, lvt_8_1_), p_findPoweredRailSignal_4_, p_findPoweredRailSignal_5_, lvt_10_1_);
    }

    protected boolean isSameRailWithPower(World p_isSameRailWithPower_1_, BlockPos p_isSameRailWithPower_2_, boolean p_isSameRailWithPower_3_, int p_isSameRailWithPower_4_, BlockRailBase.EnumRailDirection p_isSameRailWithPower_5_) {
        IBlockState lvt_6_1_ = p_isSameRailWithPower_1_.getBlockState(p_isSameRailWithPower_2_);
        if (lvt_6_1_.getBlock() != this) {
            return false;
        }
        BlockRailBase.EnumRailDirection lvt_7_1_ = lvt_6_1_.getValue(SHAPE);
        if (p_isSameRailWithPower_5_ == BlockRailBase.EnumRailDirection.EAST_WEST && (lvt_7_1_ == BlockRailBase.EnumRailDirection.NORTH_SOUTH || lvt_7_1_ == BlockRailBase.EnumRailDirection.ASCENDING_NORTH || lvt_7_1_ == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH)) {
            return false;
        }
        if (p_isSameRailWithPower_5_ == BlockRailBase.EnumRailDirection.NORTH_SOUTH && (lvt_7_1_ == BlockRailBase.EnumRailDirection.EAST_WEST || lvt_7_1_ == BlockRailBase.EnumRailDirection.ASCENDING_EAST || lvt_7_1_ == BlockRailBase.EnumRailDirection.ASCENDING_WEST)) {
            return false;
        }
        if (lvt_6_1_.getValue(POWERED).booleanValue()) {
            if (p_isSameRailWithPower_1_.isBlockPowered(p_isSameRailWithPower_2_)) {
                return true;
            }
            return this.findPoweredRailSignal(p_isSameRailWithPower_1_, p_isSameRailWithPower_2_, lvt_6_1_, p_isSameRailWithPower_3_, p_isSameRailWithPower_4_ + 1);
        }
        return false;
    }

    @Override
    protected void updateState(IBlockState p_updateState_1_, World p_updateState_2_, BlockPos p_updateState_3_, Block p_updateState_4_) {
        boolean lvt_6_1_;
        boolean lvt_5_1_ = p_updateState_1_.getValue(POWERED);
        boolean bl = lvt_6_1_ = p_updateState_2_.isBlockPowered(p_updateState_3_) || this.findPoweredRailSignal(p_updateState_2_, p_updateState_3_, p_updateState_1_, true, 0) || this.findPoweredRailSignal(p_updateState_2_, p_updateState_3_, p_updateState_1_, false, 0);
        if (lvt_6_1_ != lvt_5_1_) {
            p_updateState_2_.setBlockState(p_updateState_3_, p_updateState_1_.withProperty(POWERED, lvt_6_1_), 3);
            p_updateState_2_.notifyNeighborsOfStateChange(p_updateState_3_.down(), this, false);
            if (p_updateState_1_.getValue(SHAPE).isAscending()) {
                p_updateState_2_.notifyNeighborsOfStateChange(p_updateState_3_.up(), this, false);
            }
        }
    }

    @Override
    public IProperty<BlockRailBase.EnumRailDirection> getShapeProperty() {
        return SHAPE;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(SHAPE, BlockRailBase.EnumRailDirection.byMetadata(p_getStateFromMeta_1_ & 7)).withProperty(POWERED, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(SHAPE).getMetadata();
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            lvt_2_1_ |= 8;
        }
        return lvt_2_1_;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        BlockRailBase.EnumRailDirection lvt_3_1_ = p_withMirror_1_.getValue(SHAPE);
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                switch (lvt_3_1_) {
                    case ASCENDING_NORTH: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch (lvt_3_1_) {
                    case ASCENDING_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, SHAPE, POWERED);
    }
}

