/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRedstoneComparator
extends BlockRedstoneDiode
implements ITileEntityProvider {
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    public static final PropertyEnum<Mode> MODE = PropertyEnum.create("mode", Mode.class);

    public BlockRedstoneComparator(boolean p_i45399_1_) {
        super(p_i45399_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(POWERED, false).withProperty(MODE, Mode.COMPARE));
        this.isBlockContainer = true;
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal("item.comparator.name");
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.COMPARATOR;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.COMPARATOR);
    }

    @Override
    protected int getDelay(IBlockState p_getDelay_1_) {
        return 2;
    }

    @Override
    protected IBlockState getPoweredState(IBlockState p_getPoweredState_1_) {
        Boolean obool = p_getPoweredState_1_.getValue(POWERED);
        Mode blockredstonecomparator$mode = p_getPoweredState_1_.getValue(MODE);
        EnumFacing enumfacing = p_getPoweredState_1_.getValue(FACING);
        return Blocks.POWERED_COMPARATOR.getDefaultState().withProperty(FACING, enumfacing).withProperty(POWERED, obool).withProperty(MODE, blockredstonecomparator$mode);
    }

    @Override
    protected IBlockState getUnpoweredState(IBlockState p_getUnpoweredState_1_) {
        Boolean obool = p_getUnpoweredState_1_.getValue(POWERED);
        Mode blockredstonecomparator$mode = p_getUnpoweredState_1_.getValue(MODE);
        EnumFacing enumfacing = p_getUnpoweredState_1_.getValue(FACING);
        return Blocks.UNPOWERED_COMPARATOR.getDefaultState().withProperty(FACING, enumfacing).withProperty(POWERED, obool).withProperty(MODE, blockredstonecomparator$mode);
    }

    @Override
    protected boolean isPowered(IBlockState p_isPowered_1_) {
        return this.isRepeaterPowered || p_isPowered_1_.getValue(POWERED) != false;
    }

    @Override
    protected int getActiveSignal(IBlockAccess p_getActiveSignal_1_, BlockPos p_getActiveSignal_2_, IBlockState p_getActiveSignal_3_) {
        TileEntity tileentity = p_getActiveSignal_1_.getTileEntity(p_getActiveSignal_2_);
        return tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).getOutputSignal() : 0;
    }

    private int calculateOutput(World p_calculateOutput_1_, BlockPos p_calculateOutput_2_, IBlockState p_calculateOutput_3_) {
        return p_calculateOutput_3_.getValue(MODE) == Mode.SUBTRACT ? Math.max(this.calculateInputStrength(p_calculateOutput_1_, p_calculateOutput_2_, p_calculateOutput_3_) - this.getPowerOnSides(p_calculateOutput_1_, p_calculateOutput_2_, p_calculateOutput_3_), 0) : this.calculateInputStrength(p_calculateOutput_1_, p_calculateOutput_2_, p_calculateOutput_3_);
    }

    @Override
    protected boolean shouldBePowered(World p_shouldBePowered_1_, BlockPos p_shouldBePowered_2_, IBlockState p_shouldBePowered_3_) {
        int i = this.calculateInputStrength(p_shouldBePowered_1_, p_shouldBePowered_2_, p_shouldBePowered_3_);
        if (i >= 15) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        int j = this.getPowerOnSides(p_shouldBePowered_1_, p_shouldBePowered_2_, p_shouldBePowered_3_);
        return j == 0 ? true : i >= j;
    }

    @Override
    protected int calculateInputStrength(World p_calculateInputStrength_1_, BlockPos p_calculateInputStrength_2_, IBlockState p_calculateInputStrength_3_) {
        int i = super.calculateInputStrength(p_calculateInputStrength_1_, p_calculateInputStrength_2_, p_calculateInputStrength_3_);
        EnumFacing enumfacing = p_calculateInputStrength_3_.getValue(FACING);
        BlockPos blockpos = p_calculateInputStrength_2_.offset(enumfacing);
        IBlockState iblockstate = p_calculateInputStrength_1_.getBlockState(blockpos);
        if (iblockstate.hasComparatorInputOverride()) {
            i = iblockstate.getComparatorInputOverride(p_calculateInputStrength_1_, blockpos);
        } else if (i < 15 && iblockstate.isNormalCube()) {
            EntityItemFrame entityitemframe;
            iblockstate = p_calculateInputStrength_1_.getBlockState(blockpos = blockpos.offset(enumfacing));
            if (iblockstate.hasComparatorInputOverride()) {
                i = iblockstate.getComparatorInputOverride(p_calculateInputStrength_1_, blockpos);
            } else if (iblockstate.getMaterial() == Material.AIR && (entityitemframe = this.findItemFrame(p_calculateInputStrength_1_, enumfacing, blockpos)) != null) {
                i = entityitemframe.getAnalogOutput();
            }
        }
        return i;
    }

    @Nullable
    private EntityItemFrame findItemFrame(World p_findItemFrame_1_, final EnumFacing p_findItemFrame_2_, BlockPos p_findItemFrame_3_) {
        List<Entity> list = p_findItemFrame_1_.getEntitiesWithinAABB(EntityItemFrame.class, new AxisAlignedBB(p_findItemFrame_3_.getX(), p_findItemFrame_3_.getY(), p_findItemFrame_3_.getZ(), p_findItemFrame_3_.getX() + 1, p_findItemFrame_3_.getY() + 1, p_findItemFrame_3_.getZ() + 1), new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.getHorizontalFacing() == p_findItemFrame_2_;
            }
        });
        return list.size() == 1 ? (EntityItemFrame)list.get(0) : null;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (!p_onBlockActivated_4_.capabilities.allowEdit) {
            return false;
        }
        float f = (p_onBlockActivated_3_ = p_onBlockActivated_3_.cycleProperty(MODE)).getValue(MODE) == Mode.SUBTRACT ? 0.55f : 0.5f;
        p_onBlockActivated_1_.playSound(p_onBlockActivated_4_, p_onBlockActivated_2_, SoundEvents.BLOCK_COMPARATOR_CLICK, SoundCategory.BLOCKS, 0.3f, f);
        p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 2);
        this.onStateChange(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_);
        return true;
    }

    @Override
    protected void updateState(World p_updateState_1_, BlockPos p_updateState_2_, IBlockState p_updateState_3_) {
        if (!p_updateState_1_.isBlockTickPending(p_updateState_2_, this)) {
            int j;
            int i = this.calculateOutput(p_updateState_1_, p_updateState_2_, p_updateState_3_);
            TileEntity tileentity = p_updateState_1_.getTileEntity(p_updateState_2_);
            int n = j = tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).getOutputSignal() : 0;
            if (i != j || this.isPowered(p_updateState_3_) != this.shouldBePowered(p_updateState_1_, p_updateState_2_, p_updateState_3_)) {
                if (this.isFacingTowardsRepeater(p_updateState_1_, p_updateState_2_, p_updateState_3_)) {
                    p_updateState_1_.updateBlockTick(p_updateState_2_, this, 2, -1);
                } else {
                    p_updateState_1_.updateBlockTick(p_updateState_2_, this, 2, 0);
                }
            }
        }
    }

    private void onStateChange(World p_onStateChange_1_, BlockPos p_onStateChange_2_, IBlockState p_onStateChange_3_) {
        int i = this.calculateOutput(p_onStateChange_1_, p_onStateChange_2_, p_onStateChange_3_);
        TileEntity tileentity = p_onStateChange_1_.getTileEntity(p_onStateChange_2_);
        int j = 0;
        if (tileentity instanceof TileEntityComparator) {
            TileEntityComparator tileentitycomparator = (TileEntityComparator)tileentity;
            j = tileentitycomparator.getOutputSignal();
            tileentitycomparator.setOutputSignal(i);
        }
        if (j != i || p_onStateChange_3_.getValue(MODE) == Mode.COMPARE) {
            boolean flag1 = this.shouldBePowered(p_onStateChange_1_, p_onStateChange_2_, p_onStateChange_3_);
            boolean flag = this.isPowered(p_onStateChange_3_);
            if (flag && !flag1) {
                p_onStateChange_1_.setBlockState(p_onStateChange_2_, p_onStateChange_3_.withProperty(POWERED, false), 2);
            } else if (!flag && flag1) {
                p_onStateChange_1_.setBlockState(p_onStateChange_2_, p_onStateChange_3_.withProperty(POWERED, true), 2);
            }
            this.notifyNeighbors(p_onStateChange_1_, p_onStateChange_2_, p_onStateChange_3_);
        }
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (this.isRepeaterPowered) {
            p_updateTick_1_.setBlockState(p_updateTick_2_, this.getUnpoweredState(p_updateTick_3_).withProperty(POWERED, true), 4);
        }
        this.onStateChange(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        super.onBlockAdded(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        p_onBlockAdded_1_.setTileEntity(p_onBlockAdded_2_, this.createNewTileEntity(p_onBlockAdded_1_, 0));
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        p_breakBlock_1_.removeTileEntity(p_breakBlock_2_);
        this.notifyNeighbors(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public boolean eventReceived(IBlockState p_eventReceived_1_, World p_eventReceived_2_, BlockPos p_eventReceived_3_, int p_eventReceived_4_, int p_eventReceived_5_) {
        super.eventReceived(p_eventReceived_1_, p_eventReceived_2_, p_eventReceived_3_, p_eventReceived_4_, p_eventReceived_5_);
        TileEntity tileentity = p_eventReceived_2_.getTileEntity(p_eventReceived_3_);
        return tileentity == null ? false : tileentity.receiveClientEvent(p_eventReceived_4_, p_eventReceived_5_);
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityComparator();
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getHorizontal(p_getStateFromMeta_1_)).withProperty(POWERED, (p_getStateFromMeta_1_ & 8) > 0).withProperty(MODE, (p_getStateFromMeta_1_ & 4) > 0 ? Mode.SUBTRACT : Mode.COMPARE);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(FACING).getHorizontalIndex();
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            i |= 8;
        }
        if (p_getMetaFromState_1_.getValue(MODE) == Mode.SUBTRACT) {
            i |= 4;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, MODE, POWERED);
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_8_.getHorizontalFacing().getOpposite()).withProperty(POWERED, false).withProperty(MODE, Mode.COMPARE);
    }

    @Override
    public void onNeighborChange(IBlockAccess p_onNeighborChange_1_, BlockPos p_onNeighborChange_2_, BlockPos p_onNeighborChange_3_) {
        if (p_onNeighborChange_2_.getY() == p_onNeighborChange_3_.getY() && p_onNeighborChange_1_ instanceof World) {
            this.neighborChanged(p_onNeighborChange_1_.getBlockState(p_onNeighborChange_2_), (World)p_onNeighborChange_1_, p_onNeighborChange_2_, p_onNeighborChange_1_.getBlockState(p_onNeighborChange_3_).getBlock(), p_onNeighborChange_3_);
        }
    }

    @Override
    public boolean getWeakChanges(IBlockAccess p_getWeakChanges_1_, BlockPos p_getWeakChanges_2_) {
        return true;
    }

    public static enum Mode implements IStringSerializable
    {
        COMPARE("compare"),
        SUBTRACT("subtract");

        private final String name;

        private Mode(String p_i45731_3_) {
            this.name = p_i45731_3_;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

