/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockRedstoneDiode
extends BlockHorizontal {
    protected static final AxisAlignedBB REDSTONE_DIODE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected final boolean isRepeaterPowered;

    protected BlockRedstoneDiode(boolean p_i45400_1_) {
        super(Material.CIRCUITS);
        this.isRepeaterPowered = p_i45400_1_;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return REDSTONE_DIODE_AABB;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).isFullyOpaque() ? super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) : false;
    }

    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_) {
        return p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down()).isFullyOpaque();
    }

    @Override
    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!this.isLocked(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_)) {
            boolean flag = this.shouldBePowered(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
            if (this.isRepeaterPowered && !flag) {
                p_updateTick_1_.setBlockState(p_updateTick_2_, this.getUnpoweredState(p_updateTick_3_), 2);
            } else if (!this.isRepeaterPowered) {
                p_updateTick_1_.setBlockState(p_updateTick_2_, this.getPoweredState(p_updateTick_3_), 2);
                if (!flag) {
                    p_updateTick_1_.updateBlockTick(p_updateTick_2_, this.getPoweredState(p_updateTick_3_).getBlock(), this.getTickDelay(p_updateTick_3_), -1);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return p_shouldSideBeRendered_4_.getAxis() != EnumFacing.Axis.Y;
    }

    protected boolean isPowered(IBlockState p_isPowered_1_) {
        return this.isRepeaterPowered;
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_1_.getWeakPower(p_getStrongPower_2_, p_getStrongPower_3_, p_getStrongPower_4_);
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return !this.isPowered(p_getWeakPower_1_) ? 0 : (p_getWeakPower_1_.getValue(FACING) == p_getWeakPower_4_ ? this.getActiveSignal(p_getWeakPower_2_, p_getWeakPower_3_, p_getWeakPower_1_) : 0);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (this.canBlockStay(p_neighborChanged_2_, p_neighborChanged_3_)) {
            this.updateState(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
        } else {
            this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                p_neighborChanged_2_.notifyNeighborsOfStateChange(p_neighborChanged_3_.offset(enumfacing), this, false);
            }
        }
    }

    protected void updateState(World p_updateState_1_, BlockPos p_updateState_2_, IBlockState p_updateState_3_) {
        boolean flag;
        if (!this.isLocked(p_updateState_1_, p_updateState_2_, p_updateState_3_) && this.isRepeaterPowered != (flag = this.shouldBePowered(p_updateState_1_, p_updateState_2_, p_updateState_3_)) && !p_updateState_1_.isBlockTickPending(p_updateState_2_, this)) {
            int i = -1;
            if (this.isFacingTowardsRepeater(p_updateState_1_, p_updateState_2_, p_updateState_3_)) {
                i = -3;
            } else if (this.isRepeaterPowered) {
                i = -2;
            }
            p_updateState_1_.updateBlockTick(p_updateState_2_, this, this.getDelay(p_updateState_3_), i);
        }
    }

    public boolean isLocked(IBlockAccess p_isLocked_1_, BlockPos p_isLocked_2_, IBlockState p_isLocked_3_) {
        return false;
    }

    protected boolean shouldBePowered(World p_shouldBePowered_1_, BlockPos p_shouldBePowered_2_, IBlockState p_shouldBePowered_3_) {
        return this.calculateInputStrength(p_shouldBePowered_1_, p_shouldBePowered_2_, p_shouldBePowered_3_) > 0;
    }

    protected int calculateInputStrength(World p_calculateInputStrength_1_, BlockPos p_calculateInputStrength_2_, IBlockState p_calculateInputStrength_3_) {
        EnumFacing enumfacing = p_calculateInputStrength_3_.getValue(FACING);
        BlockPos blockpos = p_calculateInputStrength_2_.offset(enumfacing);
        int i = p_calculateInputStrength_1_.getRedstonePower(blockpos, enumfacing);
        if (i >= 15) {
            return i;
        }
        IBlockState iblockstate = p_calculateInputStrength_1_.getBlockState(blockpos);
        return Math.max(i, iblockstate.getBlock() == Blocks.REDSTONE_WIRE ? iblockstate.getValue(BlockRedstoneWire.POWER) : 0);
    }

    protected int getPowerOnSides(IBlockAccess p_getPowerOnSides_1_, BlockPos p_getPowerOnSides_2_, IBlockState p_getPowerOnSides_3_) {
        EnumFacing enumfacing = p_getPowerOnSides_3_.getValue(FACING);
        EnumFacing enumfacing1 = enumfacing.rotateY();
        EnumFacing enumfacing2 = enumfacing.rotateYCCW();
        return Math.max(this.getPowerOnSide(p_getPowerOnSides_1_, p_getPowerOnSides_2_.offset(enumfacing1), enumfacing1), this.getPowerOnSide(p_getPowerOnSides_1_, p_getPowerOnSides_2_.offset(enumfacing2), enumfacing2));
    }

    protected int getPowerOnSide(IBlockAccess p_getPowerOnSide_1_, BlockPos p_getPowerOnSide_2_, EnumFacing p_getPowerOnSide_3_) {
        IBlockState iblockstate = p_getPowerOnSide_1_.getBlockState(p_getPowerOnSide_2_);
        Block block = iblockstate.getBlock();
        return this.isAlternateInput(iblockstate) ? (block == Blocks.REDSTONE_BLOCK ? 15 : (block == Blocks.REDSTONE_WIRE ? iblockstate.getValue(BlockRedstoneWire.POWER).intValue() : p_getPowerOnSide_1_.getStrongPower(p_getPowerOnSide_2_, p_getPowerOnSide_3_))) : 0;
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_8_.getHorizontalFacing().getOpposite());
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        if (this.shouldBePowered(p_onBlockPlacedBy_1_, p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_)) {
            p_onBlockPlacedBy_1_.scheduleUpdate(p_onBlockPlacedBy_2_, this, 1);
        }
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        this.notifyNeighbors(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    protected void notifyNeighbors(World p_notifyNeighbors_1_, BlockPos p_notifyNeighbors_2_, IBlockState p_notifyNeighbors_3_) {
        EnumFacing enumfacing = p_notifyNeighbors_3_.getValue(FACING);
        BlockPos blockpos = p_notifyNeighbors_2_.offset(enumfacing.getOpposite());
        if (ForgeEventFactory.onNeighborNotify(p_notifyNeighbors_1_, p_notifyNeighbors_2_, p_notifyNeighbors_1_.getBlockState(p_notifyNeighbors_2_), EnumSet.of(enumfacing.getOpposite()), false).isCanceled()) {
            return;
        }
        p_notifyNeighbors_1_.neighborChanged(blockpos, this, p_notifyNeighbors_2_);
        p_notifyNeighbors_1_.notifyNeighborsOfStateExcept(blockpos, this, enumfacing);
    }

    @Override
    public void onBlockDestroyedByPlayer(World p_onBlockDestroyedByPlayer_1_, BlockPos p_onBlockDestroyedByPlayer_2_, IBlockState p_onBlockDestroyedByPlayer_3_) {
        if (this.isRepeaterPowered) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                p_onBlockDestroyedByPlayer_1_.notifyNeighborsOfStateChange(p_onBlockDestroyedByPlayer_2_.offset(enumfacing), this, false);
            }
        }
        super.onBlockDestroyedByPlayer(p_onBlockDestroyedByPlayer_1_, p_onBlockDestroyedByPlayer_2_, p_onBlockDestroyedByPlayer_3_);
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    protected boolean isAlternateInput(IBlockState p_isAlternateInput_1_) {
        return p_isAlternateInput_1_.canProvidePower();
    }

    protected int getActiveSignal(IBlockAccess p_getActiveSignal_1_, BlockPos p_getActiveSignal_2_, IBlockState p_getActiveSignal_3_) {
        return 15;
    }

    public static boolean isDiode(IBlockState p_isDiode_0_) {
        return Blocks.UNPOWERED_REPEATER.isSameDiode(p_isDiode_0_) || Blocks.UNPOWERED_COMPARATOR.isSameDiode(p_isDiode_0_);
    }

    public boolean isSameDiode(IBlockState p_isSameDiode_1_) {
        Block block = p_isSameDiode_1_.getBlock();
        return block == this.getPoweredState(this.getDefaultState()).getBlock() || block == this.getUnpoweredState(this.getDefaultState()).getBlock();
    }

    public boolean isFacingTowardsRepeater(World p_isFacingTowardsRepeater_1_, BlockPos p_isFacingTowardsRepeater_2_, IBlockState p_isFacingTowardsRepeater_3_) {
        EnumFacing enumfacing = p_isFacingTowardsRepeater_3_.getValue(FACING).getOpposite();
        BlockPos blockpos = p_isFacingTowardsRepeater_2_.offset(enumfacing);
        return BlockRedstoneDiode.isDiode(p_isFacingTowardsRepeater_1_.getBlockState(blockpos)) ? p_isFacingTowardsRepeater_1_.getBlockState(blockpos).getValue(FACING) != enumfacing : false;
    }

    protected int getTickDelay(IBlockState p_getTickDelay_1_) {
        return this.getDelay(p_getTickDelay_1_);
    }

    protected abstract int getDelay(IBlockState var1);

    protected abstract IBlockState getPoweredState(IBlockState var1);

    protected abstract IBlockState getUnpoweredState(IBlockState var1);

    @Override
    public boolean isAssociatedBlock(Block p_isAssociatedBlock_1_) {
        return this.isSameDiode(p_isAssociatedBlock_1_.getDefaultState());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }
}

