/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockRedstoneLight
extends Block {
    private final boolean isOn;

    public BlockRedstoneLight(boolean p_i45421_1_) {
        super(Material.REDSTONE_LIGHT);
        this.isOn = p_i45421_1_;
        if (p_i45421_1_) {
            this.setLightLevel(1.0f);
        }
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (p_onBlockAdded_1_.isRemote) {
            return;
        }
        if (this.isOn && !p_onBlockAdded_1_.isBlockPowered(p_onBlockAdded_2_)) {
            p_onBlockAdded_1_.setBlockState(p_onBlockAdded_2_, Blocks.REDSTONE_LAMP.getDefaultState(), 2);
        } else if (!this.isOn && p_onBlockAdded_1_.isBlockPowered(p_onBlockAdded_2_)) {
            p_onBlockAdded_1_.setBlockState(p_onBlockAdded_2_, Blocks.LIT_REDSTONE_LAMP.getDefaultState(), 2);
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (p_neighborChanged_2_.isRemote) {
            return;
        }
        if (this.isOn && !p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_)) {
            p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, 4);
        } else if (!this.isOn && p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_)) {
            p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, Blocks.LIT_REDSTONE_LAMP.getDefaultState(), 2);
        }
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_1_.isRemote) {
            return;
        }
        if (this.isOn && !p_updateTick_1_.isBlockPowered(p_updateTick_2_)) {
            p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.REDSTONE_LAMP.getDefaultState(), 2);
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(Blocks.REDSTONE_LAMP);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Blocks.REDSTONE_LAMP);
    }

    @Override
    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        return new ItemStack(Blocks.REDSTONE_LAMP);
    }
}

