/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneOre
extends Block {
    private final boolean isOn;

    public BlockRedstoneOre(boolean p_i45420_1_) {
        super(Material.ROCK);
        if (p_i45420_1_) {
            this.setTickRandomly(true);
        }
        this.isOn = p_i45420_1_;
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 30;
    }

    @Override
    public void onBlockClicked(World p_onBlockClicked_1_, BlockPos p_onBlockClicked_2_, EntityPlayer p_onBlockClicked_3_) {
        this.activate(p_onBlockClicked_1_, p_onBlockClicked_2_);
        super.onBlockClicked(p_onBlockClicked_1_, p_onBlockClicked_2_, p_onBlockClicked_3_);
    }

    @Override
    public void onEntityWalk(World p_onEntityWalk_1_, BlockPos p_onEntityWalk_2_, Entity p_onEntityWalk_3_) {
        this.activate(p_onEntityWalk_1_, p_onEntityWalk_2_);
        super.onEntityWalk(p_onEntityWalk_1_, p_onEntityWalk_2_, p_onEntityWalk_3_);
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        this.activate(p_onBlockActivated_1_, p_onBlockActivated_2_);
        return super.onBlockActivated(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, p_onBlockActivated_4_, p_onBlockActivated_5_, p_onBlockActivated_6_, p_onBlockActivated_7_, p_onBlockActivated_8_, p_onBlockActivated_9_);
    }

    private void activate(World p_activate_1_, BlockPos p_activate_2_) {
        this.spawnParticles(p_activate_1_, p_activate_2_);
        if (this == Blocks.REDSTONE_ORE) {
            p_activate_1_.setBlockState(p_activate_2_, Blocks.LIT_REDSTONE_ORE.getDefaultState());
        }
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (this == Blocks.LIT_REDSTONE_ORE) {
            p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.REDSTONE_ORE.getDefaultState());
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.REDSTONE;
    }

    @Override
    public int quantityDroppedWithBonus(int p_quantityDroppedWithBonus_1_, Random p_quantityDroppedWithBonus_2_) {
        return this.quantityDropped(p_quantityDroppedWithBonus_2_) + p_quantityDroppedWithBonus_2_.nextInt(p_quantityDroppedWithBonus_1_ + 1);
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 4 + p_quantityDropped_1_.nextInt(2);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, p_dropBlockAsItemWithChance_5_);
    }

    @Override
    public int getExpDrop(IBlockState p_getExpDrop_1_, IBlockAccess p_getExpDrop_2_, BlockPos p_getExpDrop_3_, int p_getExpDrop_4_) {
        if (this.getItemDropped(p_getExpDrop_1_, RANDOM, p_getExpDrop_4_) != Item.getItemFromBlock(this)) {
            return 1 + RANDOM.nextInt(5);
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        if (this.isOn) {
            this.spawnParticles(p_randomDisplayTick_2_, p_randomDisplayTick_3_);
        }
    }

    private void spawnParticles(World p_spawnParticles_1_, BlockPos p_spawnParticles_2_) {
        Random random = p_spawnParticles_1_.rand;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)p_spawnParticles_2_.getX() + random.nextFloat();
            double d2 = (float)p_spawnParticles_2_.getY() + random.nextFloat();
            double d3 = (float)p_spawnParticles_2_.getZ() + random.nextFloat();
            if (i == 0 && !p_spawnParticles_1_.getBlockState(p_spawnParticles_2_.up()).isOpaqueCube()) {
                d2 = (double)p_spawnParticles_2_.getY() + 0.0625 + 1.0;
            }
            if (i == 1 && !p_spawnParticles_1_.getBlockState(p_spawnParticles_2_.down()).isOpaqueCube()) {
                d2 = (double)p_spawnParticles_2_.getY() - 0.0625;
            }
            if (i == 2 && !p_spawnParticles_1_.getBlockState(p_spawnParticles_2_.south()).isOpaqueCube()) {
                d3 = (double)p_spawnParticles_2_.getZ() + 0.0625 + 1.0;
            }
            if (i == 3 && !p_spawnParticles_1_.getBlockState(p_spawnParticles_2_.north()).isOpaqueCube()) {
                d3 = (double)p_spawnParticles_2_.getZ() - 0.0625;
            }
            if (i == 4 && !p_spawnParticles_1_.getBlockState(p_spawnParticles_2_.east()).isOpaqueCube()) {
                d1 = (double)p_spawnParticles_2_.getX() + 0.0625 + 1.0;
            }
            if (i == 5 && !p_spawnParticles_1_.getBlockState(p_spawnParticles_2_.west()).isOpaqueCube()) {
                d1 = (double)p_spawnParticles_2_.getX() - 0.0625;
            }
            if (!(d1 < (double)p_spawnParticles_2_.getX() || d1 > (double)(p_spawnParticles_2_.getX() + 1) || d2 < 0.0 || d2 > (double)(p_spawnParticles_2_.getY() + 1) || d3 < (double)p_spawnParticles_2_.getZ()) && !(d3 > (double)(p_spawnParticles_2_.getZ() + 1))) continue;
            p_spawnParticles_1_.spawnParticle(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        return new ItemStack(Blocks.REDSTONE_ORE);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Item.getItemFromBlock(Blocks.REDSTONE_ORE), 1, this.damageDropped(p_getItem_3_));
    }
}

