/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneRepeater
extends BlockRedstoneDiode {
    public static final PropertyBool LOCKED = PropertyBool.create("locked");
    public static final PropertyInteger DELAY = PropertyInteger.create("delay", 1, 4);

    protected BlockRedstoneRepeater(boolean p_i45424_1_) {
        super(p_i45424_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(DELAY, 1).withProperty(LOCKED, false));
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal("item.diode.name");
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        return p_getActualState_1_.withProperty(LOCKED, this.isLocked(p_getActualState_2_, p_getActualState_3_, p_getActualState_1_));
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (!p_onBlockActivated_4_.capabilities.allowEdit) {
            return false;
        }
        p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_.cycleProperty(DELAY), 3);
        return true;
    }

    @Override
    protected int getDelay(IBlockState p_getDelay_1_) {
        return p_getDelay_1_.getValue(DELAY) * 2;
    }

    @Override
    protected IBlockState getPoweredState(IBlockState p_getPoweredState_1_) {
        Integer lvt_2_1_ = p_getPoweredState_1_.getValue(DELAY);
        Boolean lvt_3_1_ = p_getPoweredState_1_.getValue(LOCKED);
        EnumFacing lvt_4_1_ = p_getPoweredState_1_.getValue(FACING);
        return Blocks.POWERED_REPEATER.getDefaultState().withProperty(FACING, lvt_4_1_).withProperty(DELAY, lvt_2_1_).withProperty(LOCKED, lvt_3_1_);
    }

    @Override
    protected IBlockState getUnpoweredState(IBlockState p_getUnpoweredState_1_) {
        Integer lvt_2_1_ = p_getUnpoweredState_1_.getValue(DELAY);
        Boolean lvt_3_1_ = p_getUnpoweredState_1_.getValue(LOCKED);
        EnumFacing lvt_4_1_ = p_getUnpoweredState_1_.getValue(FACING);
        return Blocks.UNPOWERED_REPEATER.getDefaultState().withProperty(FACING, lvt_4_1_).withProperty(DELAY, lvt_2_1_).withProperty(LOCKED, lvt_3_1_);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.REPEATER;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.REPEATER);
    }

    @Override
    public boolean isLocked(IBlockAccess p_isLocked_1_, BlockPos p_isLocked_2_, IBlockState p_isLocked_3_) {
        return this.getPowerOnSides(p_isLocked_1_, p_isLocked_2_, p_isLocked_3_) > 0;
    }

    @Override
    protected boolean isAlternateInput(IBlockState p_isAlternateInput_1_) {
        return BlockRedstoneRepeater.isDiode(p_isAlternateInput_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        if (!this.isRepeaterPowered) {
            return;
        }
        EnumFacing lvt_5_1_ = p_randomDisplayTick_1_.getValue(FACING);
        double lvt_6_1_ = (double)((float)p_randomDisplayTick_3_.getX() + 0.5f) + (double)(p_randomDisplayTick_4_.nextFloat() - 0.5f) * 0.2;
        double lvt_8_1_ = (double)((float)p_randomDisplayTick_3_.getY() + 0.4f) + (double)(p_randomDisplayTick_4_.nextFloat() - 0.5f) * 0.2;
        double lvt_10_1_ = (double)((float)p_randomDisplayTick_3_.getZ() + 0.5f) + (double)(p_randomDisplayTick_4_.nextFloat() - 0.5f) * 0.2;
        float lvt_12_1_ = -5.0f;
        if (p_randomDisplayTick_4_.nextBoolean()) {
            lvt_12_1_ = p_randomDisplayTick_1_.getValue(DELAY) * 2 - 1;
        }
        double lvt_13_1_ = (lvt_12_1_ /= 16.0f) * (float)lvt_5_1_.getFrontOffsetX();
        double lvt_15_1_ = lvt_12_1_ * (float)lvt_5_1_.getFrontOffsetZ();
        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.REDSTONE, lvt_6_1_ + lvt_13_1_, lvt_8_1_, lvt_10_1_ + lvt_15_1_, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        this.notifyNeighbors(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getHorizontal(p_getStateFromMeta_1_)).withProperty(LOCKED, false).withProperty(DELAY, 1 + (p_getStateFromMeta_1_ >> 2));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(FACING).getHorizontalIndex();
        return lvt_2_1_ |= p_getMetaFromState_1_.getValue(DELAY) - 1 << 2;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, DELAY, LOCKED);
    }
}

