/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneTorch
extends BlockTorch {
    private static final Map<World, List<Toggle>> toggles = new WeakHashMap<World, List<Toggle>>();
    private final boolean isOn;

    private boolean isBurnedOut(World p_isBurnedOut_1_, BlockPos p_isBurnedOut_2_, boolean p_isBurnedOut_3_) {
        if (!toggles.containsKey(p_isBurnedOut_1_)) {
            toggles.put(p_isBurnedOut_1_, Lists.newArrayList());
        }
        List<Toggle> list = toggles.get(p_isBurnedOut_1_);
        if (p_isBurnedOut_3_) {
            list.add(new Toggle(p_isBurnedOut_2_, p_isBurnedOut_1_.getTotalWorldTime()));
        }
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            Toggle blockredstonetorch$toggle = list.get(j);
            if (!blockredstonetorch$toggle.pos.equals(p_isBurnedOut_2_) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    protected BlockRedstoneTorch(boolean p_i45423_1_) {
        this.isOn = p_i45423_1_;
        this.setTickRandomly(true);
        this.setCreativeTab(null);
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 2;
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (this.isOn) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                p_onBlockAdded_1_.notifyNeighborsOfStateChange(p_onBlockAdded_2_.offset(enumfacing), this, false);
            }
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        if (this.isOn) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_.offset(enumfacing), this, false);
            }
        }
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return this.isOn && p_getWeakPower_1_.getValue(FACING) != p_getWeakPower_4_ ? 15 : 0;
    }

    private boolean shouldBeOff(World p_shouldBeOff_1_, BlockPos p_shouldBeOff_2_, IBlockState p_shouldBeOff_3_) {
        EnumFacing enumfacing = p_shouldBeOff_3_.getValue(FACING).getOpposite();
        return p_shouldBeOff_1_.isSidePowered(p_shouldBeOff_2_.offset(enumfacing), enumfacing);
    }

    @Override
    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        boolean flag = this.shouldBeOff(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
        List<Toggle> list = toggles.get(p_updateTick_1_);
        while (list != null && !list.isEmpty() && p_updateTick_1_.getTotalWorldTime() - list.get((int)0).time > 60L) {
            list.remove(0);
        }
        if (this.isOn) {
            if (flag) {
                p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.UNLIT_REDSTONE_TORCH.getDefaultState().withProperty(FACING, p_updateTick_3_.getValue(FACING)), 3);
                if (this.isBurnedOut(p_updateTick_1_, p_updateTick_2_, true)) {
                    p_updateTick_1_.playSound(null, p_updateTick_2_, SoundEvents.BLOCK_REDSTONE_TORCH_BURNOUT, SoundCategory.BLOCKS, 0.5f, 2.6f + (p_updateTick_1_.rand.nextFloat() - p_updateTick_1_.rand.nextFloat()) * 0.8f);
                    for (int i = 0; i < 5; ++i) {
                        double d0 = (double)p_updateTick_2_.getX() + p_updateTick_4_.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)p_updateTick_2_.getY() + p_updateTick_4_.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)p_updateTick_2_.getZ() + p_updateTick_4_.nextDouble() * 0.6 + 0.2;
                        p_updateTick_1_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                    }
                    p_updateTick_1_.scheduleUpdate(p_updateTick_2_, p_updateTick_1_.getBlockState(p_updateTick_2_).getBlock(), 160);
                }
            }
        } else if (!flag && !this.isBurnedOut(p_updateTick_1_, p_updateTick_2_, false)) {
            p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.REDSTONE_TORCH.getDefaultState().withProperty(FACING, p_updateTick_3_.getValue(FACING)), 3);
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!this.onNeighborChangeInternal(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_) && this.isOn == this.shouldBeOff(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_)) {
            p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, this.tickRate(p_neighborChanged_2_));
        }
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_4_ == EnumFacing.DOWN ? p_getStrongPower_1_.getWeakPower(p_getStrongPower_2_, p_getStrongPower_3_, p_getStrongPower_4_) : 0;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(Blocks.REDSTONE_TORCH);
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        if (this.isOn) {
            double d0 = (double)p_randomDisplayTick_3_.getX() + 0.5 + (p_randomDisplayTick_4_.nextDouble() - 0.5) * 0.2;
            double d1 = (double)p_randomDisplayTick_3_.getY() + 0.7 + (p_randomDisplayTick_4_.nextDouble() - 0.5) * 0.2;
            double d2 = (double)p_randomDisplayTick_3_.getZ() + 0.5 + (p_randomDisplayTick_4_.nextDouble() - 0.5) * 0.2;
            EnumFacing enumfacing = p_randomDisplayTick_1_.getValue(FACING);
            if (enumfacing.getAxis().isHorizontal()) {
                EnumFacing enumfacing1 = enumfacing.getOpposite();
                double d3 = 0.27;
                d0 += 0.27 * (double)enumfacing1.getFrontOffsetX();
                d1 += 0.22;
                d2 += 0.27 * (double)enumfacing1.getFrontOffsetZ();
            }
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.REDSTONE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Blocks.REDSTONE_TORCH);
    }

    @Override
    public boolean isAssociatedBlock(Block p_isAssociatedBlock_1_) {
        return p_isAssociatedBlock_1_ == Blocks.UNLIT_REDSTONE_TORCH || p_isAssociatedBlock_1_ == Blocks.REDSTONE_TORCH;
    }

    static class Toggle {
        BlockPos pos;
        long time;

        public Toggle(BlockPos p_i45688_1_, long p_i45688_2_) {
            this.pos = p_i45688_1_;
            this.time = p_i45688_2_;
        }
    }
}

