/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneWire
extends Block {
    public static final PropertyEnum<EnumAttachPosition> NORTH = PropertyEnum.create("north", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> EAST = PropertyEnum.create("east", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> SOUTH = PropertyEnum.create("south", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> WEST = PropertyEnum.create("west", EnumAttachPosition.class);
    public static final PropertyInteger POWER = PropertyInteger.create("power", 0, 15);
    protected static final AxisAlignedBB[] REDSTONE_WIRE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0)};
    private boolean canProvidePower = true;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public BlockRedstoneWire() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(NORTH, EnumAttachPosition.NONE).withProperty(EAST, EnumAttachPosition.NONE).withProperty(SOUTH, EnumAttachPosition.NONE).withProperty(WEST, EnumAttachPosition.NONE).withProperty(POWER, 0));
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return REDSTONE_WIRE_AABB[BlockRedstoneWire.getAABBIndex(p_getBoundingBox_1_.getActualState(p_getBoundingBox_2_, p_getBoundingBox_3_))];
    }

    private static int getAABBIndex(IBlockState p_getAABBIndex_0_) {
        boolean flag3;
        int i = 0;
        boolean flag = p_getAABBIndex_0_.getValue(NORTH) != EnumAttachPosition.NONE;
        boolean flag1 = p_getAABBIndex_0_.getValue(EAST) != EnumAttachPosition.NONE;
        boolean flag2 = p_getAABBIndex_0_.getValue(SOUTH) != EnumAttachPosition.NONE;
        boolean bl = flag3 = p_getAABBIndex_0_.getValue(WEST) != EnumAttachPosition.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << EnumFacing.NORTH.getHorizontalIndex();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << EnumFacing.EAST.getHorizontalIndex();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << EnumFacing.SOUTH.getHorizontalIndex();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << EnumFacing.WEST.getHorizontalIndex();
        }
        return i;
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        p_getActualState_1_ = p_getActualState_1_.withProperty(WEST, this.getAttachPosition(p_getActualState_2_, p_getActualState_3_, EnumFacing.WEST));
        p_getActualState_1_ = p_getActualState_1_.withProperty(EAST, this.getAttachPosition(p_getActualState_2_, p_getActualState_3_, EnumFacing.EAST));
        p_getActualState_1_ = p_getActualState_1_.withProperty(NORTH, this.getAttachPosition(p_getActualState_2_, p_getActualState_3_, EnumFacing.NORTH));
        p_getActualState_1_ = p_getActualState_1_.withProperty(SOUTH, this.getAttachPosition(p_getActualState_2_, p_getActualState_3_, EnumFacing.SOUTH));
        return p_getActualState_1_;
    }

    private EnumAttachPosition getAttachPosition(IBlockAccess p_getAttachPosition_1_, BlockPos p_getAttachPosition_2_, EnumFacing p_getAttachPosition_3_) {
        BlockPos blockpos = p_getAttachPosition_2_.offset(p_getAttachPosition_3_);
        IBlockState iblockstate = p_getAttachPosition_1_.getBlockState(p_getAttachPosition_2_.offset(p_getAttachPosition_3_));
        if (!(BlockRedstoneWire.canConnectTo(p_getAttachPosition_1_.getBlockState(blockpos), p_getAttachPosition_3_, p_getAttachPosition_1_, blockpos) || !iblockstate.isNormalCube() && BlockRedstoneWire.canConnectUpwardsTo(p_getAttachPosition_1_, blockpos.down()))) {
            IBlockState iblockstate1 = p_getAttachPosition_1_.getBlockState(p_getAttachPosition_2_.up());
            if (!iblockstate1.isNormalCube()) {
                boolean flag;
                boolean bl = flag = p_getAttachPosition_1_.getBlockState(blockpos).isSideSolid(p_getAttachPosition_1_, blockpos, EnumFacing.UP) || p_getAttachPosition_1_.getBlockState(blockpos).getBlock() == Blocks.GLOWSTONE;
                if (flag && BlockRedstoneWire.canConnectUpwardsTo(p_getAttachPosition_1_, blockpos.up())) {
                    if (iblockstate.isBlockNormalCube()) {
                        return EnumAttachPosition.UP;
                    }
                    return EnumAttachPosition.SIDE;
                }
            }
            return EnumAttachPosition.NONE;
        }
        return EnumAttachPosition.SIDE;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).isFullyOpaque() || p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).getBlock() == Blocks.GLOWSTONE;
    }

    private IBlockState updateSurroundingRedstone(World p_updateSurroundingRedstone_1_, BlockPos p_updateSurroundingRedstone_2_, IBlockState p_updateSurroundingRedstone_3_) {
        p_updateSurroundingRedstone_3_ = this.calculateCurrentChanges(p_updateSurroundingRedstone_1_, p_updateSurroundingRedstone_2_, p_updateSurroundingRedstone_2_, p_updateSurroundingRedstone_3_);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            p_updateSurroundingRedstone_1_.notifyNeighborsOfStateChange(blockpos, this, false);
        }
        return p_updateSurroundingRedstone_3_;
    }

    private IBlockState calculateCurrentChanges(World p_calculateCurrentChanges_1_, BlockPos p_calculateCurrentChanges_2_, BlockPos p_calculateCurrentChanges_3_, IBlockState p_calculateCurrentChanges_4_) {
        IBlockState iblockstate = p_calculateCurrentChanges_4_;
        int i = p_calculateCurrentChanges_4_.getValue(POWER);
        int j = 0;
        j = this.getMaxCurrentStrength(p_calculateCurrentChanges_1_, p_calculateCurrentChanges_3_, j);
        this.canProvidePower = false;
        int k = p_calculateCurrentChanges_1_.isBlockIndirectlyGettingPowered(p_calculateCurrentChanges_2_);
        this.canProvidePower = true;
        if (k > 0 && k > j - 1) {
            j = k;
        }
        int l = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            boolean flag;
            BlockPos blockpos = p_calculateCurrentChanges_2_.offset(enumfacing);
            boolean bl = flag = blockpos.getX() != p_calculateCurrentChanges_3_.getX() || blockpos.getZ() != p_calculateCurrentChanges_3_.getZ();
            if (flag) {
                l = this.getMaxCurrentStrength(p_calculateCurrentChanges_1_, blockpos, l);
            }
            if (p_calculateCurrentChanges_1_.getBlockState(blockpos).isNormalCube() && !p_calculateCurrentChanges_1_.getBlockState(p_calculateCurrentChanges_2_.up()).isNormalCube()) {
                if (!flag || p_calculateCurrentChanges_2_.getY() < p_calculateCurrentChanges_3_.getY()) continue;
                l = this.getMaxCurrentStrength(p_calculateCurrentChanges_1_, blockpos.up(), l);
                continue;
            }
            if (p_calculateCurrentChanges_1_.getBlockState(blockpos).isNormalCube() || !flag || p_calculateCurrentChanges_2_.getY() > p_calculateCurrentChanges_3_.getY()) continue;
            l = this.getMaxCurrentStrength(p_calculateCurrentChanges_1_, blockpos.down(), l);
        }
        j = l > j ? l - 1 : (j > 0 ? --j : 0);
        if (k > j - 1) {
            j = k;
        }
        if (i != j) {
            p_calculateCurrentChanges_4_ = p_calculateCurrentChanges_4_.withProperty(POWER, j);
            if (p_calculateCurrentChanges_1_.getBlockState(p_calculateCurrentChanges_2_) == iblockstate) {
                p_calculateCurrentChanges_1_.setBlockState(p_calculateCurrentChanges_2_, p_calculateCurrentChanges_4_, 2);
            }
            this.blocksNeedingUpdate.add(p_calculateCurrentChanges_2_);
            for (EnumFacing enumfacing1 : EnumFacing.values()) {
                this.blocksNeedingUpdate.add(p_calculateCurrentChanges_2_.offset(enumfacing1));
            }
        }
        return p_calculateCurrentChanges_4_;
    }

    private void notifyWireNeighborsOfStateChange(World p_notifyWireNeighborsOfStateChange_1_, BlockPos p_notifyWireNeighborsOfStateChange_2_) {
        if (p_notifyWireNeighborsOfStateChange_1_.getBlockState(p_notifyWireNeighborsOfStateChange_2_).getBlock() == this) {
            p_notifyWireNeighborsOfStateChange_1_.notifyNeighborsOfStateChange(p_notifyWireNeighborsOfStateChange_2_, this, false);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                p_notifyWireNeighborsOfStateChange_1_.notifyNeighborsOfStateChange(p_notifyWireNeighborsOfStateChange_2_.offset(enumfacing), this, false);
            }
        }
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (!p_onBlockAdded_1_.isRemote) {
            this.updateSurroundingRedstone(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
            for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
                p_onBlockAdded_1_.notifyNeighborsOfStateChange(p_onBlockAdded_2_.offset(enumfacing), this, false);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(p_onBlockAdded_1_, p_onBlockAdded_2_.offset(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = p_onBlockAdded_2_.offset(enumfacing2);
                if (p_onBlockAdded_1_.getBlockState(blockpos).isNormalCube()) {
                    this.notifyWireNeighborsOfStateChange(p_onBlockAdded_1_, blockpos.up());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(p_onBlockAdded_1_, blockpos.down());
            }
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        if (!p_breakBlock_1_.isRemote) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_.offset(enumfacing), this, false);
            }
            this.updateSurroundingRedstone(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(p_breakBlock_1_, p_breakBlock_2_.offset(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = p_breakBlock_2_.offset(enumfacing2);
                if (p_breakBlock_1_.getBlockState(blockpos).isNormalCube()) {
                    this.notifyWireNeighborsOfStateChange(p_breakBlock_1_, blockpos.up());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(p_breakBlock_1_, blockpos.down());
            }
        }
    }

    private int getMaxCurrentStrength(World p_getMaxCurrentStrength_1_, BlockPos p_getMaxCurrentStrength_2_, int p_getMaxCurrentStrength_3_) {
        if (p_getMaxCurrentStrength_1_.getBlockState(p_getMaxCurrentStrength_2_).getBlock() != this) {
            return p_getMaxCurrentStrength_3_;
        }
        int i = p_getMaxCurrentStrength_1_.getBlockState(p_getMaxCurrentStrength_2_).getValue(POWER);
        return i > p_getMaxCurrentStrength_3_ ? i : p_getMaxCurrentStrength_3_;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.isRemote) {
            if (this.canPlaceBlockAt(p_neighborChanged_2_, p_neighborChanged_3_)) {
                this.updateSurroundingRedstone(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
            } else {
                this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            }
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.REDSTONE;
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return !this.canProvidePower ? 0 : p_getStrongPower_1_.getWeakPower(p_getStrongPower_2_, p_getStrongPower_3_, p_getStrongPower_4_);
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        if (!this.canProvidePower) {
            return 0;
        }
        int i = p_getWeakPower_1_.getValue(POWER);
        if (i == 0) {
            return 0;
        }
        if (p_getWeakPower_4_ == EnumFacing.UP) {
            return i;
        }
        EnumSet<EnumFacing> enumset = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.isPowerSourceAt(p_getWeakPower_2_, p_getWeakPower_3_, enumfacing)) continue;
            enumset.add(enumfacing);
        }
        if (p_getWeakPower_4_.getAxis().isHorizontal() && enumset.isEmpty()) {
            return i;
        }
        if (enumset.contains(p_getWeakPower_4_) && !enumset.contains(p_getWeakPower_4_.rotateYCCW()) && !enumset.contains(p_getWeakPower_4_.rotateY())) {
            return i;
        }
        return 0;
    }

    private boolean isPowerSourceAt(IBlockAccess p_isPowerSourceAt_1_, BlockPos p_isPowerSourceAt_2_, EnumFacing p_isPowerSourceAt_3_) {
        BlockPos blockpos = p_isPowerSourceAt_2_.offset(p_isPowerSourceAt_3_);
        IBlockState iblockstate = p_isPowerSourceAt_1_.getBlockState(blockpos);
        boolean flag = iblockstate.isNormalCube();
        boolean flag1 = p_isPowerSourceAt_1_.getBlockState(p_isPowerSourceAt_2_.up()).isNormalCube();
        return !flag1 && flag && BlockRedstoneWire.canConnectUpwardsTo(p_isPowerSourceAt_1_, blockpos.up()) ? true : (BlockRedstoneWire.canConnectTo(iblockstate, p_isPowerSourceAt_3_, p_isPowerSourceAt_1_, p_isPowerSourceAt_2_) ? true : (iblockstate.getBlock() == Blocks.POWERED_REPEATER && iblockstate.getValue(BlockRedstoneDiode.FACING) == p_isPowerSourceAt_3_ ? true : !flag && BlockRedstoneWire.canConnectUpwardsTo(p_isPowerSourceAt_1_, blockpos.down())));
    }

    protected static boolean canConnectUpwardsTo(IBlockAccess p_canConnectUpwardsTo_0_, BlockPos p_canConnectUpwardsTo_1_) {
        return BlockRedstoneWire.canConnectTo(p_canConnectUpwardsTo_0_.getBlockState(p_canConnectUpwardsTo_1_), null, p_canConnectUpwardsTo_0_, p_canConnectUpwardsTo_1_);
    }

    protected static boolean canConnectTo(IBlockState p_canConnectTo_0_, EnumFacing p_canConnectTo_1_, IBlockAccess p_canConnectTo_2_, BlockPos p_canConnectTo_3_) {
        Block block = p_canConnectTo_0_.getBlock();
        if (block == Blocks.REDSTONE_WIRE) {
            return true;
        }
        if (Blocks.UNPOWERED_REPEATER.isSameDiode(p_canConnectTo_0_)) {
            EnumFacing enumfacing = p_canConnectTo_0_.getValue(BlockRedstoneRepeater.FACING);
            return enumfacing == p_canConnectTo_1_ || enumfacing.getOpposite() == p_canConnectTo_1_;
        }
        return Blocks.OBSERVER == p_canConnectTo_0_.getBlock() ? p_canConnectTo_1_ == p_canConnectTo_0_.getValue(BlockObserver.FACING) : p_canConnectTo_0_.getBlock().canConnectRedstone(p_canConnectTo_0_, p_canConnectTo_2_, p_canConnectTo_3_, p_canConnectTo_1_);
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return this.canProvidePower;
    }

    @SideOnly(value=Side.CLIENT)
    public static int colorMultiplier(int p_colorMultiplier_0_) {
        float f = (float)p_colorMultiplier_0_ / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (p_colorMultiplier_0_ == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        int i = MathHelper.clamp((int)(f1 * 255.0f), 0, 255);
        int j = MathHelper.clamp((int)(f2 * 255.0f), 0, 255);
        int k = MathHelper.clamp((int)(f3 * 255.0f), 0, 255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        int i = p_randomDisplayTick_1_.getValue(POWER);
        if (i != 0) {
            double d0 = (double)p_randomDisplayTick_3_.getX() + 0.5 + ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.2;
            double d1 = (float)p_randomDisplayTick_3_.getY() + 0.0625f;
            double d2 = (double)p_randomDisplayTick_3_.getZ() + 0.5 + ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.REDSTONE, d0, d1, d2, (double)f1, (double)f2, (double)f3, new int[0]);
        }
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.REDSTONE);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(POWER, p_getStateFromMeta_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(POWER);
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(SOUTH)).withProperty(EAST, p_withRotation_1_.getValue(WEST)).withProperty(SOUTH, p_withRotation_1_.getValue(NORTH)).withProperty(WEST, p_withRotation_1_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(EAST)).withProperty(EAST, p_withRotation_1_.getValue(SOUTH)).withProperty(SOUTH, p_withRotation_1_.getValue(WEST)).withProperty(WEST, p_withRotation_1_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(WEST)).withProperty(EAST, p_withRotation_1_.getValue(NORTH)).withProperty(SOUTH, p_withRotation_1_.getValue(EAST)).withProperty(WEST, p_withRotation_1_.getValue(SOUTH));
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                return p_withMirror_1_.withProperty(NORTH, p_withMirror_1_.getValue(SOUTH)).withProperty(SOUTH, p_withMirror_1_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return p_withMirror_1_.withProperty(EAST, p_withMirror_1_.getValue(WEST)).withProperty(WEST, p_withMirror_1_.getValue(EAST));
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, NORTH, EAST, SOUTH, WEST, POWER);
    }

    static enum EnumAttachPosition implements IStringSerializable
    {
        UP("up"),
        SIDE("side"),
        NONE("none");

        private final String name;

        private EnumAttachPosition(String p_i45689_3_) {
            this.name = p_i45689_3_;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

