/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReed
extends Block
implements IPlantable {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 15);
    protected static final AxisAlignedBB REED_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    protected BlockReed() {
        super(Material.PLANTS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AGE, 0));
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return REED_AABB;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if ((p_updateTick_1_.getBlockState(p_updateTick_2_.down()).getBlock() == Blocks.REEDS || this.checkForDrop(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_)) && p_updateTick_1_.isAirBlock(p_updateTick_2_.up())) {
            int i = 1;
            while (p_updateTick_1_.getBlockState(p_updateTick_2_.down(i)).getBlock() == this) {
                ++i;
            }
            if (i < 3) {
                int j = p_updateTick_3_.getValue(AGE);
                if (ForgeHooks.onCropsGrowPre(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, true)) {
                    if (j == 15) {
                        p_updateTick_1_.setBlockState(p_updateTick_2_.up(), this.getDefaultState());
                        p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(AGE, 0), 4);
                    } else {
                        p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(AGE, j + 1), 4);
                    }
                    ForgeHooks.onCropsGrowPost(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_1_.getBlockState(p_updateTick_2_));
                }
            }
        }
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        IBlockState state = p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down());
        Block block = state.getBlock();
        if (block.canSustainPlant(state, p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.down(), EnumFacing.UP, this)) {
            return true;
        }
        if (block == this) {
            return true;
        }
        if (block != Blocks.GRASS && block != Blocks.DIRT && block != Blocks.SAND) {
            return false;
        }
        BlockPos blockpos = p_canPlaceBlockAt_2_.down();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = p_canPlaceBlockAt_1_.getBlockState(blockpos.offset(enumfacing));
            if (iblockstate.getMaterial() != Material.WATER && iblockstate.getBlock() != Blocks.FROSTED_ICE) continue;
            return true;
        }
        return false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        this.checkForDrop(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
    }

    protected final boolean checkForDrop(World p_checkForDrop_1_, BlockPos p_checkForDrop_2_, IBlockState p_checkForDrop_3_) {
        if (this.canBlockStay(p_checkForDrop_1_, p_checkForDrop_2_)) {
            return true;
        }
        this.dropBlockAsItem(p_checkForDrop_1_, p_checkForDrop_2_, p_checkForDrop_3_, 0);
        p_checkForDrop_1_.setBlockToAir(p_checkForDrop_2_);
        return false;
    }

    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_) {
        return this.canPlaceBlockAt(p_canBlockStay_1_, p_canBlockStay_2_);
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.REEDS;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.REEDS);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AGE, p_getStateFromMeta_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(AGE);
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess p_getPlantType_1_, BlockPos p_getPlantType_2_) {
        return EnumPlantType.Beach;
    }

    @Override
    public IBlockState getPlant(IBlockAccess p_getPlant_1_, BlockPos p_getPlant_2_) {
        return this.getDefaultState();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE);
    }
}

