/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockRotatedPillar
extends Block {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.create("axis", EnumFacing.Axis.class);

    protected BlockRotatedPillar(Material p_i45425_1_) {
        super(p_i45425_1_, p_i45425_1_.getMaterialMapColor());
    }

    protected BlockRotatedPillar(Material p_i46385_1_, MapColor p_i46385_2_) {
        super(p_i46385_1_, p_i46385_2_);
    }

    @Override
    public boolean rotateBlock(World p_rotateBlock_1_, BlockPos p_rotateBlock_2_, EnumFacing p_rotateBlock_3_) {
        IBlockState state = p_rotateBlock_1_.getBlockState(p_rotateBlock_2_);
        for (IProperty prop : state.getProperties().keySet()) {
            if (!prop.getName().equals("axis")) continue;
            p_rotateBlock_1_.setBlockState(p_rotateBlock_2_, state.cycleProperty(prop));
            return true;
        }
        return false;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(AXIS)) {
                    case X: {
                        return p_withRotation_1_.withProperty(AXIS, EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return p_withRotation_1_.withProperty(AXIS, EnumFacing.Axis.X);
                    }
                }
                return p_withRotation_1_;
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Y;
        int i = p_getStateFromMeta_1_ & 0xC;
        if (i == 4) {
            enumfacing$axis = EnumFacing.Axis.X;
        } else if (i == 8) {
            enumfacing$axis = EnumFacing.Axis.Z;
        }
        return this.getDefaultState().withProperty(AXIS, enumfacing$axis);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        EnumFacing.Axis enumfacing$axis = p_getMetaFromState_1_.getValue(AXIS);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            i |= 4;
        } else if (enumfacing$axis == EnumFacing.Axis.Z) {
            i |= 8;
        }
        return i;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AXIS);
    }

    @Override
    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        return new ItemStack(Item.getItemFromBlock(this));
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return super.getStateForPlacement(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_, p_getStateForPlacement_4_, p_getStateForPlacement_5_, p_getStateForPlacement_6_, p_getStateForPlacement_7_, p_getStateForPlacement_8_).withProperty(AXIS, p_getStateForPlacement_3_.getAxis());
    }
}

