/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSapling
extends BlockBush
implements IGrowable {
    public static final PropertyEnum<BlockPlanks.EnumType> TYPE = PropertyEnum.create("type", BlockPlanks.EnumType.class);
    public static final PropertyInteger STAGE = PropertyInteger.create("stage", 0, 1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, 0.9f, 0.8f, 0.9f);

    protected BlockSapling() {
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPE, BlockPlanks.EnumType.OAK).withProperty(STAGE, 0));
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return SAPLING_AABB;
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal(this.getUnlocalizedName() + "." + BlockPlanks.EnumType.OAK.getUnlocalizedName() + ".name");
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote) {
            super.updateTick(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_);
            if (p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_.up()) >= 9 && p_updateTick_4_.nextInt(7) == 0) {
                this.grow(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_);
            }
        }
    }

    public void grow(World p_grow_1_, BlockPos p_grow_2_, IBlockState p_grow_3_, Random p_grow_4_) {
        if (p_grow_3_.getValue(STAGE) == 0) {
            p_grow_1_.setBlockState(p_grow_2_, p_grow_3_.cycleProperty(STAGE), 4);
        } else {
            this.generateTree(p_grow_1_, p_grow_2_, p_grow_3_, p_grow_4_);
        }
    }

    public void generateTree(World p_generateTree_1_, BlockPos p_generateTree_2_, IBlockState p_generateTree_3_, Random p_generateTree_4_) {
        if (!TerrainGen.saplingGrowTree(p_generateTree_1_, p_generateTree_4_, p_generateTree_2_)) {
            return;
        }
        WorldGenAbstractTree worldgenerator = p_generateTree_4_.nextInt(10) == 0 ? new WorldGenBigTree(true) : new WorldGenTrees(true);
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch (p_generateTree_3_.getValue(TYPE)) {
            case SPRUCE: {
                block7: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(p_generateTree_1_, p_generateTree_2_, i, j, BlockPlanks.EnumType.SPRUCE)) continue;
                        worldgenerator = new WorldGenMegaPineTree(false, p_generateTree_4_.nextBoolean());
                        flag = true;
                        break block7;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenTaiga2(true);
                break;
            }
            case BIRCH: {
                worldgenerator = new WorldGenBirchTree(true, false);
                break;
            }
            case JUNGLE: {
                IBlockState iblockstate = Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.JUNGLE);
                IBlockState iblockstate1 = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.JUNGLE).withProperty(BlockLeaves.CHECK_DECAY, false);
                block9: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(p_generateTree_1_, p_generateTree_2_, i, j, BlockPlanks.EnumType.JUNGLE)) continue;
                        worldgenerator = new WorldGenMegaJungle(true, 10, 20, iblockstate, iblockstate1);
                        flag = true;
                        break block9;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenTrees(true, 4 + p_generateTree_4_.nextInt(7), iblockstate, iblockstate1, false);
                break;
            }
            case ACACIA: {
                worldgenerator = new WorldGenSavannaTree(true);
                break;
            }
            case DARK_OAK: {
                block11: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(p_generateTree_1_, p_generateTree_2_, i, j, BlockPlanks.EnumType.DARK_OAK)) continue;
                        worldgenerator = new WorldGenCanopyTree(true);
                        flag = true;
                        break block11;
                    }
                }
                if (flag) break;
                return;
            }
        }
        IBlockState iblockstate2 = Blocks.AIR.getDefaultState();
        if (flag) {
            p_generateTree_1_.setBlockState(p_generateTree_2_.add(i, 0, j), iblockstate2, 4);
            p_generateTree_1_.setBlockState(p_generateTree_2_.add(i + 1, 0, j), iblockstate2, 4);
            p_generateTree_1_.setBlockState(p_generateTree_2_.add(i, 0, j + 1), iblockstate2, 4);
            p_generateTree_1_.setBlockState(p_generateTree_2_.add(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            p_generateTree_1_.setBlockState(p_generateTree_2_, iblockstate2, 4);
        }
        if (!((WorldGenerator)worldgenerator).generate(p_generateTree_1_, p_generateTree_4_, p_generateTree_2_.add(i, 0, j))) {
            if (flag) {
                p_generateTree_1_.setBlockState(p_generateTree_2_.add(i, 0, j), p_generateTree_3_, 4);
                p_generateTree_1_.setBlockState(p_generateTree_2_.add(i + 1, 0, j), p_generateTree_3_, 4);
                p_generateTree_1_.setBlockState(p_generateTree_2_.add(i, 0, j + 1), p_generateTree_3_, 4);
                p_generateTree_1_.setBlockState(p_generateTree_2_.add(i + 1, 0, j + 1), p_generateTree_3_, 4);
            } else {
                p_generateTree_1_.setBlockState(p_generateTree_2_, p_generateTree_3_, 4);
            }
        }
    }

    private boolean isTwoByTwoOfType(World p_isTwoByTwoOfType_1_, BlockPos p_isTwoByTwoOfType_2_, int p_isTwoByTwoOfType_3_, int p_isTwoByTwoOfType_4_, BlockPlanks.EnumType p_isTwoByTwoOfType_5_) {
        return this.isTypeAt(p_isTwoByTwoOfType_1_, p_isTwoByTwoOfType_2_.add(p_isTwoByTwoOfType_3_, 0, p_isTwoByTwoOfType_4_), p_isTwoByTwoOfType_5_) && this.isTypeAt(p_isTwoByTwoOfType_1_, p_isTwoByTwoOfType_2_.add(p_isTwoByTwoOfType_3_ + 1, 0, p_isTwoByTwoOfType_4_), p_isTwoByTwoOfType_5_) && this.isTypeAt(p_isTwoByTwoOfType_1_, p_isTwoByTwoOfType_2_.add(p_isTwoByTwoOfType_3_, 0, p_isTwoByTwoOfType_4_ + 1), p_isTwoByTwoOfType_5_) && this.isTypeAt(p_isTwoByTwoOfType_1_, p_isTwoByTwoOfType_2_.add(p_isTwoByTwoOfType_3_ + 1, 0, p_isTwoByTwoOfType_4_ + 1), p_isTwoByTwoOfType_5_);
    }

    public boolean isTypeAt(World p_isTypeAt_1_, BlockPos p_isTypeAt_2_, BlockPlanks.EnumType p_isTypeAt_3_) {
        IBlockState iblockstate = p_isTypeAt_1_.getBlockState(p_isTypeAt_2_);
        return iblockstate.getBlock() == this && iblockstate.getValue(TYPE) == p_isTypeAt_3_;
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(TYPE).getMetadata();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        for (BlockPlanks.EnumType blockplanks$enumtype : BlockPlanks.EnumType.values()) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, blockplanks$enumtype.getMetadata()));
        }
    }

    @Override
    public boolean canGrow(World p_canGrow_1_, BlockPos p_canGrow_2_, IBlockState p_canGrow_3_, boolean p_canGrow_4_) {
        return true;
    }

    @Override
    public boolean canUseBonemeal(World p_canUseBonemeal_1_, Random p_canUseBonemeal_2_, BlockPos p_canUseBonemeal_3_, IBlockState p_canUseBonemeal_4_) {
        return (double)p_canUseBonemeal_1_.rand.nextFloat() < 0.45;
    }

    @Override
    public void grow(World p_grow_1_, Random p_grow_2_, BlockPos p_grow_3_, IBlockState p_grow_4_) {
        this.grow(p_grow_1_, p_grow_3_, p_grow_4_, p_grow_2_);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(TYPE, BlockPlanks.EnumType.byMetadata(p_getStateFromMeta_1_ & 7)).withProperty(STAGE, (p_getStateFromMeta_1_ & 8) >> 3);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(TYPE).getMetadata();
        return i |= p_getMetaFromState_1_.getValue(STAGE) << 3;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, TYPE, STAGE);
    }
}

