/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShulkerBox
extends BlockContainer {
    public static final PropertyEnum<EnumFacing> FACING = PropertyDirection.create("facing");
    private final EnumDyeColor color;

    public BlockShulkerBox(EnumDyeColor p_i47248_1_) {
        super(Material.ROCK, MapColor.AIR);
        this.color = p_i47248_1_;
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.UP));
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityShulkerBox(this.color);
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean causesSuffocation(IBlockState p_causesSuffocation_1_) {
        return true;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomBreakingProgress(IBlockState p_hasCustomBreakingProgress_1_) {
        return true;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        if (p_onBlockActivated_4_.isSpectator()) {
            return true;
        }
        TileEntity lvt_10_1_ = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (lvt_10_1_ instanceof TileEntityShulkerBox) {
            boolean lvt_12_2_;
            EnumFacing lvt_11_1_ = p_onBlockActivated_3_.getValue(FACING);
            if (((TileEntityShulkerBox)lvt_10_1_).getAnimationStatus() == TileEntityShulkerBox.AnimationStatus.CLOSED) {
                AxisAlignedBB lvt_13_1_ = FULL_BLOCK_AABB.addCoord(0.5f * (float)lvt_11_1_.getFrontOffsetX(), 0.5f * (float)lvt_11_1_.getFrontOffsetY(), 0.5f * (float)lvt_11_1_.getFrontOffsetZ()).contract(lvt_11_1_.getFrontOffsetX(), lvt_11_1_.getFrontOffsetY(), lvt_11_1_.getFrontOffsetZ());
                boolean lvt_12_1_ = !p_onBlockActivated_1_.collidesWithAnyBlock(lvt_13_1_.offset(p_onBlockActivated_2_.offset(lvt_11_1_)));
            } else {
                lvt_12_2_ = true;
            }
            if (lvt_12_2_) {
                p_onBlockActivated_4_.addStat(StatList.OPEN_SHULKER_BOX);
                p_onBlockActivated_4_.displayGUIChest((IInventory)((Object)lvt_10_1_));
            }
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_3_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(FACING).getIndex();
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        EnumFacing lvt_2_1_ = EnumFacing.getFront(p_getStateFromMeta_1_);
        return this.getDefaultState().withProperty(FACING, lvt_2_1_);
    }

    @Override
    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
        TileEntityShulkerBox lvt_5_1_ = (TileEntityShulkerBox)p_onBlockHarvested_1_.getTileEntity(p_onBlockHarvested_2_);
        lvt_5_1_.setDestroyedByCreativePlayer(p_onBlockHarvested_4_.capabilities.isCreativeMode);
        lvt_5_1_.fillWithLoot(p_onBlockHarvested_4_);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity lvt_6_1_;
        if (p_onBlockPlacedBy_5_.hasDisplayName() && (lvt_6_1_ = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_)) instanceof TileEntityShulkerBox) {
            ((TileEntityShulkerBox)lvt_6_1_).setCustomName(p_onBlockPlacedBy_5_.getDisplayName());
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        TileEntity lvt_4_1_ = p_breakBlock_1_.getTileEntity(p_breakBlock_2_);
        if (lvt_4_1_ instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox lvt_5_1_ = (TileEntityShulkerBox)lvt_4_1_;
            if (!lvt_5_1_.isCleared() && lvt_5_1_.shouldDrop()) {
                ItemStack lvt_6_1_ = new ItemStack(Item.getItemFromBlock(this));
                NBTTagCompound lvt_7_1_ = new NBTTagCompound();
                NBTTagCompound lvt_8_1_ = new NBTTagCompound();
                lvt_7_1_.setTag("BlockEntityTag", ((TileEntityShulkerBox)lvt_4_1_).saveToNbt(lvt_8_1_));
                lvt_6_1_.setTagCompound(lvt_7_1_);
                if (lvt_5_1_.hasCustomName()) {
                    lvt_6_1_.setStackDisplayName(lvt_5_1_.getName());
                    lvt_5_1_.setCustomName("");
                }
                BlockShulkerBox.spawnAsEntity(p_breakBlock_1_, p_breakBlock_2_, lvt_6_1_);
            }
            p_breakBlock_1_.updateComparatorOutputLevel(p_breakBlock_2_, p_breakBlock_3_.getBlock());
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        super.addInformation(p_addInformation_1_, p_addInformation_2_, p_addInformation_3_, p_addInformation_4_);
        NBTTagCompound lvt_5_1_ = p_addInformation_1_.getTagCompound();
        if (lvt_5_1_ != null && lvt_5_1_.hasKey("BlockEntityTag", 10)) {
            NBTTagCompound lvt_6_1_ = lvt_5_1_.getCompoundTag("BlockEntityTag");
            if (lvt_6_1_.hasKey("LootTable", 8)) {
                p_addInformation_3_.add("???????");
            }
            if (lvt_6_1_.hasKey("Items", 9)) {
                NonNullList<ItemStack> lvt_7_1_ = NonNullList.withSize(27, ItemStack.EMPTY);
                ItemStackHelper.loadAllItems(lvt_6_1_, lvt_7_1_);
                int lvt_8_1_ = 0;
                int lvt_9_1_ = 0;
                for (ItemStack lvt_11_1_ : lvt_7_1_) {
                    if (lvt_11_1_.isEmpty()) continue;
                    ++lvt_9_1_;
                    if (lvt_8_1_ > 4) continue;
                    ++lvt_8_1_;
                    p_addInformation_3_.add(String.format("%s x%d", lvt_11_1_.getDisplayName(), lvt_11_1_.getCount()));
                }
                if (lvt_9_1_ - lvt_8_1_ > 0) {
                    p_addInformation_3_.add(String.format((Object)((Object)TextFormatting.ITALIC) + I18n.translateToLocal("container.shulkerBox.more"), lvt_9_1_ - lvt_8_1_));
                }
            }
        }
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        TileEntity lvt_4_1_ = p_getBoundingBox_2_.getTileEntity(p_getBoundingBox_3_);
        if (lvt_4_1_ instanceof TileEntityShulkerBox) {
            return ((TileEntityShulkerBox)lvt_4_1_).getBoundingBox(p_getBoundingBox_1_);
        }
        return FULL_BLOCK_AABB;
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        return Container.calcRedstoneFromInventory((IInventory)((Object)p_getComparatorInputOverride_2_.getTileEntity(p_getComparatorInputOverride_3_)));
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        ItemStack lvt_4_1_ = super.getItem(p_getItem_1_, p_getItem_2_, p_getItem_3_);
        TileEntityShulkerBox lvt_5_1_ = (TileEntityShulkerBox)p_getItem_1_.getTileEntity(p_getItem_2_);
        NBTTagCompound lvt_6_1_ = lvt_5_1_.saveToNbt(new NBTTagCompound());
        if (!lvt_6_1_.hasNoTags()) {
            lvt_4_1_.setTagInfo("BlockEntityTag", lvt_6_1_);
        }
        return lvt_4_1_;
    }

    public static Block getBlockByColor(EnumDyeColor p_getBlockByColor_0_) {
        switch (p_getBlockByColor_0_) {
            case WHITE: {
                return Blocks.WHITE_SHULKER_BOX;
            }
            case ORANGE: {
                return Blocks.ORANGE_SHULKER_BOX;
            }
            case MAGENTA: {
                return Blocks.MAGENTA_SHULKER_BOX;
            }
            case LIGHT_BLUE: {
                return Blocks.LIGHT_BLUE_SHULKER_BOX;
            }
            case YELLOW: {
                return Blocks.YELLOW_SHULKER_BOX;
            }
            case LIME: {
                return Blocks.LIME_SHULKER_BOX;
            }
            case PINK: {
                return Blocks.PINK_SHULKER_BOX;
            }
            case GRAY: {
                return Blocks.GRAY_SHULKER_BOX;
            }
            case SILVER: {
                return Blocks.SILVER_SHULKER_BOX;
            }
            case CYAN: {
                return Blocks.CYAN_SHULKER_BOX;
            }
            default: {
                return Blocks.PURPLE_SHULKER_BOX;
            }
            case BLUE: {
                return Blocks.BLUE_SHULKER_BOX;
            }
            case BROWN: {
                return Blocks.BROWN_SHULKER_BOX;
            }
            case GREEN: {
                return Blocks.GREEN_SHULKER_BOX;
            }
            case RED: {
                return Blocks.RED_SHULKER_BOX;
            }
            case BLACK: 
        }
        return Blocks.BLACK_SHULKER_BOX;
    }

    @SideOnly(value=Side.CLIENT)
    public static EnumDyeColor getColorFromItem(Item p_getColorFromItem_0_) {
        return BlockShulkerBox.getColorFromBlock(Block.getBlockFromItem(p_getColorFromItem_0_));
    }

    public static ItemStack getColoredItemStack(EnumDyeColor p_getColoredItemStack_0_) {
        return new ItemStack(BlockShulkerBox.getBlockByColor(p_getColoredItemStack_0_));
    }

    @SideOnly(value=Side.CLIENT)
    public static EnumDyeColor getColorFromBlock(Block p_getColorFromBlock_0_) {
        if (p_getColorFromBlock_0_ instanceof BlockShulkerBox) {
            return ((BlockShulkerBox)p_getColorFromBlock_0_).getColor();
        }
        return EnumDyeColor.PURPLE;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        return this.color;
    }
}

