/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSilverfish
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.create("variant", EnumType.class);

    public BlockSilverfish() {
        super(Material.CLAY);
        this.setDefaultState(this.blockState.getBaseState().withProperty(VARIANT, EnumType.STONE));
        this.setHardness(0.0f);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    public static boolean canContainSilverfish(IBlockState p_canContainSilverfish_0_) {
        Block lvt_1_1_ = p_canContainSilverfish_0_.getBlock();
        return p_canContainSilverfish_0_ == Blocks.STONE.getDefaultState().withProperty(BlockStone.VARIANT, BlockStone.EnumType.STONE) || lvt_1_1_ == Blocks.COBBLESTONE || lvt_1_1_ == Blocks.STONEBRICK;
    }

    @Override
    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        switch (p_getSilkTouchDrop_1_.getValue(VARIANT)) {
            case COBBLESTONE: {
                return new ItemStack(Blocks.COBBLESTONE);
            }
            case STONEBRICK: {
                return new ItemStack(Blocks.STONEBRICK);
            }
            case MOSSY_STONEBRICK: {
                return new ItemStack(Blocks.STONEBRICK, 1, BlockStoneBrick.EnumType.MOSSY.getMetadata());
            }
            case CRACKED_STONEBRICK: {
                return new ItemStack(Blocks.STONEBRICK, 1, BlockStoneBrick.EnumType.CRACKED.getMetadata());
            }
            case CHISELED_STONEBRICK: {
                return new ItemStack(Blocks.STONEBRICK, 1, BlockStoneBrick.EnumType.CHISELED.getMetadata());
            }
        }
        return new ItemStack(Blocks.STONE);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        if (!p_dropBlockAsItemWithChance_1_.isRemote && p_dropBlockAsItemWithChance_1_.getGameRules().getBoolean("doTileDrops")) {
            EntitySilverfish lvt_6_1_ = new EntitySilverfish(p_dropBlockAsItemWithChance_1_);
            lvt_6_1_.setLocationAndAngles((double)p_dropBlockAsItemWithChance_2_.getX() + 0.5, p_dropBlockAsItemWithChance_2_.getY(), (double)p_dropBlockAsItemWithChance_2_.getZ() + 0.5, 0.0f, 0.0f);
            p_dropBlockAsItemWithChance_1_.spawnEntity(lvt_6_1_);
            lvt_6_1_.spawnExplosionParticle();
        }
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this, 1, p_getItem_3_.getBlock().getMetaFromState(p_getItem_3_));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        for (EnumType lvt_7_1_ : EnumType.values()) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, lvt_7_1_.getMetadata()));
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(VARIANT, EnumType.byMetadata(p_getStateFromMeta_1_));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(VARIANT).getMetadata();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, VARIANT);
    }

    public static enum EnumType implements IStringSerializable
    {
        STONE(0, "stone"){

            @Override
            public IBlockState getModelBlock() {
                return Blocks.STONE.getDefaultState().withProperty(BlockStone.VARIANT, BlockStone.EnumType.STONE);
            }
        }
        ,
        COBBLESTONE(1, "cobblestone", "cobble"){

            @Override
            public IBlockState getModelBlock() {
                return Blocks.COBBLESTONE.getDefaultState();
            }
        }
        ,
        STONEBRICK(2, "stone_brick", "brick"){

            @Override
            public IBlockState getModelBlock() {
                return Blocks.STONEBRICK.getDefaultState().withProperty(BlockStoneBrick.VARIANT, BlockStoneBrick.EnumType.DEFAULT);
            }
        }
        ,
        MOSSY_STONEBRICK(3, "mossy_brick", "mossybrick"){

            @Override
            public IBlockState getModelBlock() {
                return Blocks.STONEBRICK.getDefaultState().withProperty(BlockStoneBrick.VARIANT, BlockStoneBrick.EnumType.MOSSY);
            }
        }
        ,
        CRACKED_STONEBRICK(4, "cracked_brick", "crackedbrick"){

            @Override
            public IBlockState getModelBlock() {
                return Blocks.STONEBRICK.getDefaultState().withProperty(BlockStoneBrick.VARIANT, BlockStoneBrick.EnumType.CRACKED);
            }
        }
        ,
        CHISELED_STONEBRICK(5, "chiseled_brick", "chiseledbrick"){

            @Override
            public IBlockState getModelBlock() {
                return Blocks.STONEBRICK.getDefaultState().withProperty(BlockStoneBrick.VARIANT, BlockStoneBrick.EnumType.CHISELED);
            }
        };

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int p_i45704_3_, String p_i45704_4_) {
            this(p_i45704_3_, p_i45704_4_, p_i45704_4_);
        }

        private EnumType(int p_i45705_3_, String p_i45705_4_, String p_i45705_5_) {
            this.meta = p_i45705_3_;
            this.name = p_i45705_4_;
            this.unlocalizedName = p_i45705_5_;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int p_byMetadata_0_) {
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return META_LOOKUP[p_byMetadata_0_];
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public abstract IBlockState getModelBlock();

        public static EnumType forModelBlock(IBlockState p_forModelBlock_0_) {
            for (EnumType lvt_4_1_ : EnumType.values()) {
                if (p_forModelBlock_0_ != lvt_4_1_.getModelBlock()) continue;
                return lvt_4_1_;
            }
            return STONE;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType lvt_3_1_;
                EnumType.META_LOOKUP[lvt_3_1_.getMetadata()] = lvt_3_1_ = enumTypeArray[i];
            }
        }
    }
}

