/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlime
extends BlockBreakable {
    public BlockSlime() {
        super(Material.CLAY, false, MapColor.GRASS);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.slipperiness = 0.8f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public void onFallenUpon(World p_onFallenUpon_1_, BlockPos p_onFallenUpon_2_, Entity p_onFallenUpon_3_, float p_onFallenUpon_4_) {
        if (p_onFallenUpon_3_.isSneaking()) {
            super.onFallenUpon(p_onFallenUpon_1_, p_onFallenUpon_2_, p_onFallenUpon_3_, p_onFallenUpon_4_);
        } else {
            p_onFallenUpon_3_.fall(p_onFallenUpon_4_, 0.0f);
        }
    }

    @Override
    public void onLanded(World p_onLanded_1_, Entity p_onLanded_2_) {
        if (p_onLanded_2_.isSneaking()) {
            super.onLanded(p_onLanded_1_, p_onLanded_2_);
        } else if (p_onLanded_2_.motionY < 0.0) {
            p_onLanded_2_.motionY = -p_onLanded_2_.motionY;
            if (!(p_onLanded_2_ instanceof EntityLivingBase)) {
                p_onLanded_2_.motionY *= 0.8;
            }
        }
    }

    @Override
    public void onEntityWalk(World p_onEntityWalk_1_, BlockPos p_onEntityWalk_2_, Entity p_onEntityWalk_3_) {
        if (Math.abs(p_onEntityWalk_3_.motionY) < 0.1 && !p_onEntityWalk_3_.isSneaking()) {
            double lvt_4_1_ = 0.4 + Math.abs(p_onEntityWalk_3_.motionY) * 0.2;
            p_onEntityWalk_3_.motionX *= lvt_4_1_;
            p_onEntityWalk_3_.motionZ *= lvt_4_1_;
        }
        super.onEntityWalk(p_onEntityWalk_1_, p_onEntityWalk_2_, p_onEntityWalk_3_);
    }
}

