/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSnow
extends Block {
    public static final PropertyInteger LAYERS = PropertyInteger.create("layers", 1, 8);
    protected static final AxisAlignedBB[] SNOW_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    protected BlockSnow() {
        super(Material.SNOW);
        this.setDefaultState(this.blockState.getBaseState().withProperty(LAYERS, 1));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return SNOW_AABB[p_getBoundingBox_1_.getValue(LAYERS)];
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return p_isPassable_1_.getBlockState(p_isPassable_2_).getValue(LAYERS) < 5;
    }

    @Override
    public boolean isFullyOpaque(IBlockState p_isFullyOpaque_1_) {
        return p_isFullyOpaque_1_.getValue(LAYERS) == 8;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        int i = p_getCollisionBoundingBox_1_.getValue(LAYERS) - 1;
        float f = 0.125f;
        AxisAlignedBB axisalignedbb = p_getCollisionBoundingBox_1_.getBoundingBox(p_getCollisionBoundingBox_2_, p_getCollisionBoundingBox_3_);
        return new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.maxX, (float)i * 0.125f, axisalignedbb.maxZ);
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        IBlockState iblockstate = p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down());
        Block block = iblockstate.getBlock();
        return block != Blocks.ICE && block != Blocks.PACKED_ICE ? (iblockstate.getBlock().isLeaves(iblockstate, p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.down()) ? true : (block == this && iblockstate.getValue(LAYERS) == 8 ? true : iblockstate.isOpaqueCube() && iblockstate.getMaterial().blocksMovement())) : false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        this.checkAndDropBlock(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
    }

    private boolean checkAndDropBlock(World p_checkAndDropBlock_1_, BlockPos p_checkAndDropBlock_2_, IBlockState p_checkAndDropBlock_3_) {
        if (!this.canPlaceBlockAt(p_checkAndDropBlock_1_, p_checkAndDropBlock_2_)) {
            p_checkAndDropBlock_1_.setBlockToAir(p_checkAndDropBlock_2_);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_5_, p_harvestBlock_6_);
        p_harvestBlock_1_.setBlockToAir(p_harvestBlock_3_);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.SNOWBALL;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 1;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_1_.getLightFor(EnumSkyBlock.BLOCK, p_updateTick_2_) > 11) {
            p_updateTick_1_.setBlockToAir(p_updateTick_2_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        if (p_shouldSideBeRendered_4_ == EnumFacing.UP) {
            return true;
        }
        IBlockState iblockstate = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_));
        return iblockstate.getBlock() == this && iblockstate.getValue(LAYERS) >= p_shouldSideBeRendered_1_.getValue(LAYERS) ? false : super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(LAYERS, (p_getStateFromMeta_1_ & 7) + 1);
    }

    @Override
    public boolean isReplaceable(IBlockAccess p_isReplaceable_1_, BlockPos p_isReplaceable_2_) {
        return p_isReplaceable_1_.getBlockState(p_isReplaceable_2_).getValue(LAYERS) == 1;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(LAYERS) - 1;
    }

    @Override
    public int quantityDropped(IBlockState p_quantityDropped_1_, int p_quantityDropped_2_, Random p_quantityDropped_3_) {
        return p_quantityDropped_1_.getValue(LAYERS) + 1;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, LAYERS);
    }
}

