/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSponge
extends Block {
    public static final PropertyBool WET = PropertyBool.create("wet");

    protected BlockSponge() {
        super(Material.SPONGE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(WET, false));
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal(this.getUnlocalizedName() + ".dry.name");
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(WET) != false ? 1 : 0;
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        this.tryAbsorb(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        this.tryAbsorb(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
        super.neighborChanged(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_, p_neighborChanged_5_);
    }

    protected void tryAbsorb(World p_tryAbsorb_1_, BlockPos p_tryAbsorb_2_, IBlockState p_tryAbsorb_3_) {
        if (!p_tryAbsorb_3_.getValue(WET).booleanValue() && this.absorb(p_tryAbsorb_1_, p_tryAbsorb_2_)) {
            p_tryAbsorb_1_.setBlockState(p_tryAbsorb_2_, p_tryAbsorb_3_.withProperty(WET, true), 2);
            p_tryAbsorb_1_.playEvent(2001, p_tryAbsorb_2_, Block.getIdFromBlock(Blocks.WATER));
        }
    }

    private boolean absorb(World p_absorb_1_, BlockPos p_absorb_2_) {
        LinkedList lvt_3_1_ = Lists.newLinkedList();
        ArrayList lvt_4_1_ = Lists.newArrayList();
        lvt_3_1_.add(new Tuple<BlockPos, Integer>(p_absorb_2_, 0));
        int lvt_5_1_ = 0;
        while (!lvt_3_1_.isEmpty()) {
            Tuple lvt_6_1_ = (Tuple)lvt_3_1_.poll();
            BlockPos lvt_7_1_ = (BlockPos)lvt_6_1_.getFirst();
            int lvt_8_1_ = (Integer)lvt_6_1_.getSecond();
            for (EnumFacing lvt_12_1_ : EnumFacing.values()) {
                BlockPos lvt_13_1_ = lvt_7_1_.offset(lvt_12_1_);
                if (p_absorb_1_.getBlockState(lvt_13_1_).getMaterial() != Material.WATER) continue;
                p_absorb_1_.setBlockState(lvt_13_1_, Blocks.AIR.getDefaultState(), 2);
                lvt_4_1_.add(lvt_13_1_);
                ++lvt_5_1_;
                if (lvt_8_1_ >= 6) continue;
                lvt_3_1_.add(new Tuple<BlockPos, Integer>(lvt_13_1_, lvt_8_1_ + 1));
            }
            if (lvt_5_1_ <= 64) continue;
            break;
        }
        for (BlockPos lvt_7_2_ : lvt_4_1_) {
            p_absorb_1_.notifyNeighborsOfStateChange(lvt_7_2_, Blocks.AIR, false);
        }
        return lvt_5_1_ > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, 0));
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, 1));
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(WET, (p_getStateFromMeta_1_ & 1) == 1);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(WET) != false ? 1 : 0;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, WET);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        if (!p_randomDisplayTick_1_.getValue(WET).booleanValue()) {
            return;
        }
        EnumFacing lvt_5_1_ = EnumFacing.random(p_randomDisplayTick_4_);
        if (lvt_5_1_ == EnumFacing.UP || p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.offset(lvt_5_1_)).isFullyOpaque()) {
            return;
        }
        double lvt_6_1_ = p_randomDisplayTick_3_.getX();
        double lvt_8_1_ = p_randomDisplayTick_3_.getY();
        double lvt_10_1_ = p_randomDisplayTick_3_.getZ();
        if (lvt_5_1_ == EnumFacing.DOWN) {
            lvt_8_1_ -= 0.05;
            lvt_6_1_ += p_randomDisplayTick_4_.nextDouble();
            lvt_10_1_ += p_randomDisplayTick_4_.nextDouble();
        } else {
            lvt_8_1_ += p_randomDisplayTick_4_.nextDouble() * 0.8;
            if (lvt_5_1_.getAxis() == EnumFacing.Axis.X) {
                lvt_10_1_ += p_randomDisplayTick_4_.nextDouble();
                lvt_6_1_ = lvt_5_1_ == EnumFacing.EAST ? (lvt_6_1_ += 1.1) : (lvt_6_1_ += 0.05);
            } else {
                lvt_6_1_ += p_randomDisplayTick_4_.nextDouble();
                lvt_10_1_ = lvt_5_1_ == EnumFacing.SOUTH ? (lvt_10_1_ += 1.1) : (lvt_10_1_ += 0.05);
            }
        }
        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.DRIP_WATER, lvt_6_1_, lvt_8_1_, lvt_10_1_, 0.0, 0.0, 0.0, new int[0]);
    }
}

