/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStainedGlassPane
extends BlockPane {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.create("color", EnumDyeColor.class);

    public BlockStainedGlassPane() {
        super(Material.GLASS, false);
        this.setDefaultState(this.blockState.getBaseState().withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false).withProperty(COLOR, EnumDyeColor.WHITE));
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(COLOR).getMetadata();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        for (int lvt_4_1_ = 0; lvt_4_1_ < EnumDyeColor.values().length; ++lvt_4_1_) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, lvt_4_1_));
        }
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return p_getMapColor_1_.getValue(COLOR).getMapColor();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(COLOR, EnumDyeColor.byMetadata(p_getStateFromMeta_1_));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(COLOR).getMetadata();
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(SOUTH)).withProperty(EAST, p_withRotation_1_.getValue(WEST)).withProperty(SOUTH, p_withRotation_1_.getValue(NORTH)).withProperty(WEST, p_withRotation_1_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(EAST)).withProperty(EAST, p_withRotation_1_.getValue(SOUTH)).withProperty(SOUTH, p_withRotation_1_.getValue(WEST)).withProperty(WEST, p_withRotation_1_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(WEST)).withProperty(EAST, p_withRotation_1_.getValue(NORTH)).withProperty(SOUTH, p_withRotation_1_.getValue(EAST)).withProperty(WEST, p_withRotation_1_.getValue(SOUTH));
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                return p_withMirror_1_.withProperty(NORTH, p_withMirror_1_.getValue(SOUTH)).withProperty(SOUTH, p_withMirror_1_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return p_withMirror_1_.withProperty(EAST, p_withMirror_1_.getValue(WEST)).withProperty(WEST, p_withMirror_1_.getValue(EAST));
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, NORTH, EAST, WEST, SOUTH, COLOR);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (!p_onBlockAdded_1_.isRemote) {
            BlockBeacon.updateColorAsync(p_onBlockAdded_1_, p_onBlockAdded_2_);
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        if (!p_breakBlock_1_.isRemote) {
            BlockBeacon.updateColorAsync(p_breakBlock_1_, p_breakBlock_2_);
        }
    }
}

