/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStairs
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final PropertyEnum<EnumHalf> HALF = PropertyEnum.create("half", EnumHalf.class);
    public static final PropertyEnum<EnumShape> SHAPE = PropertyEnum.create("shape", EnumShape.class);
    protected static final AxisAlignedBB AABB_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_WEST = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_EAST = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_NORTH = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_QTR_TOP_SOUTH = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_NW = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_NE = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_SW = new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_SE = new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_EAST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_QTR_BOT_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_NE = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_SW = new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_SE = new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);
    private final Block modelBlock;
    private final IBlockState modelState;

    protected BlockStairs(IBlockState p_i45684_1_) {
        super(p_i45684_1_.getBlock().blockMaterial);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(HALF, EnumHalf.BOTTOM).withProperty(SHAPE, EnumShape.STRAIGHT));
        this.modelBlock = p_i45684_1_.getBlock();
        this.modelState = p_i45684_1_;
        this.setHardness(this.modelBlock.blockHardness);
        this.setResistance(this.modelBlock.blockResistance / 3.0f);
        this.setSoundType(this.modelBlock.blockSoundType);
        this.setLightOpacity(255);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        if (!p_addCollisionBoxToList_7_) {
            p_addCollisionBoxToList_1_ = this.getActualState(p_addCollisionBoxToList_1_, p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_);
        }
        for (AxisAlignedBB axisalignedbb : BlockStairs.getCollisionBoxList(p_addCollisionBoxToList_1_)) {
            BlockStairs.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState p_getCollisionBoxList_0_) {
        ArrayList list = Lists.newArrayList();
        boolean flag = p_getCollisionBoxList_0_.getValue(HALF) == EnumHalf.TOP;
        list.add(flag ? AABB_SLAB_TOP : AABB_SLAB_BOTTOM);
        EnumShape blockstairs$enumshape = p_getCollisionBoxList_0_.getValue(SHAPE);
        if (blockstairs$enumshape == EnumShape.STRAIGHT || blockstairs$enumshape == EnumShape.INNER_LEFT || blockstairs$enumshape == EnumShape.INNER_RIGHT) {
            list.add(BlockStairs.getCollQuarterBlock(p_getCollisionBoxList_0_));
        }
        if (blockstairs$enumshape != EnumShape.STRAIGHT) {
            list.add(BlockStairs.getCollEighthBlock(p_getCollisionBoxList_0_));
        }
        return list;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState p_getCollQuarterBlock_0_) {
        boolean flag = p_getCollQuarterBlock_0_.getValue(HALF) == EnumHalf.TOP;
        switch (p_getCollQuarterBlock_0_.getValue(FACING)) {
            default: {
                return flag ? AABB_QTR_BOT_NORTH : AABB_QTR_TOP_NORTH;
            }
            case SOUTH: {
                return flag ? AABB_QTR_BOT_SOUTH : AABB_QTR_TOP_SOUTH;
            }
            case WEST: {
                return flag ? AABB_QTR_BOT_WEST : AABB_QTR_TOP_WEST;
            }
            case EAST: 
        }
        return flag ? AABB_QTR_BOT_EAST : AABB_QTR_TOP_EAST;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState p_getCollEighthBlock_0_) {
        EnumFacing enumfacing1;
        EnumFacing enumfacing = p_getCollEighthBlock_0_.getValue(FACING);
        switch (p_getCollEighthBlock_0_.getValue(SHAPE)) {
            default: {
                enumfacing1 = enumfacing;
                break;
            }
            case OUTER_RIGHT: {
                enumfacing1 = enumfacing.rotateY();
                break;
            }
            case INNER_RIGHT: {
                enumfacing1 = enumfacing.getOpposite();
                break;
            }
            case INNER_LEFT: {
                enumfacing1 = enumfacing.rotateYCCW();
            }
        }
        boolean flag = p_getCollEighthBlock_0_.getValue(HALF) == EnumHalf.TOP;
        switch (enumfacing1) {
            default: {
                return flag ? AABB_OCT_BOT_NW : AABB_OCT_TOP_NW;
            }
            case SOUTH: {
                return flag ? AABB_OCT_BOT_SE : AABB_OCT_TOP_SE;
            }
            case WEST: {
                return flag ? AABB_OCT_BOT_SW : AABB_OCT_TOP_SW;
            }
            case EAST: 
        }
        return flag ? AABB_OCT_BOT_NE : AABB_OCT_TOP_NE;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        this.modelBlock.randomDisplayTick(p_randomDisplayTick_1_, p_randomDisplayTick_2_, p_randomDisplayTick_3_, p_randomDisplayTick_4_);
    }

    @Override
    public void onBlockClicked(World p_onBlockClicked_1_, BlockPos p_onBlockClicked_2_, EntityPlayer p_onBlockClicked_3_) {
        this.modelBlock.onBlockClicked(p_onBlockClicked_1_, p_onBlockClicked_2_, p_onBlockClicked_3_);
    }

    @Override
    public void onBlockDestroyedByPlayer(World p_onBlockDestroyedByPlayer_1_, BlockPos p_onBlockDestroyedByPlayer_2_, IBlockState p_onBlockDestroyedByPlayer_3_) {
        this.modelBlock.onBlockDestroyedByPlayer(p_onBlockDestroyedByPlayer_1_, p_onBlockDestroyedByPlayer_2_, p_onBlockDestroyedByPlayer_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getPackedLightmapCoords(IBlockState p_getPackedLightmapCoords_1_, IBlockAccess p_getPackedLightmapCoords_2_, BlockPos p_getPackedLightmapCoords_3_) {
        return this.modelState.getPackedLightmapCoords(p_getPackedLightmapCoords_2_, p_getPackedLightmapCoords_3_);
    }

    @Override
    public float getExplosionResistance(Entity p_getExplosionResistance_1_) {
        return this.modelBlock.getExplosionResistance(p_getExplosionResistance_1_);
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return this.modelBlock.tickRate(p_tickRate_1_);
    }

    @Override
    public Vec3d modifyAcceleration(World p_modifyAcceleration_1_, BlockPos p_modifyAcceleration_2_, Entity p_modifyAcceleration_3_, Vec3d p_modifyAcceleration_4_) {
        return this.modelBlock.modifyAcceleration(p_modifyAcceleration_1_, p_modifyAcceleration_2_, p_modifyAcceleration_3_, p_modifyAcceleration_4_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return this.modelBlock.getBlockLayer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(IBlockState p_getSelectedBoundingBox_1_, World p_getSelectedBoundingBox_2_, BlockPos p_getSelectedBoundingBox_3_) {
        return this.modelState.getSelectedBoundingBox(p_getSelectedBoundingBox_2_, p_getSelectedBoundingBox_3_);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(IBlockState p_canCollideCheck_1_, boolean p_canCollideCheck_2_) {
        return this.modelBlock.canCollideCheck(p_canCollideCheck_1_, p_canCollideCheck_2_);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return this.modelBlock.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        this.modelState.neighborChanged(p_onBlockAdded_1_, p_onBlockAdded_2_, Blocks.AIR, p_onBlockAdded_2_);
        this.modelBlock.onBlockAdded(p_onBlockAdded_1_, p_onBlockAdded_2_, this.modelState);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        this.modelBlock.breakBlock(p_breakBlock_1_, p_breakBlock_2_, this.modelState);
    }

    @Override
    public void onEntityWalk(World p_onEntityWalk_1_, BlockPos p_onEntityWalk_2_, Entity p_onEntityWalk_3_) {
        this.modelBlock.onEntityWalk(p_onEntityWalk_1_, p_onEntityWalk_2_, p_onEntityWalk_3_);
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        this.modelBlock.updateTick(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_);
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        return this.modelBlock.onBlockActivated(p_onBlockActivated_1_, p_onBlockActivated_2_, this.modelState, p_onBlockActivated_4_, p_onBlockActivated_5_, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void onBlockDestroyedByExplosion(World p_onBlockDestroyedByExplosion_1_, BlockPos p_onBlockDestroyedByExplosion_2_, Explosion p_onBlockDestroyedByExplosion_3_) {
        this.modelBlock.onBlockDestroyedByExplosion(p_onBlockDestroyedByExplosion_1_, p_onBlockDestroyedByExplosion_2_, p_onBlockDestroyedByExplosion_3_);
    }

    @Override
    public boolean isFullyOpaque(IBlockState p_isFullyOpaque_1_) {
        return p_isFullyOpaque_1_.getValue(HALF) == EnumHalf.TOP;
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return this.modelBlock.getMapColor(this.modelState);
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        IBlockState iblockstate = super.getStateForPlacement(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_, p_getStateForPlacement_4_, p_getStateForPlacement_5_, p_getStateForPlacement_6_, p_getStateForPlacement_7_, p_getStateForPlacement_8_);
        iblockstate = iblockstate.withProperty(FACING, p_getStateForPlacement_8_.getHorizontalFacing()).withProperty(SHAPE, EnumShape.STRAIGHT);
        return p_getStateForPlacement_3_ != EnumFacing.DOWN && (p_getStateForPlacement_3_ == EnumFacing.UP || (double)p_getStateForPlacement_5_ <= 0.5) ? iblockstate.withProperty(HALF, EnumHalf.BOTTOM) : iblockstate.withProperty(HALF, EnumHalf.TOP);
    }

    @Override
    @Nullable
    public RayTraceResult collisionRayTrace(IBlockState p_collisionRayTrace_1_, World p_collisionRayTrace_2_, BlockPos p_collisionRayTrace_3_, Vec3d p_collisionRayTrace_4_, Vec3d p_collisionRayTrace_5_) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BlockStairs.getCollisionBoxList(this.getActualState(p_collisionRayTrace_1_, p_collisionRayTrace_2_, p_collisionRayTrace_3_))) {
            list.add(this.rayTrace(p_collisionRayTrace_3_, p_collisionRayTrace_4_, p_collisionRayTrace_5_, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.hitVec.squareDistanceTo(p_collisionRayTrace_5_)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        IBlockState iblockstate = this.getDefaultState().withProperty(HALF, (p_getStateFromMeta_1_ & 4) > 0 ? EnumHalf.TOP : EnumHalf.BOTTOM);
        iblockstate = iblockstate.withProperty(FACING, EnumFacing.getFront(5 - (p_getStateFromMeta_1_ & 3)));
        return iblockstate;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        if (p_getMetaFromState_1_.getValue(HALF) == EnumHalf.TOP) {
            i |= 4;
        }
        return i |= 5 - p_getMetaFromState_1_.getValue(FACING).getIndex();
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        return p_getActualState_1_.withProperty(SHAPE, BlockStairs.getStairsShape(p_getActualState_1_, p_getActualState_2_, p_getActualState_3_));
    }

    private static EnumShape getStairsShape(IBlockState p_getStairsShape_0_, IBlockAccess p_getStairsShape_1_, BlockPos p_getStairsShape_2_) {
        EnumFacing enumfacing2;
        EnumFacing enumfacing1;
        EnumFacing enumfacing = p_getStairsShape_0_.getValue(FACING);
        IBlockState iblockstate = p_getStairsShape_1_.getBlockState(p_getStairsShape_2_.offset(enumfacing));
        if (BlockStairs.isBlockStairs(iblockstate) && p_getStairsShape_0_.getValue(HALF) == iblockstate.getValue(HALF) && (enumfacing1 = iblockstate.getValue(FACING)).getAxis() != p_getStairsShape_0_.getValue(FACING).getAxis() && BlockStairs.isDifferentStairs(p_getStairsShape_0_, p_getStairsShape_1_, p_getStairsShape_2_, enumfacing1.getOpposite())) {
            if (enumfacing1 == enumfacing.rotateYCCW()) {
                return EnumShape.OUTER_LEFT;
            }
            return EnumShape.OUTER_RIGHT;
        }
        IBlockState iblockstate1 = p_getStairsShape_1_.getBlockState(p_getStairsShape_2_.offset(enumfacing.getOpposite()));
        if (BlockStairs.isBlockStairs(iblockstate1) && p_getStairsShape_0_.getValue(HALF) == iblockstate1.getValue(HALF) && (enumfacing2 = iblockstate1.getValue(FACING)).getAxis() != p_getStairsShape_0_.getValue(FACING).getAxis() && BlockStairs.isDifferentStairs(p_getStairsShape_0_, p_getStairsShape_1_, p_getStairsShape_2_, enumfacing2)) {
            if (enumfacing2 == enumfacing.rotateYCCW()) {
                return EnumShape.INNER_LEFT;
            }
            return EnumShape.INNER_RIGHT;
        }
        return EnumShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(IBlockState p_isDifferentStairs_0_, IBlockAccess p_isDifferentStairs_1_, BlockPos p_isDifferentStairs_2_, EnumFacing p_isDifferentStairs_3_) {
        IBlockState iblockstate = p_isDifferentStairs_1_.getBlockState(p_isDifferentStairs_2_.offset(p_isDifferentStairs_3_));
        return !BlockStairs.isBlockStairs(iblockstate) || iblockstate.getValue(FACING) != p_isDifferentStairs_0_.getValue(FACING) || iblockstate.getValue(HALF) != p_isDifferentStairs_0_.getValue(HALF);
    }

    public static boolean isBlockStairs(IBlockState p_isBlockStairs_0_) {
        return p_isBlockStairs_0_.getBlock() instanceof BlockStairs;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        EnumFacing enumfacing = p_withMirror_1_.getValue(FACING);
        EnumShape blockstairs$enumshape = p_withMirror_1_.getValue(SHAPE);
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                if (enumfacing.getAxis() != EnumFacing.Axis.Z) break;
                switch (blockstairs$enumshape) {
                    case OUTER_LEFT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.OUTER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.INNER_LEFT);
                    }
                    case INNER_LEFT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.INNER_RIGHT);
                    }
                }
                return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumfacing.getAxis() != EnumFacing.Axis.X) break;
                switch (blockstairs$enumshape) {
                    case OUTER_LEFT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.OUTER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.INNER_RIGHT);
                    }
                    case INNER_LEFT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180).withProperty(SHAPE, EnumShape.INNER_LEFT);
                    }
                    case STRAIGHT: {
                        return p_withMirror_1_.withRotation(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, HALF, SHAPE);
    }

    @Override
    public boolean doesSideBlockRendering(IBlockState p_doesSideBlockRendering_1_, IBlockAccess p_doesSideBlockRendering_2_, BlockPos p_doesSideBlockRendering_3_, EnumFacing p_doesSideBlockRendering_4_) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(p_doesSideBlockRendering_1_, p_doesSideBlockRendering_2_, p_doesSideBlockRendering_3_, p_doesSideBlockRendering_4_);
        }
        if (p_doesSideBlockRendering_1_.isOpaqueCube()) {
            return true;
        }
        p_doesSideBlockRendering_1_ = this.getActualState(p_doesSideBlockRendering_1_, p_doesSideBlockRendering_2_, p_doesSideBlockRendering_3_);
        EnumHalf half = p_doesSideBlockRendering_1_.getValue(HALF);
        EnumFacing side = p_doesSideBlockRendering_1_.getValue(FACING);
        EnumShape shape = p_doesSideBlockRendering_1_.getValue(SHAPE);
        if (p_doesSideBlockRendering_4_ == EnumFacing.UP) {
            return half == EnumHalf.TOP;
        }
        if (p_doesSideBlockRendering_4_ == EnumFacing.DOWN) {
            return half == EnumHalf.BOTTOM;
        }
        if (shape == EnumShape.OUTER_LEFT || shape == EnumShape.OUTER_RIGHT) {
            return false;
        }
        if (p_doesSideBlockRendering_4_ == side) {
            return true;
        }
        if (shape == EnumShape.INNER_LEFT && p_doesSideBlockRendering_4_.rotateY() == side) {
            return true;
        }
        return shape == EnumShape.INNER_RIGHT && p_doesSideBlockRendering_4_.rotateYCCW() == side;
    }

    public static enum EnumShape implements IStringSerializable
    {
        STRAIGHT("straight"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right"),
        OUTER_LEFT("outer_left"),
        OUTER_RIGHT("outer_right");

        private final String name;

        private EnumShape(String p_i45682_3_) {
            this.name = p_i45682_3_;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum EnumHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumHalf(String p_i45683_3_) {
            this.name = p_i45683_3_;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

