/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockStaticLiquid
extends BlockLiquid {
    protected BlockStaticLiquid(Material p_i45429_1_) {
        super(p_i45429_1_);
        this.setTickRandomly(false);
        if (p_i45429_1_ == Material.LAVA) {
            this.setTickRandomly(true);
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!this.checkForMixing(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_)) {
            this.updateLiquid(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
        }
    }

    private void updateLiquid(World p_updateLiquid_1_, BlockPos p_updateLiquid_2_, IBlockState p_updateLiquid_3_) {
        BlockDynamicLiquid blockdynamicliquid = BlockStaticLiquid.getFlowingBlock(this.blockMaterial);
        p_updateLiquid_1_.setBlockState(p_updateLiquid_2_, blockdynamicliquid.getDefaultState().withProperty(LEVEL, p_updateLiquid_3_.getValue(LEVEL)), 2);
        p_updateLiquid_1_.scheduleUpdate(p_updateLiquid_2_, blockdynamicliquid, this.tickRate(p_updateLiquid_1_));
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        block7: {
            if (this.blockMaterial != Material.LAVA || !p_updateTick_1_.getGameRules().getBoolean("doFireTick")) break block7;
            int i = p_updateTick_4_.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = p_updateTick_2_;
                for (int j = 0; j < i; ++j) {
                    if ((blockpos = blockpos.add(p_updateTick_4_.nextInt(3) - 1, 1, p_updateTick_4_.nextInt(3) - 1)).getY() >= 0 && blockpos.getY() < p_updateTick_1_.getHeight() && !p_updateTick_1_.isBlockLoaded(blockpos)) {
                        return;
                    }
                    Block block = p_updateTick_1_.getBlockState(blockpos).getBlock();
                    if (block.blockMaterial == Material.AIR) {
                        if (!this.isSurroundingBlockFlammable(p_updateTick_1_, blockpos)) continue;
                        p_updateTick_1_.setBlockState(blockpos, Blocks.FIRE.getDefaultState());
                        return;
                    }
                    if (!block.blockMaterial.blocksMovement()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = p_updateTick_2_.add(p_updateTick_4_.nextInt(3) - 1, 0, p_updateTick_4_.nextInt(3) - 1);
                    if (blockpos1.getY() >= 0 && blockpos1.getY() < 256 && !p_updateTick_1_.isBlockLoaded(blockpos1)) {
                        return;
                    }
                    if (!p_updateTick_1_.isAirBlock(blockpos1.up()) || !this.getCanBlockBurn(p_updateTick_1_, blockpos1)) continue;
                    p_updateTick_1_.setBlockState(blockpos1.up(), Blocks.FIRE.getDefaultState());
                }
            }
        }
    }

    protected boolean isSurroundingBlockFlammable(World p_isSurroundingBlockFlammable_1_, BlockPos p_isSurroundingBlockFlammable_2_) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.getCanBlockBurn(p_isSurroundingBlockFlammable_1_, p_isSurroundingBlockFlammable_2_.offset(enumfacing))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(World p_getCanBlockBurn_1_, BlockPos p_getCanBlockBurn_2_) {
        return p_getCanBlockBurn_2_.getY() >= 0 && p_getCanBlockBurn_2_.getY() < 256 && !p_getCanBlockBurn_1_.isBlockLoaded(p_getCanBlockBurn_2_) ? false : p_getCanBlockBurn_1_.getBlockState(p_getCanBlockBurn_2_).getMaterial().getCanBurn();
    }
}

