/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockStem
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 7);
    public static final PropertyDirection FACING = BlockTorch.FACING;
    private final Block crop;
    protected static final AxisAlignedBB[] STEM_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.875, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625)};

    protected BlockStem(Block p_i45430_1_) {
        this.setDefaultState(this.blockState.getBaseState().withProperty(AGE, 0).withProperty(FACING, EnumFacing.UP));
        this.crop = p_i45430_1_;
        this.setTickRandomly(true);
        this.setCreativeTab(null);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return STEM_AABB[p_getBoundingBox_1_.getValue(AGE)];
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        int i = p_getActualState_1_.getValue(AGE);
        p_getActualState_1_ = p_getActualState_1_.withProperty(FACING, EnumFacing.UP);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (p_getActualState_2_.getBlockState(p_getActualState_3_.offset(enumfacing)).getBlock() != this.crop || i != 7) continue;
            p_getActualState_1_ = p_getActualState_1_.withProperty(FACING, enumfacing);
            break;
        }
        return p_getActualState_1_;
    }

    @Override
    protected boolean canSustainBush(IBlockState p_canSustainBush_1_) {
        return p_canSustainBush_1_.getBlock() == Blocks.FARMLAND;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        float f;
        super.updateTick(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_);
        if (p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_.up()) >= 9 && ForgeHooks.onCropsGrowPre(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_.nextInt((int)(25.0f / (f = BlockCrops.getGrowthChance(this, p_updateTick_1_, p_updateTick_2_))) + 1) == 0)) {
            int i = p_updateTick_3_.getValue(AGE);
            if (i < 7) {
                p_updateTick_3_ = p_updateTick_3_.withProperty(AGE, i + 1);
                p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_, 2);
            } else {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    if (p_updateTick_1_.getBlockState(p_updateTick_2_.offset(enumfacing)).getBlock() != this.crop) continue;
                    return;
                }
                p_updateTick_2_ = p_updateTick_2_.offset(EnumFacing.Plane.HORIZONTAL.random(p_updateTick_4_));
                IBlockState soil = p_updateTick_1_.getBlockState(p_updateTick_2_.down());
                Block block = soil.getBlock();
                if (p_updateTick_1_.isAirBlock(p_updateTick_2_) && (block.canSustainPlant(soil, p_updateTick_1_, p_updateTick_2_.down(), EnumFacing.UP, this) || block == Blocks.DIRT || block == Blocks.GRASS)) {
                    p_updateTick_1_.setBlockState(p_updateTick_2_, this.crop.getDefaultState());
                }
            }
            ForgeHooks.onCropsGrowPost(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_1_.getBlockState(p_updateTick_2_));
        }
    }

    public void growStem(World p_growStem_1_, BlockPos p_growStem_2_, IBlockState p_growStem_3_) {
        int i = p_growStem_3_.getValue(AGE) + MathHelper.getInt(p_growStem_1_.rand, 2, 5);
        p_growStem_1_.setBlockState(p_growStem_2_, p_growStem_3_.withProperty(AGE, Math.min(7, i)), 2);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, p_dropBlockAsItemWithChance_5_);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = this.getSeedItem();
        if (item != null) {
            int i = p_getDrops_3_.getValue(AGE);
            for (int j = 0; j < 3; ++j) {
                if (RANDOM.nextInt(15) > i) continue;
                ret.add(new ItemStack(item));
            }
        }
        return ret;
    }

    @Nullable
    protected Item getSeedItem() {
        return this.crop == Blocks.PUMPKIN ? Items.PUMPKIN_SEEDS : (this.crop == Blocks.MELON_BLOCK ? Items.MELON_SEEDS : null);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.AIR;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        Item item = this.getSeedItem();
        return item == null ? ItemStack.EMPTY : new ItemStack(item);
    }

    @Override
    public boolean canGrow(World p_canGrow_1_, BlockPos p_canGrow_2_, IBlockState p_canGrow_3_, boolean p_canGrow_4_) {
        return p_canGrow_3_.getValue(AGE) != 7;
    }

    @Override
    public boolean canUseBonemeal(World p_canUseBonemeal_1_, Random p_canUseBonemeal_2_, BlockPos p_canUseBonemeal_3_, IBlockState p_canUseBonemeal_4_) {
        return true;
    }

    @Override
    public void grow(World p_grow_1_, Random p_grow_2_, BlockPos p_grow_3_, IBlockState p_grow_4_) {
        this.growStem(p_grow_1_, p_grow_3_, p_grow_4_);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AGE, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(AGE);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE, FACING);
    }
}

