/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockStoneSlabNew
extends BlockSlab {
    public static final PropertyBool SEAMLESS = PropertyBool.create("seamless");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.create("variant", EnumType.class);

    public BlockStoneSlabNew() {
        super(Material.ROCK);
        IBlockState lvt_1_1_ = this.blockState.getBaseState();
        lvt_1_1_ = this.isDouble() ? lvt_1_1_.withProperty(SEAMLESS, false) : lvt_1_1_.withProperty(HALF, BlockSlab.EnumBlockHalf.BOTTOM);
        this.setDefaultState(lvt_1_1_.withProperty(VARIANT, EnumType.RED_SANDSTONE));
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal(this.getUnlocalizedName() + ".red_sandstone.name");
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(Blocks.STONE_SLAB2);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Blocks.STONE_SLAB2, 1, p_getItem_3_.getValue(VARIANT).getMetadata());
    }

    @Override
    public String getUnlocalizedName(int p_getUnlocalizedName_1_) {
        return super.getUnlocalizedName() + "." + EnumType.byMetadata(p_getUnlocalizedName_1_).getUnlocalizedName();
    }

    @Override
    public IProperty<?> getVariantProperty() {
        return VARIANT;
    }

    @Override
    public Comparable<?> getTypeForItem(ItemStack p_getTypeForItem_1_) {
        return EnumType.byMetadata(p_getTypeForItem_1_.getMetadata() & 7);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        if (p_getSubBlocks_1_ == Item.getItemFromBlock(Blocks.DOUBLE_STONE_SLAB2)) {
            return;
        }
        for (EnumType lvt_7_1_ : EnumType.values()) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, lvt_7_1_.getMetadata()));
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        IBlockState lvt_2_1_ = this.getDefaultState().withProperty(VARIANT, EnumType.byMetadata(p_getStateFromMeta_1_ & 7));
        lvt_2_1_ = this.isDouble() ? lvt_2_1_.withProperty(SEAMLESS, (p_getStateFromMeta_1_ & 8) != 0) : lvt_2_1_.withProperty(HALF, (p_getStateFromMeta_1_ & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP);
        return lvt_2_1_;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(VARIANT).getMetadata();
        if (this.isDouble()) {
            if (p_getMetaFromState_1_.getValue(SEAMLESS).booleanValue()) {
                lvt_2_1_ |= 8;
            }
        } else if (p_getMetaFromState_1_.getValue(HALF) == BlockSlab.EnumBlockHalf.TOP) {
            lvt_2_1_ |= 8;
        }
        return lvt_2_1_;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        if (this.isDouble()) {
            return new BlockStateContainer((Block)this, SEAMLESS, VARIANT);
        }
        return new BlockStateContainer((Block)this, HALF, VARIANT);
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return p_getMapColor_1_.getValue(VARIANT).getMapColor();
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(VARIANT).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        RED_SANDSTONE(0, "red_sandstone", BlockSand.EnumType.RED_SAND.getMapColor());

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor mapColor;

        private EnumType(int p_i46391_3_, String p_i46391_4_, MapColor p_i46391_5_) {
            this.meta = p_i46391_3_;
            this.name = p_i46391_4_;
            this.mapColor = p_i46391_5_;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int p_byMetadata_0_) {
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return META_LOOKUP[p_byMetadata_0_];
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType lvt_3_1_;
                EnumType.META_LOOKUP[lvt_3_1_.getMetadata()] = lvt_3_1_ = enumTypeArray[i];
            }
        }
    }
}

