/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockStructure
extends BlockContainer {
    public static final PropertyEnum<TileEntityStructure.Mode> MODE = PropertyEnum.create("mode", TileEntityStructure.Mode.class);

    public BlockStructure() {
        super(Material.IRON, MapColor.SILVER);
        this.setDefaultState(this.blockState.getBaseState());
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityStructure();
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        TileEntity lvt_10_1_ = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (lvt_10_1_ instanceof TileEntityStructure) {
            return ((TileEntityStructure)lvt_10_1_).usedBy(p_onBlockActivated_4_);
        }
        return false;
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        if (p_onBlockPlacedBy_1_.isRemote) {
            return;
        }
        TileEntity lvt_6_1_ = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_);
        if (!(lvt_6_1_ instanceof TileEntityStructure)) {
            return;
        }
        TileEntityStructure lvt_7_1_ = (TileEntityStructure)lvt_6_1_;
        lvt_7_1_.createdBy(p_onBlockPlacedBy_4_);
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(MODE, TileEntityStructure.Mode.DATA);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(MODE, TileEntityStructure.Mode.getById(p_getStateFromMeta_1_));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(MODE).getModeId();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, MODE);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (p_neighborChanged_2_.isRemote) {
            return;
        }
        TileEntity lvt_6_1_ = p_neighborChanged_2_.getTileEntity(p_neighborChanged_3_);
        if (!(lvt_6_1_ instanceof TileEntityStructure)) {
            return;
        }
        TileEntityStructure lvt_7_1_ = (TileEntityStructure)lvt_6_1_;
        boolean lvt_8_1_ = p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_);
        boolean lvt_9_1_ = lvt_7_1_.isPowered();
        if (lvt_8_1_ && !lvt_9_1_) {
            lvt_7_1_.setPowered(true);
            this.trigger(lvt_7_1_);
        } else if (!lvt_8_1_ && lvt_9_1_) {
            lvt_7_1_.setPowered(false);
        }
    }

    private void trigger(TileEntityStructure p_trigger_1_) {
        switch (p_trigger_1_.getMode()) {
            case SAVE: {
                p_trigger_1_.save(false);
                break;
            }
            case LOAD: {
                p_trigger_1_.load(false);
                break;
            }
            case CORNER: {
                p_trigger_1_.unloadStructure();
                break;
            }
            case DATA: {
                break;
            }
        }
    }
}

