/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockTNT
extends Block {
    public static final PropertyBool EXPLODE = PropertyBool.create("explode");

    public BlockTNT() {
        super(Material.TNT);
        this.setDefaultState(this.blockState.getBaseState().withProperty(EXPLODE, false));
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        super.onBlockAdded(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        if (p_onBlockAdded_1_.isBlockPowered(p_onBlockAdded_2_)) {
            this.onBlockDestroyedByPlayer(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_.withProperty(EXPLODE, true));
            p_onBlockAdded_1_.setBlockToAir(p_onBlockAdded_2_);
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_)) {
            this.onBlockDestroyedByPlayer(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_.withProperty(EXPLODE, true));
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    @Override
    public void onBlockDestroyedByExplosion(World p_onBlockDestroyedByExplosion_1_, BlockPos p_onBlockDestroyedByExplosion_2_, Explosion p_onBlockDestroyedByExplosion_3_) {
        if (p_onBlockDestroyedByExplosion_1_.isRemote) {
            return;
        }
        EntityTNTPrimed lvt_4_1_ = new EntityTNTPrimed(p_onBlockDestroyedByExplosion_1_, (float)p_onBlockDestroyedByExplosion_2_.getX() + 0.5f, p_onBlockDestroyedByExplosion_2_.getY(), (float)p_onBlockDestroyedByExplosion_2_.getZ() + 0.5f, p_onBlockDestroyedByExplosion_3_.getExplosivePlacedBy());
        lvt_4_1_.setFuse((short)(p_onBlockDestroyedByExplosion_1_.rand.nextInt(lvt_4_1_.getFuse() / 4) + lvt_4_1_.getFuse() / 8));
        p_onBlockDestroyedByExplosion_1_.spawnEntity(lvt_4_1_);
    }

    @Override
    public void onBlockDestroyedByPlayer(World p_onBlockDestroyedByPlayer_1_, BlockPos p_onBlockDestroyedByPlayer_2_, IBlockState p_onBlockDestroyedByPlayer_3_) {
        this.explode(p_onBlockDestroyedByPlayer_1_, p_onBlockDestroyedByPlayer_2_, p_onBlockDestroyedByPlayer_3_, null);
    }

    public void explode(World p_explode_1_, BlockPos p_explode_2_, IBlockState p_explode_3_, EntityLivingBase p_explode_4_) {
        if (p_explode_1_.isRemote) {
            return;
        }
        if (p_explode_3_.getValue(EXPLODE).booleanValue()) {
            EntityTNTPrimed lvt_5_1_ = new EntityTNTPrimed(p_explode_1_, (float)p_explode_2_.getX() + 0.5f, p_explode_2_.getY(), (float)p_explode_2_.getZ() + 0.5f, p_explode_4_);
            p_explode_1_.spawnEntity(lvt_5_1_);
            p_explode_1_.playSound(null, lvt_5_1_.posX, lvt_5_1_.posY, lvt_5_1_.posZ, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        ItemStack lvt_10_1_ = p_onBlockActivated_4_.getHeldItem(p_onBlockActivated_5_);
        if (!(lvt_10_1_.isEmpty() || lvt_10_1_.getItem() != Items.FLINT_AND_STEEL && lvt_10_1_.getItem() != Items.FIRE_CHARGE)) {
            this.explode(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_.withProperty(EXPLODE, true), p_onBlockActivated_4_);
            p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, Blocks.AIR.getDefaultState(), 11);
            if (lvt_10_1_.getItem() == Items.FLINT_AND_STEEL) {
                lvt_10_1_.damageItem(1, p_onBlockActivated_4_);
            } else if (!p_onBlockActivated_4_.capabilities.isCreativeMode) {
                lvt_10_1_.shrink(1);
            }
            return true;
        }
        return super.onBlockActivated(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, p_onBlockActivated_4_, p_onBlockActivated_5_, p_onBlockActivated_6_, p_onBlockActivated_7_, p_onBlockActivated_8_, p_onBlockActivated_9_);
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        EntityArrow lvt_5_1_;
        if (!p_onEntityCollidedWithBlock_1_.isRemote && p_onEntityCollidedWithBlock_4_ instanceof EntityArrow && (lvt_5_1_ = (EntityArrow)p_onEntityCollidedWithBlock_4_).isBurning()) {
            this.explode(p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_, p_onEntityCollidedWithBlock_1_.getBlockState(p_onEntityCollidedWithBlock_2_).withProperty(EXPLODE, true), lvt_5_1_.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)lvt_5_1_.shootingEntity : null);
            p_onEntityCollidedWithBlock_1_.setBlockToAir(p_onEntityCollidedWithBlock_2_);
        }
    }

    @Override
    public boolean canDropFromExplosion(Explosion p_canDropFromExplosion_1_) {
        return false;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(EXPLODE, (p_getStateFromMeta_1_ & 1) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(EXPLODE) != false ? 1 : 0;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, EXPLODE);
    }
}

