/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTorch
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.create("facing", new Predicate<EnumFacing>(){

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.DOWN;
        }
    });
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.4f, 0.0, 0.4f, 0.6f, 0.6f, 0.6f);
    protected static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB(0.35f, 0.2f, 0.7f, 0.65f, 0.8f, 1.0);
    protected static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB(0.35f, 0.2f, 0.0, 0.65f, 0.8f, 0.3f);
    protected static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB(0.7f, 0.2f, 0.35f, 1.0, 0.8f, 0.65f);
    protected static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, 0.2f, 0.35f, 0.3f, 0.8f, 0.65f);

    protected BlockTorch() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.UP));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        switch (p_getBoundingBox_1_.getValue(FACING)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    private boolean canPlaceOn(World p_canPlaceOn_1_, BlockPos p_canPlaceOn_2_) {
        IBlockState state = p_canPlaceOn_1_.getBlockState(p_canPlaceOn_2_);
        if (state.isSideSolid(p_canPlaceOn_1_, p_canPlaceOn_2_, EnumFacing.UP)) {
            return true;
        }
        return state.getBlock().canPlaceTorchOnTop(state, p_canPlaceOn_1_, p_canPlaceOn_2_);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        for (EnumFacing enumfacing : FACING.getAllowedValues()) {
            if (!this.canPlaceAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World p_canPlaceAt_1_, BlockPos p_canPlaceAt_2_, EnumFacing p_canPlaceAt_3_) {
        BlockPos blockpos = p_canPlaceAt_2_.offset(p_canPlaceAt_3_.getOpposite());
        boolean flag = p_canPlaceAt_3_.getAxis().isHorizontal();
        return flag && p_canPlaceAt_1_.isSideSolid(blockpos, p_canPlaceAt_3_, true) || p_canPlaceAt_3_.equals(EnumFacing.UP) && this.canPlaceOn(p_canPlaceAt_1_, blockpos);
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        if (this.canPlaceAt(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_)) {
            return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_3_);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!p_getStateForPlacement_1_.isSideSolid(p_getStateForPlacement_2_.offset(enumfacing.getOpposite()), enumfacing, true)) continue;
            return this.getDefaultState().withProperty(FACING, enumfacing);
        }
        return this.getDefaultState();
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        this.checkForDrop(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        this.onNeighborChangeInternal(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
    }

    protected boolean onNeighborChangeInternal(World p_onNeighborChangeInternal_1_, BlockPos p_onNeighborChangeInternal_2_, IBlockState p_onNeighborChangeInternal_3_) {
        if (!this.checkForDrop(p_onNeighborChangeInternal_1_, p_onNeighborChangeInternal_2_, p_onNeighborChangeInternal_3_)) {
            return true;
        }
        EnumFacing enumfacing = p_onNeighborChangeInternal_3_.getValue(FACING);
        EnumFacing.Axis enumfacing$axis = enumfacing.getAxis();
        EnumFacing enumfacing1 = enumfacing.getOpposite();
        boolean flag = false;
        if (enumfacing$axis.isHorizontal() && !p_onNeighborChangeInternal_1_.isSideSolid(p_onNeighborChangeInternal_2_.offset(enumfacing1), enumfacing, true)) {
            flag = true;
        } else if (enumfacing$axis.isVertical() && !this.canPlaceOn(p_onNeighborChangeInternal_1_, p_onNeighborChangeInternal_2_.offset(enumfacing1))) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(p_onNeighborChangeInternal_1_, p_onNeighborChangeInternal_2_, p_onNeighborChangeInternal_3_, 0);
            p_onNeighborChangeInternal_1_.setBlockToAir(p_onNeighborChangeInternal_2_);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World p_checkForDrop_1_, BlockPos p_checkForDrop_2_, IBlockState p_checkForDrop_3_) {
        if (p_checkForDrop_3_.getBlock() == this && this.canPlaceAt(p_checkForDrop_1_, p_checkForDrop_2_, p_checkForDrop_3_.getValue(FACING))) {
            return true;
        }
        if (p_checkForDrop_1_.getBlockState(p_checkForDrop_2_).getBlock() == this) {
            this.dropBlockAsItem(p_checkForDrop_1_, p_checkForDrop_2_, p_checkForDrop_3_, 0);
            p_checkForDrop_1_.setBlockToAir(p_checkForDrop_2_);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        EnumFacing enumfacing = p_randomDisplayTick_1_.getValue(FACING);
        double d0 = (double)p_randomDisplayTick_3_.getX() + 0.5;
        double d1 = (double)p_randomDisplayTick_3_.getY() + 0.7;
        double d2 = (double)p_randomDisplayTick_3_.getZ() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        if (enumfacing.getAxis().isHorizontal()) {
            EnumFacing enumfacing1 = enumfacing.getOpposite();
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)enumfacing1.getFrontOffsetX(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.getFrontOffsetZ(), 0.0, 0.0, 0.0, new int[0]);
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.FLAME, d0 + 0.27 * (double)enumfacing1.getFrontOffsetX(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.getFrontOffsetZ(), 0.0, 0.0, 0.0, new int[0]);
        } else {
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        IBlockState iblockstate = this.getDefaultState();
        switch (p_getStateFromMeta_1_) {
            case 1: {
                iblockstate = iblockstate.withProperty(FACING, EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.withProperty(FACING, EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.withProperty(FACING, EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.withProperty(FACING, EnumFacing.NORTH);
                break;
            }
            default: {
                iblockstate = iblockstate.withProperty(FACING, EnumFacing.UP);
            }
        }
        return iblockstate;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        switch (p_getMetaFromState_1_.getValue(FACING)) {
            case EAST: {
                i |= 1;
                break;
            }
            case WEST: {
                i |= 2;
                break;
            }
            case SOUTH: {
                i |= 3;
                break;
            }
            case NORTH: {
                i |= 4;
                break;
            }
            default: {
                i |= 5;
            }
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING);
    }
}

