/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrapDoor
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final PropertyBool OPEN = PropertyBool.create("open");
    public static final PropertyEnum<DoorHalf> HALF = PropertyEnum.create("half", DoorHalf.class);
    protected static final AxisAlignedBB EAST_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_OPEN_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);

    protected BlockTrapDoor(Material p_i45434_1_) {
        super(p_i45434_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(OPEN, false).withProperty(HALF, DoorHalf.BOTTOM));
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        AxisAlignedBB axisalignedbb;
        if (p_getBoundingBox_1_.getValue(OPEN).booleanValue()) {
            switch (p_getBoundingBox_1_.getValue(FACING)) {
                default: {
                    axisalignedbb = NORTH_OPEN_AABB;
                    break;
                }
                case SOUTH: {
                    axisalignedbb = SOUTH_OPEN_AABB;
                    break;
                }
                case WEST: {
                    axisalignedbb = WEST_OPEN_AABB;
                    break;
                }
                case EAST: {
                    axisalignedbb = EAST_OPEN_AABB;
                    break;
                }
            }
        } else {
            axisalignedbb = p_getBoundingBox_1_.getValue(HALF) == DoorHalf.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        return axisalignedbb;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return p_isPassable_1_.getBlockState(p_isPassable_2_).getValue(OPEN) == false;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (this.blockMaterial == Material.IRON) {
            return false;
        }
        p_onBlockActivated_3_ = p_onBlockActivated_3_.cycleProperty(OPEN);
        p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 2);
        this.playSound(p_onBlockActivated_4_, p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_.getValue(OPEN));
        return true;
    }

    protected void playSound(EntityPlayer p_playSound_1_, World p_playSound_2_, BlockPos p_playSound_3_, boolean p_playSound_4_) {
        if (p_playSound_4_) {
            int i = this.blockMaterial == Material.IRON ? 1037 : 1007;
            p_playSound_2_.playEvent(p_playSound_1_, i, p_playSound_3_, 0);
        } else {
            int j = this.blockMaterial == Material.IRON ? 1036 : 1013;
            p_playSound_2_.playEvent(p_playSound_1_, j, p_playSound_3_, 0);
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        boolean flag1;
        boolean flag;
        if (!p_neighborChanged_2_.isRemote && ((flag = p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_)) || p_neighborChanged_4_.getDefaultState().canProvidePower()) && (flag1 = p_neighborChanged_1_.getValue(OPEN).booleanValue()) != flag) {
            p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, p_neighborChanged_1_.withProperty(OPEN, flag), 2);
            this.playSound(null, p_neighborChanged_2_, p_neighborChanged_3_, flag);
        }
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        IBlockState iblockstate = this.getDefaultState();
        if (p_getStateForPlacement_3_.getAxis().isHorizontal()) {
            iblockstate = iblockstate.withProperty(FACING, p_getStateForPlacement_3_).withProperty(OPEN, false);
            iblockstate = iblockstate.withProperty(HALF, p_getStateForPlacement_5_ > 0.5f ? DoorHalf.TOP : DoorHalf.BOTTOM);
        } else {
            iblockstate = iblockstate.withProperty(FACING, p_getStateForPlacement_8_.getHorizontalFacing().getOpposite()).withProperty(OPEN, false);
            iblockstate = iblockstate.withProperty(HALF, p_getStateForPlacement_3_ == EnumFacing.UP ? DoorHalf.BOTTOM : DoorHalf.TOP);
        }
        if (p_getStateForPlacement_1_.isBlockPowered(p_getStateForPlacement_2_)) {
            iblockstate = iblockstate.withProperty(OPEN, true);
        }
        return iblockstate;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        return true;
    }

    protected static EnumFacing getFacing(int p_getFacing_0_) {
        switch (p_getFacing_0_ & 3) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.EAST;
    }

    protected static int getMetaForFacing(EnumFacing p_getMetaForFacing_0_) {
        switch (p_getMetaForFacing_0_) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, BlockTrapDoor.getFacing(p_getStateFromMeta_1_)).withProperty(OPEN, (p_getStateFromMeta_1_ & 4) != 0).withProperty(HALF, (p_getStateFromMeta_1_ & 8) == 0 ? DoorHalf.BOTTOM : DoorHalf.TOP);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= BlockTrapDoor.getMetaForFacing(p_getMetaFromState_1_.getValue(FACING));
        if (p_getMetaFromState_1_.getValue(OPEN).booleanValue()) {
            i |= 4;
        }
        if (p_getMetaFromState_1_.getValue(HALF) == DoorHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, OPEN, HALF);
    }

    @Override
    public boolean isLadder(IBlockState p_isLadder_1_, IBlockAccess p_isLadder_2_, BlockPos p_isLadder_3_, EntityLivingBase p_isLadder_4_) {
        IBlockState down;
        if (p_isLadder_1_.getValue(OPEN).booleanValue() && (down = p_isLadder_2_.getBlockState(p_isLadder_3_.down())).getBlock() == Blocks.LADDER) {
            return down.getValue(BlockLadder.FACING) == p_isLadder_1_.getValue(FACING);
        }
        return false;
    }

    public static enum DoorHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private DoorHalf(String p_i45674_3_) {
            this.name = p_i45674_3_;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

