/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTripWire
extends Block {
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    public static final PropertyBool ATTACHED = PropertyBool.create("attached");
    public static final PropertyBool DISARMED = PropertyBool.create("disarmed");
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0625, 0.0, 1.0, 0.15625, 1.0);
    protected static final AxisAlignedBB TRIP_WRITE_ATTACHED_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockTripWire() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(POWERED, false).withProperty(ATTACHED, false).withProperty(DISARMED, false).withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false));
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        if (!p_getBoundingBox_1_.getValue(ATTACHED).booleanValue()) {
            return TRIP_WRITE_ATTACHED_AABB;
        }
        return AABB;
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        return p_getActualState_1_.withProperty(NORTH, BlockTripWire.isConnectedTo(p_getActualState_2_, p_getActualState_3_, p_getActualState_1_, EnumFacing.NORTH)).withProperty(EAST, BlockTripWire.isConnectedTo(p_getActualState_2_, p_getActualState_3_, p_getActualState_1_, EnumFacing.EAST)).withProperty(SOUTH, BlockTripWire.isConnectedTo(p_getActualState_2_, p_getActualState_3_, p_getActualState_1_, EnumFacing.SOUTH)).withProperty(WEST, BlockTripWire.isConnectedTo(p_getActualState_2_, p_getActualState_3_, p_getActualState_1_, EnumFacing.WEST));
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.STRING;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.STRING);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        p_onBlockAdded_1_.setBlockState(p_onBlockAdded_2_, p_onBlockAdded_3_, 3);
        this.notifyHook(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        this.notifyHook(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_.withProperty(POWERED, true));
    }

    @Override
    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
        if (p_onBlockHarvested_1_.isRemote) {
            return;
        }
        if (!p_onBlockHarvested_4_.getHeldItemMainhand().isEmpty() && p_onBlockHarvested_4_.getHeldItemMainhand().getItem() == Items.SHEARS) {
            p_onBlockHarvested_1_.setBlockState(p_onBlockHarvested_2_, p_onBlockHarvested_3_.withProperty(DISARMED, true), 4);
        }
    }

    private void notifyHook(World p_notifyHook_1_, BlockPos p_notifyHook_2_, IBlockState p_notifyHook_3_) {
        block0: for (EnumFacing lvt_7_1_ : new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST}) {
            for (int lvt_8_1_ = 1; lvt_8_1_ < 42; ++lvt_8_1_) {
                BlockPos lvt_9_1_ = p_notifyHook_2_.offset(lvt_7_1_, lvt_8_1_);
                IBlockState lvt_10_1_ = p_notifyHook_1_.getBlockState(lvt_9_1_);
                if (lvt_10_1_.getBlock() == Blocks.TRIPWIRE_HOOK) {
                    if (lvt_10_1_.getValue(BlockTripWireHook.FACING) != lvt_7_1_.getOpposite()) continue block0;
                    Blocks.TRIPWIRE_HOOK.calculateState(p_notifyHook_1_, lvt_9_1_, lvt_10_1_, false, true, lvt_8_1_, p_notifyHook_3_);
                    continue block0;
                }
                if (lvt_10_1_.getBlock() != Blocks.TRIPWIRE) continue block0;
            }
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        if (p_onEntityCollidedWithBlock_1_.isRemote) {
            return;
        }
        if (p_onEntityCollidedWithBlock_3_.getValue(POWERED).booleanValue()) {
            return;
        }
        this.updateState(p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_);
    }

    @Override
    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_1_.isRemote) {
            return;
        }
        if (!p_updateTick_1_.getBlockState(p_updateTick_2_).getValue(POWERED).booleanValue()) {
            return;
        }
        this.updateState(p_updateTick_1_, p_updateTick_2_);
    }

    private void updateState(World p_updateState_1_, BlockPos p_updateState_2_) {
        IBlockState lvt_3_1_ = p_updateState_1_.getBlockState(p_updateState_2_);
        boolean lvt_4_1_ = lvt_3_1_.getValue(POWERED);
        boolean lvt_5_1_ = false;
        List<Entity> lvt_6_1_ = p_updateState_1_.getEntitiesWithinAABBExcludingEntity(null, lvt_3_1_.getBoundingBox(p_updateState_1_, p_updateState_2_).offset(p_updateState_2_));
        if (!lvt_6_1_.isEmpty()) {
            for (Entity lvt_8_1_ : lvt_6_1_) {
                if (lvt_8_1_.doesEntityNotTriggerPressurePlate()) continue;
                lvt_5_1_ = true;
                break;
            }
        }
        if (lvt_5_1_ != lvt_4_1_) {
            lvt_3_1_ = lvt_3_1_.withProperty(POWERED, lvt_5_1_);
            p_updateState_1_.setBlockState(p_updateState_2_, lvt_3_1_, 3);
            this.notifyHook(p_updateState_1_, p_updateState_2_, lvt_3_1_);
        }
        if (lvt_5_1_) {
            p_updateState_1_.scheduleUpdate(new BlockPos(p_updateState_2_), this, this.tickRate(p_updateState_1_));
        }
    }

    public static boolean isConnectedTo(IBlockAccess p_isConnectedTo_0_, BlockPos p_isConnectedTo_1_, IBlockState p_isConnectedTo_2_, EnumFacing p_isConnectedTo_3_) {
        BlockPos lvt_4_1_ = p_isConnectedTo_1_.offset(p_isConnectedTo_3_);
        IBlockState lvt_5_1_ = p_isConnectedTo_0_.getBlockState(lvt_4_1_);
        Block lvt_6_1_ = lvt_5_1_.getBlock();
        if (lvt_6_1_ == Blocks.TRIPWIRE_HOOK) {
            EnumFacing lvt_7_1_ = p_isConnectedTo_3_.getOpposite();
            return lvt_5_1_.getValue(BlockTripWireHook.FACING) == lvt_7_1_;
        }
        return lvt_6_1_ == Blocks.TRIPWIRE;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(POWERED, (p_getStateFromMeta_1_ & 1) > 0).withProperty(ATTACHED, (p_getStateFromMeta_1_ & 4) > 0).withProperty(DISARMED, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            lvt_2_1_ |= 1;
        }
        if (p_getMetaFromState_1_.getValue(ATTACHED).booleanValue()) {
            lvt_2_1_ |= 4;
        }
        if (p_getMetaFromState_1_.getValue(DISARMED).booleanValue()) {
            lvt_2_1_ |= 8;
        }
        return lvt_2_1_;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(SOUTH)).withProperty(EAST, p_withRotation_1_.getValue(WEST)).withProperty(SOUTH, p_withRotation_1_.getValue(NORTH)).withProperty(WEST, p_withRotation_1_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(EAST)).withProperty(EAST, p_withRotation_1_.getValue(SOUTH)).withProperty(SOUTH, p_withRotation_1_.getValue(WEST)).withProperty(WEST, p_withRotation_1_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(WEST)).withProperty(EAST, p_withRotation_1_.getValue(NORTH)).withProperty(SOUTH, p_withRotation_1_.getValue(EAST)).withProperty(WEST, p_withRotation_1_.getValue(SOUTH));
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                return p_withMirror_1_.withProperty(NORTH, p_withMirror_1_.getValue(SOUTH)).withProperty(SOUTH, p_withMirror_1_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return p_withMirror_1_.withProperty(EAST, p_withMirror_1_.getValue(WEST)).withProperty(WEST, p_withMirror_1_.getValue(EAST));
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

