/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTripWireHook
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    public static final PropertyBool ATTACHED = PropertyBool.create("attached");
    protected static final AxisAlignedBB HOOK_NORTH_AABB = new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 0.625, 1.0);
    protected static final AxisAlignedBB HOOK_SOUTH_AABB = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.625, 0.375);
    protected static final AxisAlignedBB HOOK_WEST_AABB = new AxisAlignedBB(0.625, 0.0, 0.3125, 1.0, 0.625, 0.6875);
    protected static final AxisAlignedBB HOOK_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.3125, 0.375, 0.625, 0.6875);

    public BlockTripWireHook() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(POWERED, false).withProperty(ATTACHED, false));
        this.setCreativeTab(CreativeTabs.REDSTONE);
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        switch (p_getBoundingBox_1_.getValue(FACING)) {
            default: {
                return HOOK_EAST_AABB;
            }
            case WEST: {
                return HOOK_WEST_AABB;
            }
            case SOUTH: {
                return HOOK_SOUTH_AABB;
            }
            case NORTH: 
        }
        return HOOK_NORTH_AABB;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        return p_canPlaceBlockOnSide_3_.getAxis().isHorizontal() && p_canPlaceBlockOnSide_1_.getBlockState(p_canPlaceBlockOnSide_2_.offset(p_canPlaceBlockOnSide_3_.getOpposite())).isSideSolid(p_canPlaceBlockOnSide_1_, p_canPlaceBlockOnSide_2_.offset(p_canPlaceBlockOnSide_3_.getOpposite()), p_canPlaceBlockOnSide_3_);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.offset(enumfacing)).isSideSolid(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.offset(enumfacing), enumfacing.getOpposite())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        IBlockState iblockstate = this.getDefaultState().withProperty(POWERED, false).withProperty(ATTACHED, false);
        if (p_getStateForPlacement_3_.getAxis().isHorizontal()) {
            iblockstate = iblockstate.withProperty(FACING, p_getStateForPlacement_3_);
        }
        return iblockstate;
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        this.calculateState(p_onBlockPlacedBy_1_, p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_, false, false, -1, null);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        EnumFacing enumfacing;
        if (p_neighborChanged_4_ != this && this.checkForDrop(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_) && !p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.offset((enumfacing = p_neighborChanged_1_.getValue(FACING)).getOpposite())).isSideSolid(p_neighborChanged_2_, p_neighborChanged_3_.offset(enumfacing.getOpposite()), enumfacing)) {
            this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    public void calculateState(World p_calculateState_1_, BlockPos p_calculateState_2_, IBlockState p_calculateState_3_, boolean p_calculateState_4_, boolean p_calculateState_5_, int p_calculateState_6_, IBlockState p_calculateState_7_) {
        EnumFacing enumfacing = p_calculateState_3_.getValue(FACING);
        boolean flag = p_calculateState_3_.getValue(ATTACHED);
        boolean flag1 = p_calculateState_3_.getValue(POWERED);
        boolean flag2 = !p_calculateState_4_;
        boolean flag3 = false;
        int i = 0;
        IBlockState[] aiblockstate = new IBlockState[42];
        for (int j = 1; j < 42; ++j) {
            BlockPos blockpos = p_calculateState_2_.offset(enumfacing, j);
            IBlockState iblockstate = p_calculateState_1_.getBlockState(blockpos);
            if (iblockstate.getBlock() == Blocks.TRIPWIRE_HOOK) {
                if (iblockstate.getValue(FACING) != enumfacing.getOpposite()) break;
                i = j;
                break;
            }
            if (iblockstate.getBlock() != Blocks.TRIPWIRE && j != p_calculateState_6_) {
                aiblockstate[j] = null;
                flag2 = false;
                continue;
            }
            if (j == p_calculateState_6_) {
                iblockstate = (IBlockState)Objects.firstNonNull((Object)p_calculateState_7_, (Object)iblockstate);
            }
            boolean flag4 = iblockstate.getValue(BlockTripWire.DISARMED) == false;
            boolean flag5 = iblockstate.getValue(BlockTripWire.POWERED);
            flag3 |= flag4 && flag5;
            aiblockstate[j] = iblockstate;
            if (j != p_calculateState_6_) continue;
            p_calculateState_1_.scheduleUpdate(p_calculateState_2_, this, this.tickRate(p_calculateState_1_));
            flag2 &= flag4;
        }
        IBlockState iblockstate1 = this.getDefaultState().withProperty(ATTACHED, flag2).withProperty(POWERED, flag3 &= (flag2 &= i > 1));
        if (i > 0) {
            BlockPos blockpos1 = p_calculateState_2_.offset(enumfacing, i);
            EnumFacing enumfacing1 = enumfacing.getOpposite();
            p_calculateState_1_.setBlockState(blockpos1, iblockstate1.withProperty(FACING, enumfacing1), 3);
            this.notifyNeighbors(p_calculateState_1_, blockpos1, enumfacing1);
            this.playSound(p_calculateState_1_, blockpos1, flag2, flag3, flag, flag1);
        }
        this.playSound(p_calculateState_1_, p_calculateState_2_, flag2, flag3, flag, flag1);
        if (!p_calculateState_4_) {
            p_calculateState_1_.setBlockState(p_calculateState_2_, iblockstate1.withProperty(FACING, enumfacing), 3);
            if (p_calculateState_5_) {
                this.notifyNeighbors(p_calculateState_1_, p_calculateState_2_, enumfacing);
            }
        }
        if (flag != flag2) {
            for (int k = 1; k < i; ++k) {
                BlockPos blockpos2 = p_calculateState_2_.offset(enumfacing, k);
                IBlockState iblockstate2 = aiblockstate[k];
                if (iblockstate2 == null || p_calculateState_1_.getBlockState(blockpos2).getMaterial() == Material.AIR) continue;
                p_calculateState_1_.setBlockState(blockpos2, iblockstate2.withProperty(ATTACHED, flag2), 3);
            }
        }
    }

    @Override
    public void randomTick(World p_randomTick_1_, BlockPos p_randomTick_2_, IBlockState p_randomTick_3_, Random p_randomTick_4_) {
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        this.calculateState(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, false, true, -1, null);
    }

    private void playSound(World p_playSound_1_, BlockPos p_playSound_2_, boolean p_playSound_3_, boolean p_playSound_4_, boolean p_playSound_5_, boolean p_playSound_6_) {
        if (p_playSound_4_ && !p_playSound_6_) {
            p_playSound_1_.playSound(null, p_playSound_2_, SoundEvents.BLOCK_TRIPWIRE_CLICK_ON, SoundCategory.BLOCKS, 0.4f, 0.6f);
        } else if (!p_playSound_4_ && p_playSound_6_) {
            p_playSound_1_.playSound(null, p_playSound_2_, SoundEvents.BLOCK_TRIPWIRE_CLICK_OFF, SoundCategory.BLOCKS, 0.4f, 0.5f);
        } else if (p_playSound_3_ && !p_playSound_5_) {
            p_playSound_1_.playSound(null, p_playSound_2_, SoundEvents.BLOCK_TRIPWIRE_ATTACH, SoundCategory.BLOCKS, 0.4f, 0.7f);
        } else if (!p_playSound_3_ && p_playSound_5_) {
            p_playSound_1_.playSound(null, p_playSound_2_, SoundEvents.BLOCK_TRIPWIRE_DETACH, SoundCategory.BLOCKS, 0.4f, 1.2f / (p_playSound_1_.rand.nextFloat() * 0.2f + 0.9f));
        }
    }

    private void notifyNeighbors(World p_notifyNeighbors_1_, BlockPos p_notifyNeighbors_2_, EnumFacing p_notifyNeighbors_3_) {
        p_notifyNeighbors_1_.notifyNeighborsOfStateChange(p_notifyNeighbors_2_, this, false);
        p_notifyNeighbors_1_.notifyNeighborsOfStateChange(p_notifyNeighbors_2_.offset(p_notifyNeighbors_3_.getOpposite()), this, false);
    }

    private boolean checkForDrop(World p_checkForDrop_1_, BlockPos p_checkForDrop_2_, IBlockState p_checkForDrop_3_) {
        if (!this.canPlaceBlockAt(p_checkForDrop_1_, p_checkForDrop_2_)) {
            this.dropBlockAsItem(p_checkForDrop_1_, p_checkForDrop_2_, p_checkForDrop_3_, 0);
            p_checkForDrop_1_.setBlockToAir(p_checkForDrop_2_);
            return false;
        }
        return true;
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        boolean flag = p_breakBlock_3_.getValue(ATTACHED);
        boolean flag1 = p_breakBlock_3_.getValue(POWERED);
        if (flag || flag1) {
            this.calculateState(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_, true, false, -1, null);
        }
        if (flag1) {
            p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_, this, false);
            p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_.offset(p_breakBlock_3_.getValue(FACING).getOpposite()), this, false);
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return p_getWeakPower_1_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_1_.getValue(POWERED) == false ? 0 : (p_getStrongPower_1_.getValue(FACING) == p_getStrongPower_4_ ? 15 : 0);
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getHorizontal(p_getStateFromMeta_1_ & 3)).withProperty(POWERED, (p_getStateFromMeta_1_ & 8) > 0).withProperty(ATTACHED, (p_getStateFromMeta_1_ & 4) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(FACING).getHorizontalIndex();
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            i |= 8;
        }
        if (p_getMetaFromState_1_.getValue(ATTACHED).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, POWERED, ATTACHED);
    }
}

