/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVine
extends Block
implements IShearable {
    public static final PropertyBool UP = PropertyBool.create("up");
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    public static final PropertyBool[] ALL_FACES = new PropertyBool[]{UP, NORTH, SOUTH, WEST, EAST};
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public BlockVine() {
        super(Material.VINE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(UP, false).withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        p_getBoundingBox_1_ = p_getBoundingBox_1_.getActualState(p_getBoundingBox_2_, p_getBoundingBox_3_);
        int i = 0;
        AxisAlignedBB axisalignedbb = FULL_BLOCK_AABB;
        if (p_getBoundingBox_1_.getValue(UP).booleanValue()) {
            axisalignedbb = UP_AABB;
            ++i;
        }
        if (p_getBoundingBox_1_.getValue(NORTH).booleanValue()) {
            axisalignedbb = NORTH_AABB;
            ++i;
        }
        if (p_getBoundingBox_1_.getValue(EAST).booleanValue()) {
            axisalignedbb = EAST_AABB;
            ++i;
        }
        if (p_getBoundingBox_1_.getValue(SOUTH).booleanValue()) {
            axisalignedbb = SOUTH_AABB;
            ++i;
        }
        if (p_getBoundingBox_1_.getValue(WEST).booleanValue()) {
            axisalignedbb = WEST_AABB;
            ++i;
        }
        return i == 1 ? axisalignedbb : FULL_BLOCK_AABB;
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        return p_getActualState_1_.withProperty(UP, p_getActualState_2_.getBlockState(p_getActualState_3_.up()).isBlockNormalCube());
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isReplaceable(IBlockAccess p_isReplaceable_1_, BlockPos p_isReplaceable_2_) {
        return true;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        switch (p_canPlaceBlockOnSide_3_) {
            case UP: {
                return this.canAttachVineOn(p_canPlaceBlockOnSide_1_.getBlockState(p_canPlaceBlockOnSide_2_.up()));
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return this.canAttachVineOn(p_canPlaceBlockOnSide_1_.getBlockState(p_canPlaceBlockOnSide_2_.offset(p_canPlaceBlockOnSide_3_.getOpposite())));
            }
        }
        return false;
    }

    private boolean canAttachVineOn(IBlockState p_canAttachVineOn_1_) {
        return p_canAttachVineOn_1_.isFullCube() && p_canAttachVineOn_1_.getMaterial().blocksMovement();
    }

    private boolean recheckGrownSides(World p_recheckGrownSides_1_, BlockPos p_recheckGrownSides_2_, IBlockState p_recheckGrownSides_3_) {
        IBlockState iblockstate = p_recheckGrownSides_3_;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1;
            PropertyBool propertybool = BlockVine.getPropertyFor(enumfacing);
            if (!p_recheckGrownSides_3_.getValue(propertybool).booleanValue() || this.canAttachVineOn(p_recheckGrownSides_1_.getBlockState(p_recheckGrownSides_2_.offset(enumfacing))) || (iblockstate1 = p_recheckGrownSides_1_.getBlockState(p_recheckGrownSides_2_.up())).getBlock() == this && iblockstate1.getValue(propertybool).booleanValue()) continue;
            p_recheckGrownSides_3_ = p_recheckGrownSides_3_.withProperty(propertybool, false);
        }
        if (BlockVine.getNumGrownFaces(p_recheckGrownSides_3_) == 0) {
            return false;
        }
        if (iblockstate != p_recheckGrownSides_3_) {
            p_recheckGrownSides_1_.setBlockState(p_recheckGrownSides_2_, p_recheckGrownSides_3_, 2);
        }
        return true;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.isRemote && !this.recheckGrownSides(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_)) {
            this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote && p_updateTick_1_.rand.nextInt(4) == 0) {
            int i = 4;
            int j = 5;
            boolean flag = false;
            block0: for (int k = -4; k <= 4; ++k) {
                for (int l = -4; l <= 4; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        if (p_updateTick_1_.getBlockState(p_updateTick_2_.add(k, i1, l)).getBlock() != this || --j > 0) continue;
                        flag = true;
                        break block0;
                    }
                }
            }
            EnumFacing enumfacing1 = EnumFacing.random(p_updateTick_4_);
            BlockPos blockpos2 = p_updateTick_2_.up();
            if (enumfacing1 == EnumFacing.UP && p_updateTick_2_.getY() < 255 && p_updateTick_1_.isAirBlock(blockpos2)) {
                if (!flag) {
                    IBlockState iblockstate2 = p_updateTick_3_;
                    for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                        if (!p_updateTick_4_.nextBoolean() && this.canAttachVineOn(p_updateTick_1_.getBlockState(blockpos2.offset(enumfacing2)))) continue;
                        iblockstate2 = iblockstate2.withProperty(BlockVine.getPropertyFor(enumfacing2), false);
                    }
                    if (iblockstate2.getValue(NORTH).booleanValue() || iblockstate2.getValue(EAST).booleanValue() || iblockstate2.getValue(SOUTH).booleanValue() || iblockstate2.getValue(WEST).booleanValue()) {
                        p_updateTick_1_.setBlockState(blockpos2, iblockstate2, 2);
                    }
                }
            } else if (enumfacing1.getAxis().isHorizontal() && !p_updateTick_3_.getValue(BlockVine.getPropertyFor(enumfacing1)).booleanValue()) {
                if (!flag) {
                    BlockPos blockpos4 = p_updateTick_2_.offset(enumfacing1);
                    IBlockState iblockstate3 = p_updateTick_1_.getBlockState(blockpos4);
                    Block block1 = iblockstate3.getBlock();
                    if (block1.blockMaterial == Material.AIR) {
                        EnumFacing enumfacing3 = enumfacing1.rotateY();
                        EnumFacing enumfacing4 = enumfacing1.rotateYCCW();
                        boolean flag1 = p_updateTick_3_.getValue(BlockVine.getPropertyFor(enumfacing3));
                        boolean flag2 = p_updateTick_3_.getValue(BlockVine.getPropertyFor(enumfacing4));
                        BlockPos blockpos = blockpos4.offset(enumfacing3);
                        BlockPos blockpos1 = blockpos4.offset(enumfacing4);
                        if (flag1 && this.canAttachVineOn(p_updateTick_1_.getBlockState(blockpos))) {
                            p_updateTick_1_.setBlockState(blockpos4, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing3), true), 2);
                        } else if (flag2 && this.canAttachVineOn(p_updateTick_1_.getBlockState(blockpos1))) {
                            p_updateTick_1_.setBlockState(blockpos4, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing4), true), 2);
                        } else if (flag1 && p_updateTick_1_.isAirBlock(blockpos) && this.canAttachVineOn(p_updateTick_1_.getBlockState(p_updateTick_2_.offset(enumfacing3)))) {
                            p_updateTick_1_.setBlockState(blockpos, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing1.getOpposite()), true), 2);
                        } else if (flag2 && p_updateTick_1_.isAirBlock(blockpos1) && this.canAttachVineOn(p_updateTick_1_.getBlockState(p_updateTick_2_.offset(enumfacing4)))) {
                            p_updateTick_1_.setBlockState(blockpos1, this.getDefaultState().withProperty(BlockVine.getPropertyFor(enumfacing1.getOpposite()), true), 2);
                        } else if (this.canAttachVineOn(p_updateTick_1_.getBlockState(blockpos4.up()))) {
                            p_updateTick_1_.setBlockState(blockpos4, this.getDefaultState(), 2);
                        }
                    } else if (block1.blockMaterial.isOpaque() && iblockstate3.isFullCube()) {
                        p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(BlockVine.getPropertyFor(enumfacing1), true), 2);
                    }
                }
            } else if (p_updateTick_2_.getY() > 1) {
                BlockPos blockpos3 = p_updateTick_2_.down();
                IBlockState iblockstate = p_updateTick_1_.getBlockState(blockpos3);
                Block block = iblockstate.getBlock();
                if (block.blockMaterial == Material.AIR) {
                    IBlockState iblockstate1 = p_updateTick_3_;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        if (!p_updateTick_4_.nextBoolean()) continue;
                        iblockstate1 = iblockstate1.withProperty(BlockVine.getPropertyFor(enumfacing), false);
                    }
                    if (iblockstate1.getValue(NORTH).booleanValue() || iblockstate1.getValue(EAST).booleanValue() || iblockstate1.getValue(SOUTH).booleanValue() || iblockstate1.getValue(WEST).booleanValue()) {
                        p_updateTick_1_.setBlockState(blockpos3, iblockstate1, 2);
                    }
                } else if (block == this) {
                    IBlockState iblockstate4 = iblockstate;
                    for (EnumFacing enumfacing5 : EnumFacing.Plane.HORIZONTAL) {
                        PropertyBool propertybool = BlockVine.getPropertyFor(enumfacing5);
                        if (!p_updateTick_4_.nextBoolean() || !p_updateTick_3_.getValue(propertybool).booleanValue()) continue;
                        iblockstate4 = iblockstate4.withProperty(propertybool, true);
                    }
                    if (iblockstate4.getValue(NORTH).booleanValue() || iblockstate4.getValue(EAST).booleanValue() || iblockstate4.getValue(SOUTH).booleanValue() || iblockstate4.getValue(WEST).booleanValue()) {
                        p_updateTick_1_.setBlockState(blockpos3, iblockstate4, 2);
                    }
                }
            }
        }
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        IBlockState iblockstate = this.getDefaultState().withProperty(UP, false).withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false);
        return p_getStateForPlacement_3_.getAxis().isHorizontal() ? iblockstate.withProperty(BlockVine.getPropertyFor(p_getStateForPlacement_3_.getOpposite()), true) : iblockstate;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.AIR;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_5_, p_harvestBlock_6_);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(SOUTH, (p_getStateFromMeta_1_ & 1) > 0).withProperty(WEST, (p_getStateFromMeta_1_ & 2) > 0).withProperty(NORTH, (p_getStateFromMeta_1_ & 4) > 0).withProperty(EAST, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        if (p_getMetaFromState_1_.getValue(SOUTH).booleanValue()) {
            i |= 1;
        }
        if (p_getMetaFromState_1_.getValue(WEST).booleanValue()) {
            i |= 2;
        }
        if (p_getMetaFromState_1_.getValue(NORTH).booleanValue()) {
            i |= 4;
        }
        if (p_getMetaFromState_1_.getValue(EAST).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, UP, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(SOUTH)).withProperty(EAST, p_withRotation_1_.getValue(WEST)).withProperty(SOUTH, p_withRotation_1_.getValue(NORTH)).withProperty(WEST, p_withRotation_1_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(EAST)).withProperty(EAST, p_withRotation_1_.getValue(SOUTH)).withProperty(SOUTH, p_withRotation_1_.getValue(WEST)).withProperty(WEST, p_withRotation_1_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(WEST)).withProperty(EAST, p_withRotation_1_.getValue(NORTH)).withProperty(SOUTH, p_withRotation_1_.getValue(EAST)).withProperty(WEST, p_withRotation_1_.getValue(SOUTH));
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                return p_withMirror_1_.withProperty(NORTH, p_withMirror_1_.getValue(SOUTH)).withProperty(SOUTH, p_withMirror_1_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return p_withMirror_1_.withProperty(EAST, p_withMirror_1_.getValue(WEST)).withProperty(WEST, p_withMirror_1_.getValue(EAST));
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    public static PropertyBool getPropertyFor(EnumFacing p_getPropertyFor_0_) {
        switch (p_getPropertyFor_0_) {
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        throw new IllegalArgumentException(p_getPropertyFor_0_ + " is an invalid choice");
    }

    public static int getNumGrownFaces(IBlockState p_getNumGrownFaces_0_) {
        int i = 0;
        for (PropertyBool propertybool : ALL_FACES) {
            if (!p_getNumGrownFaces_0_.getValue(propertybool).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public boolean isLadder(IBlockState p_isLadder_1_, IBlockAccess p_isLadder_2_, BlockPos p_isLadder_3_, EntityLivingBase p_isLadder_4_) {
        return true;
    }

    @Override
    public boolean isShearable(ItemStack p_isShearable_1_, IBlockAccess p_isShearable_2_, BlockPos p_isShearable_3_) {
        return true;
    }

    @Override
    public List<ItemStack> onSheared(ItemStack p_onSheared_1_, IBlockAccess p_onSheared_2_, BlockPos p_onSheared_3_, int p_onSheared_4_) {
        return Arrays.asList(new ItemStack(this, 1));
    }
}

