/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWall
extends Block {
    public static final PropertyBool UP = PropertyBool.create("up");
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.create("variant", EnumType.class);
    protected static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    protected static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = new AxisAlignedBB[]{AABB_BY_INDEX[0].setMaxY(1.5), AABB_BY_INDEX[1].setMaxY(1.5), AABB_BY_INDEX[2].setMaxY(1.5), AABB_BY_INDEX[3].setMaxY(1.5), AABB_BY_INDEX[4].setMaxY(1.5), AABB_BY_INDEX[5].setMaxY(1.5), AABB_BY_INDEX[6].setMaxY(1.5), AABB_BY_INDEX[7].setMaxY(1.5), AABB_BY_INDEX[8].setMaxY(1.5), AABB_BY_INDEX[9].setMaxY(1.5), AABB_BY_INDEX[10].setMaxY(1.5), AABB_BY_INDEX[11].setMaxY(1.5), AABB_BY_INDEX[12].setMaxY(1.5), AABB_BY_INDEX[13].setMaxY(1.5), AABB_BY_INDEX[14].setMaxY(1.5), AABB_BY_INDEX[15].setMaxY(1.5)};

    public BlockWall(Block p_i45435_1_) {
        super(p_i45435_1_.blockMaterial);
        this.setDefaultState(this.blockState.getBaseState().withProperty(UP, false).withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false).withProperty(VARIANT, EnumType.NORMAL));
        this.setHardness(p_i45435_1_.blockHardness);
        this.setResistance(p_i45435_1_.blockResistance / 3.0f);
        this.setSoundType(p_i45435_1_.blockSoundType);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        p_getBoundingBox_1_ = this.getActualState(p_getBoundingBox_1_, p_getBoundingBox_2_, p_getBoundingBox_3_);
        return AABB_BY_INDEX[BlockWall.getAABBIndex(p_getBoundingBox_1_)];
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        if (!p_addCollisionBoxToList_7_) {
            p_addCollisionBoxToList_1_ = this.getActualState(p_addCollisionBoxToList_1_, p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_);
        }
        BlockWall.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, CLIP_AABB_BY_INDEX[BlockWall.getAABBIndex(p_addCollisionBoxToList_1_)]);
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        p_getCollisionBoundingBox_1_ = this.getActualState(p_getCollisionBoundingBox_1_, p_getCollisionBoundingBox_2_, p_getCollisionBoundingBox_3_);
        return CLIP_AABB_BY_INDEX[BlockWall.getAABBIndex(p_getCollisionBoundingBox_1_)];
    }

    private static int getAABBIndex(IBlockState p_getAABBIndex_0_) {
        int i = 0;
        if (p_getAABBIndex_0_.getValue(NORTH).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.getHorizontalIndex();
        }
        if (p_getAABBIndex_0_.getValue(EAST).booleanValue()) {
            i |= 1 << EnumFacing.EAST.getHorizontalIndex();
        }
        if (p_getAABBIndex_0_.getValue(SOUTH).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.getHorizontalIndex();
        }
        if (p_getAABBIndex_0_.getValue(WEST).booleanValue()) {
            i |= 1 << EnumFacing.WEST.getHorizontalIndex();
        }
        return i;
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal(this.getUnlocalizedName() + "." + EnumType.NORMAL.getUnlocalizedName() + ".name");
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    private boolean canConnectTo(IBlockAccess p_canConnectTo_1_, BlockPos p_canConnectTo_2_) {
        IBlockState iblockstate = p_canConnectTo_1_.getBlockState(p_canConnectTo_2_);
        Block block = iblockstate.getBlock();
        return block == Blocks.BARRIER ? false : (block != this && !(block instanceof BlockFenceGate) ? (block.blockMaterial.isOpaque() && iblockstate.isFullCube() ? block.blockMaterial != Material.GOURD : false) : true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        for (EnumType blockwall$enumtype : EnumType.values()) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, blockwall$enumtype.getMetadata()));
        }
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(VARIANT).getMetadata();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return p_shouldSideBeRendered_4_ == EnumFacing.DOWN ? super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_) : true;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(VARIANT, EnumType.byMetadata(p_getStateFromMeta_1_));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(VARIANT).getMetadata();
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        boolean flag = this.canWallConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.NORTH);
        boolean flag1 = this.canWallConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.EAST);
        boolean flag2 = this.canWallConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.SOUTH);
        boolean flag3 = this.canWallConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.WEST);
        boolean flag4 = flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3;
        return p_getActualState_1_.withProperty(UP, !flag4 || !p_getActualState_2_.isAirBlock(p_getActualState_3_.up())).withProperty(NORTH, flag).withProperty(EAST, flag1).withProperty(SOUTH, flag2).withProperty(WEST, flag3);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, UP, NORTH, EAST, WEST, SOUTH, VARIANT);
    }

    @Override
    public boolean canBeConnectedTo(IBlockAccess p_canBeConnectedTo_1_, BlockPos p_canBeConnectedTo_2_, EnumFacing p_canBeConnectedTo_3_) {
        Block connector = p_canBeConnectedTo_1_.getBlockState(p_canBeConnectedTo_2_.offset(p_canBeConnectedTo_3_)).getBlock();
        return connector instanceof BlockWall || connector instanceof BlockFenceGate;
    }

    private boolean canWallConnectTo(IBlockAccess p_canWallConnectTo_1_, BlockPos p_canWallConnectTo_2_, EnumFacing p_canWallConnectTo_3_) {
        Block block = p_canWallConnectTo_1_.getBlockState(p_canWallConnectTo_2_.offset(p_canWallConnectTo_3_)).getBlock();
        return block.canBeConnectedTo(p_canWallConnectTo_1_, p_canWallConnectTo_2_.offset(p_canWallConnectTo_3_), p_canWallConnectTo_3_.getOpposite()) || this.canConnectTo(p_canWallConnectTo_1_, p_canWallConnectTo_2_.offset(p_canWallConnectTo_3_));
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL(0, "cobblestone", "normal"),
        MOSSY(1, "mossy_cobblestone", "mossy");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int p_i45673_3_, String p_i45673_4_, String p_i45673_5_) {
            this.meta = p_i45673_3_;
            this.name = p_i45673_4_;
            this.unlocalizedName = p_i45673_5_;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int p_byMetadata_0_) {
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return META_LOOKUP[p_byMetadata_0_];
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockwall$enumtype;
                EnumType.META_LOOKUP[blockwall$enumtype.getMetadata()] = blockwall$enumtype = enumTypeArray[i];
            }
        }
    }
}

