/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockWoodSlab
extends BlockSlab {
    public static final PropertyEnum<BlockPlanks.EnumType> VARIANT = PropertyEnum.create("variant", BlockPlanks.EnumType.class);

    public BlockWoodSlab() {
        super(Material.WOOD);
        IBlockState lvt_1_1_ = this.blockState.getBaseState();
        if (!this.isDouble()) {
            lvt_1_1_ = lvt_1_1_.withProperty(HALF, BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.setDefaultState(lvt_1_1_.withProperty(VARIANT, BlockPlanks.EnumType.OAK));
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return p_getMapColor_1_.getValue(VARIANT).getMapColor();
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(Blocks.WOODEN_SLAB);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Blocks.WOODEN_SLAB, 1, p_getItem_3_.getValue(VARIANT).getMetadata());
    }

    @Override
    public String getUnlocalizedName(int p_getUnlocalizedName_1_) {
        return super.getUnlocalizedName() + "." + BlockPlanks.EnumType.byMetadata(p_getUnlocalizedName_1_).getUnlocalizedName();
    }

    @Override
    public IProperty<?> getVariantProperty() {
        return VARIANT;
    }

    @Override
    public Comparable<?> getTypeForItem(ItemStack p_getTypeForItem_1_) {
        return BlockPlanks.EnumType.byMetadata(p_getTypeForItem_1_.getMetadata() & 7);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        if (p_getSubBlocks_1_ == Item.getItemFromBlock(Blocks.DOUBLE_WOODEN_SLAB)) {
            return;
        }
        for (BlockPlanks.EnumType lvt_7_1_ : BlockPlanks.EnumType.values()) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, lvt_7_1_.getMetadata()));
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        IBlockState lvt_2_1_ = this.getDefaultState().withProperty(VARIANT, BlockPlanks.EnumType.byMetadata(p_getStateFromMeta_1_ & 7));
        if (!this.isDouble()) {
            lvt_2_1_ = lvt_2_1_.withProperty(HALF, (p_getStateFromMeta_1_ & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP);
        }
        return lvt_2_1_;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(VARIANT).getMetadata();
        if (!this.isDouble() && p_getMetaFromState_1_.getValue(HALF) == BlockSlab.EnumBlockHalf.TOP) {
            lvt_2_1_ |= 8;
        }
        return lvt_2_1_;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        if (this.isDouble()) {
            return new BlockStateContainer((Block)this, VARIANT);
        }
        return new BlockStateContainer((Block)this, HALF, VARIANT);
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(VARIANT).getMetadata();
    }
}

