/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.properties;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.util.IStringSerializable;

public class PropertyEnum<T extends Enum<T>>
extends PropertyHelper<T> {
    private final ImmutableSet<T> allowedValues;
    private final Map<String, T> nameToValue = Maps.newHashMap();

    protected PropertyEnum(String p_i45649_1_, Class<T> p_i45649_2_, Collection<T> p_i45649_3_) {
        super(p_i45649_1_, p_i45649_2_);
        this.allowedValues = ImmutableSet.copyOf(p_i45649_3_);
        for (Enum lvt_5_1_ : p_i45649_3_) {
            String lvt_6_1_ = ((IStringSerializable)((Object)lvt_5_1_)).getName();
            if (this.nameToValue.containsKey(lvt_6_1_)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + lvt_6_1_ + "'");
            }
            this.nameToValue.put(lvt_6_1_, lvt_5_1_);
        }
    }

    @Override
    public Collection<T> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public Optional<T> parseValue(String p_parseValue_1_) {
        return Optional.fromNullable(this.nameToValue.get(p_parseValue_1_));
    }

    @Override
    public String getName(T p_getName_1_) {
        return ((IStringSerializable)p_getName_1_).getName();
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof PropertyEnum && super.equals(p_equals_1_)) {
            PropertyEnum lvt_2_1_ = (PropertyEnum)p_equals_1_;
            return this.allowedValues.equals(lvt_2_1_.allowedValues) && this.nameToValue.equals(lvt_2_1_.nameToValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int lvt_1_1_ = super.hashCode();
        lvt_1_1_ = 31 * lvt_1_1_ + this.allowedValues.hashCode();
        lvt_1_1_ = 31 * lvt_1_1_ + this.nameToValue.hashCode();
        return lvt_1_1_;
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String p_create_0_, Class<T> p_create_1_) {
        return PropertyEnum.create(p_create_0_, p_create_1_, Predicates.alwaysTrue());
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String p_create_0_, Class<T> p_create_1_, Predicate<T> p_create_2_) {
        return PropertyEnum.create(p_create_0_, p_create_1_, Collections2.filter((Collection)Lists.newArrayList((Object[])p_create_1_.getEnumConstants()), p_create_2_));
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String p_create_0_, Class<T> p_create_1_, T ... p_create_2_) {
        return PropertyEnum.create(p_create_0_, p_create_1_, Lists.newArrayList((Object[])p_create_2_));
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String p_create_0_, Class<T> p_create_1_, Collection<T> p_create_2_) {
        return new PropertyEnum<T>(p_create_0_, p_create_1_, p_create_2_);
    }
}

