/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.properties;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyInteger
extends PropertyHelper<Integer> {
    private final ImmutableSet<Integer> allowedValues;

    protected PropertyInteger(String p_i45648_1_, int p_i45648_2_, int p_i45648_3_) {
        super(p_i45648_1_, Integer.class);
        if (p_i45648_2_ < 0) {
            throw new IllegalArgumentException("Min value of " + p_i45648_1_ + " must be 0 or greater");
        }
        if (p_i45648_3_ <= p_i45648_2_) {
            throw new IllegalArgumentException("Max value of " + p_i45648_1_ + " must be greater than min (" + p_i45648_2_ + ")");
        }
        HashSet lvt_4_1_ = Sets.newHashSet();
        for (int lvt_5_1_ = p_i45648_2_; lvt_5_1_ <= p_i45648_3_; ++lvt_5_1_) {
            lvt_4_1_.add(lvt_5_1_);
        }
        this.allowedValues = ImmutableSet.copyOf((Collection)lvt_4_1_);
    }

    @Override
    public Collection<Integer> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof PropertyInteger && super.equals(p_equals_1_)) {
            PropertyInteger lvt_2_1_ = (PropertyInteger)p_equals_1_;
            return this.allowedValues.equals(lvt_2_1_.allowedValues);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.allowedValues.hashCode();
    }

    public static PropertyInteger create(String p_create_0_, int p_create_1_, int p_create_2_) {
        return new PropertyInteger(p_create_0_, p_create_1_, p_create_2_);
    }

    @Override
    public Optional<Integer> parseValue(String p_parseValue_1_) {
        try {
            Integer lvt_2_1_ = Integer.valueOf(p_parseValue_1_);
            return this.allowedValues.contains((Object)lvt_2_1_) ? Optional.of((Object)lvt_2_1_) : Optional.absent();
        }
        catch (NumberFormatException lvt_2_2_) {
            return Optional.absent();
        }
    }

    @Override
    public String getName(Integer p_getName_1_) {
        return p_getName_1_.toString();
    }
}

