/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPistonStructureHelper {
    private final World world;
    private final BlockPos pistonPos;
    private final BlockPos blockToMove;
    private final EnumFacing moveDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();

    public BlockPistonStructureHelper(World p_i45664_1_, BlockPos p_i45664_2_, EnumFacing p_i45664_3_, boolean p_i45664_4_) {
        this.world = p_i45664_1_;
        this.pistonPos = p_i45664_2_;
        if (p_i45664_4_) {
            this.moveDirection = p_i45664_3_;
            this.blockToMove = p_i45664_2_.offset(p_i45664_3_);
        } else {
            this.moveDirection = p_i45664_3_.getOpposite();
            this.blockToMove = p_i45664_2_.offset(p_i45664_3_, 2);
        }
    }

    public boolean canMove() {
        this.toMove.clear();
        this.toDestroy.clear();
        IBlockState iblockstate = this.world.getBlockState(this.blockToMove);
        if (!BlockPistonBase.canPush(iblockstate, this.world, this.blockToMove, this.moveDirection, false)) {
            if (iblockstate.getMobilityFlag() == EnumPushReaction.DESTROY) {
                this.toDestroy.add(this.blockToMove);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.blockToMove)) {
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos blockpos = this.toMove.get(i);
            if (this.world.getBlockState(blockpos).getBlock() != Blocks.SLIME_BLOCK || this.addBranchingBlocks(blockpos)) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos p_addBlockLine_1_) {
        IBlockState iblockstate = this.world.getBlockState(p_addBlockLine_1_);
        Block block = iblockstate.getBlock();
        if (iblockstate.getBlock().isAir(iblockstate, this.world, p_addBlockLine_1_)) {
            return true;
        }
        if (!BlockPistonBase.canPush(iblockstate, this.world, p_addBlockLine_1_, this.moveDirection, false)) {
            return true;
        }
        if (p_addBlockLine_1_.equals(this.pistonPos)) {
            return true;
        }
        if (this.toMove.contains(p_addBlockLine_1_)) {
            return true;
        }
        int i = 1;
        if (i + this.toMove.size() > 12) {
            return false;
        }
        while (block == Blocks.SLIME_BLOCK) {
            BlockPos blockpos = p_addBlockLine_1_.offset(this.moveDirection.getOpposite(), i);
            iblockstate = this.world.getBlockState(blockpos);
            block = iblockstate.getBlock();
            if (iblockstate.getBlock().isAir(iblockstate, this.world, blockpos) || !BlockPistonBase.canPush(iblockstate, this.world, blockpos, this.moveDirection, false) || blockpos.equals(this.pistonPos)) break;
            if (++i + this.toMove.size() <= 12) continue;
            return false;
        }
        int i1 = 0;
        for (int j = i - 1; j >= 0; --j) {
            this.toMove.add(p_addBlockLine_1_.offset(this.moveDirection.getOpposite(), j));
            ++i1;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1;
            int k;
            if ((k = this.toMove.indexOf(blockpos1 = p_addBlockLine_1_.offset(this.moveDirection, j1))) > -1) {
                this.reorderListAtCollision(i1, k);
                for (int l = 0; l <= k + i1; ++l) {
                    BlockPos blockpos2 = this.toMove.get(l);
                    if (this.world.getBlockState(blockpos2).getBlock() != Blocks.SLIME_BLOCK || this.addBranchingBlocks(blockpos2)) continue;
                    return false;
                }
                return true;
            }
            iblockstate = this.world.getBlockState(blockpos1);
            if (iblockstate.getBlock().isAir(iblockstate, this.world, blockpos1)) {
                return true;
            }
            if (!BlockPistonBase.canPush(iblockstate, this.world, blockpos1, this.moveDirection, true) || blockpos1.equals(this.pistonPos)) {
                return false;
            }
            if (iblockstate.getMobilityFlag() == EnumPushReaction.DESTROY) {
                this.toDestroy.add(blockpos1);
                return true;
            }
            if (this.toMove.size() >= 12) {
                return false;
            }
            this.toMove.add(blockpos1);
            ++i1;
            ++j1;
        }
    }

    private void reorderListAtCollision(int p_reorderListAtCollision_1_, int p_reorderListAtCollision_2_) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toMove.subList(0, p_reorderListAtCollision_2_));
        list1.addAll(this.toMove.subList(this.toMove.size() - p_reorderListAtCollision_1_, this.toMove.size()));
        list2.addAll(this.toMove.subList(p_reorderListAtCollision_2_, this.toMove.size() - p_reorderListAtCollision_1_));
        this.toMove.clear();
        this.toMove.addAll(list);
        this.toMove.addAll(list1);
        this.toMove.addAll(list2);
    }

    private boolean addBranchingBlocks(BlockPos p_addBranchingBlocks_1_) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (enumfacing.getAxis() == this.moveDirection.getAxis() || this.addBlockLine(p_addBranchingBlocks_1_.offset(enumfacing))) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getBlocksToMove() {
        return this.toMove;
    }

    public List<BlockPos> getBlocksToDestroy() {
        return this.toDestroy;
    }
}

