/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public abstract class BlockStateBase
implements IBlockState {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<IProperty<?>, Comparable<?>>, String>(){

        @Nullable
        public String apply(Map.Entry<IProperty<?>, Comparable<?>> p_apply_1_) {
            if (p_apply_1_ == null) {
                return "<NULL>";
            }
            IProperty<?> iproperty = p_apply_1_.getKey();
            return iproperty.getName() + "=" + this.getPropertyName(iproperty, p_apply_1_.getValue());
        }

        private <T extends Comparable<T>> String getPropertyName(IProperty<T> p_getPropertyName_1_, Comparable<?> p_getPropertyName_2_) {
            return p_getPropertyName_1_.getName(p_getPropertyName_2_);
        }
    };

    @Override
    public <T extends Comparable<T>> IBlockState cycleProperty(IProperty<T> p_cycleProperty_1_) {
        return this.withProperty(p_cycleProperty_1_, (Comparable)BlockStateBase.cyclePropertyValue(p_cycleProperty_1_.getAllowedValues(), this.getValue(p_cycleProperty_1_)));
    }

    protected static <T> T cyclePropertyValue(Collection<T> p_cyclePropertyValue_0_, T p_cyclePropertyValue_1_) {
        Iterator<T> iterator = p_cyclePropertyValue_0_.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(p_cyclePropertyValue_1_)) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return p_cyclePropertyValue_0_.iterator().next();
        }
        return iterator.next();
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(Block.REGISTRY.getNameForObject(this.getBlock()));
        if (!this.getProperties().isEmpty()) {
            stringbuilder.append("[");
            COMMA_JOINER.appendTo(stringbuilder, Iterables.transform((Iterable)this.getProperties().entrySet(), MAP_ENTRY_TO_STRING));
            stringbuilder.append("]");
        }
        return stringbuilder.toString();
    }

    public ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> getPropertyValueTable() {
        return null;
    }
}

