/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MapPopulator;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Cartesian;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStateContainer {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private static final Function<IProperty<?>, String> GET_NAME_FUNC = new Function<IProperty<?>, String>(){

        @Nullable
        public String apply(IProperty<?> p_apply_1_) {
            return p_apply_1_ == null ? "<NULL>" : p_apply_1_.getName();
        }
    };
    private final Block block;
    private final ImmutableSortedMap<String, IProperty<?>> properties;
    private final ImmutableList<IBlockState> validStates;

    public BlockStateContainer(Block p_i45663_1_, IProperty<?> ... p_i45663_2_) {
        this(p_i45663_1_, p_i45663_2_, (ImmutableMap<IUnlistedProperty<?>, Optional<?>>)null);
    }

    protected StateImplementation createState(Block p_createState_1_, ImmutableMap<IProperty<?>, Comparable<?>> p_createState_2_, ImmutableMap<IUnlistedProperty<?>, Optional<?>> p_createState_3_) {
        return new StateImplementation(p_createState_1_, p_createState_2_);
    }

    protected BlockStateContainer(Block p_i10_1_, IProperty<?>[] p_i10_2_, ImmutableMap<IUnlistedProperty<?>, Optional<?>> p_i10_3_) {
        this.block = p_i10_1_;
        HashMap map = Maps.newHashMap();
        for (IProperty<?> iproperty : p_i10_2_) {
            BlockStateContainer.validateProperty(p_i10_1_, iproperty);
            map.put(iproperty.getName(), iproperty);
        }
        this.properties = ImmutableSortedMap.copyOf((Map)map);
        LinkedHashMap map2 = Maps.newLinkedHashMap();
        ArrayList list1 = Lists.newArrayList();
        for (List<Comparable<?>> list : Cartesian.cartesianProduct(this.getAllowedValues())) {
            Map map1 = MapPopulator.createMap(this.properties.values(), list);
            StateImplementation blockstatecontainer$stateimplementation = this.createState(p_i10_1_, ImmutableMap.copyOf(map1), p_i10_3_);
            map2.put(map1, blockstatecontainer$stateimplementation);
            list1.add(blockstatecontainer$stateimplementation);
        }
        for (StateImplementation blockstatecontainer$stateimplementation1 : list1) {
            blockstatecontainer$stateimplementation1.buildPropertyValueTable(map2);
        }
        this.validStates = ImmutableList.copyOf((Collection)list1);
    }

    public static <T extends Comparable<T>> String validateProperty(Block p_validateProperty_0_, IProperty<T> p_validateProperty_1_) {
        String s = p_validateProperty_1_.getName();
        if (!NAME_PATTERN.matcher(s).matches()) {
            throw new IllegalArgumentException("Block: " + p_validateProperty_0_.getClass() + " has invalidly named property: " + s);
        }
        for (Comparable t : p_validateProperty_1_.getAllowedValues()) {
            String s1 = p_validateProperty_1_.getName(t);
            if (NAME_PATTERN.matcher(s1).matches()) continue;
            throw new IllegalArgumentException("Block: " + p_validateProperty_0_.getClass() + " has property: " + s + " with invalidly named value: " + s1);
        }
        return s;
    }

    public ImmutableList<IBlockState> getValidStates() {
        return this.validStates;
    }

    private List<Iterable<Comparable<?>>> getAllowedValues() {
        ArrayList list = Lists.newArrayList();
        ImmutableCollection immutablecollection = this.properties.values();
        for (IProperty iproperty : immutablecollection) {
            list.add(iproperty.getAllowedValues());
        }
        return list;
    }

    public IBlockState getBaseState() {
        return (IBlockState)this.validStates.get(0);
    }

    public Block getBlock() {
        return this.block;
    }

    public Collection<IProperty<?>> getProperties() {
        return this.properties.values();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("block", (Object)Block.REGISTRY.getNameForObject(this.block)).add("properties", (Object)Iterables.transform((Iterable)this.properties.values(), GET_NAME_FUNC)).toString();
    }

    @Nullable
    public IProperty<?> getProperty(String p_getProperty_1_) {
        return (IProperty)this.properties.get((Object)p_getProperty_1_);
    }

    public static class Builder {
        private final Block block;
        private final List<IProperty<?>> listed = Lists.newArrayList();
        private final List<IUnlistedProperty<?>> unlisted = Lists.newArrayList();

        public Builder(Block p_i26_1_) {
            this.block = p_i26_1_;
        }

        public Builder add(IProperty<?> ... p_add_1_) {
            for (IProperty<?> prop : p_add_1_) {
                this.listed.add(prop);
            }
            return this;
        }

        public Builder add(IUnlistedProperty<?> ... p_add_1_) {
            for (IUnlistedProperty<?> prop : p_add_1_) {
                this.unlisted.add(prop);
            }
            return this;
        }

        public BlockStateContainer build() {
            IProperty[] listed = new IProperty[this.listed.size()];
            listed = this.listed.toArray(listed);
            if (this.unlisted.size() == 0) {
                return new BlockStateContainer(this.block, listed);
            }
            IUnlistedProperty[] unlisted = new IUnlistedProperty[this.unlisted.size()];
            unlisted = this.unlisted.toArray(unlisted);
            return new ExtendedBlockState(this.block, listed, unlisted);
        }
    }

    public static class StateImplementation
    extends BlockStateBase {
        private final Block block;
        private final ImmutableMap<IProperty<?>, Comparable<?>> properties;
        protected ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> propertyValueTable;

        protected StateImplementation(Block p_i45660_1_, ImmutableMap<IProperty<?>, Comparable<?>> p_i45660_2_) {
            this.block = p_i45660_1_;
            this.properties = p_i45660_2_;
        }

        protected StateImplementation(Block p_i0_1_, ImmutableMap<IProperty<?>, Comparable<?>> p_i0_2_, ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> p_i0_3_) {
            this.block = p_i0_1_;
            this.properties = p_i0_2_;
            this.propertyValueTable = p_i0_3_;
        }

        @Override
        public Collection<IProperty<?>> getPropertyKeys() {
            return Collections.unmodifiableCollection(this.properties.keySet());
        }

        @Override
        public <T extends Comparable<T>> T getValue(IProperty<T> p_getValue_1_) {
            Comparable comparable = (Comparable)this.properties.get(p_getValue_1_);
            if (comparable == null) {
                throw new IllegalArgumentException("Cannot get property " + p_getValue_1_ + " as it does not exist in " + this.block.getBlockState());
            }
            return (T)((Comparable)p_getValue_1_.getValueClass().cast(comparable));
        }

        @Override
        public <T extends Comparable<T>, V extends T> IBlockState withProperty(IProperty<T> p_withProperty_1_, V p_withProperty_2_) {
            Comparable comparable = (Comparable)this.properties.get(p_withProperty_1_);
            if (comparable == null) {
                throw new IllegalArgumentException("Cannot set property " + p_withProperty_1_ + " as it does not exist in " + this.block.getBlockState());
            }
            if (comparable == p_withProperty_2_) {
                return this;
            }
            IBlockState iblockstate = (IBlockState)this.propertyValueTable.get(p_withProperty_1_, p_withProperty_2_);
            if (iblockstate == null) {
                throw new IllegalArgumentException("Cannot set property " + p_withProperty_1_ + " to " + p_withProperty_2_ + " on block " + Block.REGISTRY.getNameForObject(this.block) + ", it is not an allowed value");
            }
            return iblockstate;
        }

        @Override
        public ImmutableMap<IProperty<?>, Comparable<?>> getProperties() {
            return this.properties;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        public boolean equals(Object p_equals_1_) {
            return this == p_equals_1_;
        }

        public int hashCode() {
            return this.properties.hashCode();
        }

        public void buildPropertyValueTable(Map<Map<IProperty<?>, Comparable<?>>, StateImplementation> p_buildPropertyValueTable_1_) {
            if (this.propertyValueTable != null) {
                throw new IllegalStateException();
            }
            HashBasedTable table = HashBasedTable.create();
            for (Map.Entry entry : this.properties.entrySet()) {
                IProperty iproperty = (IProperty)entry.getKey();
                for (Comparable comparable : iproperty.getAllowedValues()) {
                    if (comparable == entry.getValue()) continue;
                    table.put((Object)iproperty, (Object)comparable, (Object)p_buildPropertyValueTable_1_.get(this.getPropertiesWithValue(iproperty, comparable)));
                }
            }
            this.propertyValueTable = ImmutableTable.copyOf((Table)table);
        }

        private Map<IProperty<?>, Comparable<?>> getPropertiesWithValue(IProperty<?> p_getPropertiesWithValue_1_, Comparable<?> p_getPropertiesWithValue_2_) {
            HashMap map = Maps.newHashMap(this.properties);
            map.put(p_getPropertiesWithValue_1_, p_getPropertiesWithValue_2_);
            return map;
        }

        @Override
        public Material getMaterial() {
            return this.block.getMaterial(this);
        }

        @Override
        public boolean isFullBlock() {
            return this.block.isFullBlock(this);
        }

        @Override
        public boolean canEntitySpawn(Entity p_canEntitySpawn_1_) {
            return this.block.canEntitySpawn(this, p_canEntitySpawn_1_);
        }

        @Override
        public int getLightOpacity() {
            return this.block.getLightOpacity(this);
        }

        @Override
        public int getLightValue() {
            return this.block.getLightValue(this);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean isTranslucent() {
            return this.block.isTranslucent(this);
        }

        @Override
        public boolean useNeighborBrightness() {
            return this.block.getUseNeighborBrightness(this);
        }

        @Override
        public MapColor getMapColor() {
            return this.block.getMapColor(this);
        }

        @Override
        public IBlockState withRotation(Rotation p_withRotation_1_) {
            return this.block.withRotation(this, p_withRotation_1_);
        }

        @Override
        public IBlockState withMirror(Mirror p_withMirror_1_) {
            return this.block.withMirror(this, p_withMirror_1_);
        }

        @Override
        public boolean isFullCube() {
            return this.block.isFullCube(this);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean hasCustomBreakingProgress() {
            return this.block.hasCustomBreakingProgress(this);
        }

        @Override
        public EnumBlockRenderType getRenderType() {
            return this.block.getRenderType(this);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getPackedLightmapCoords(IBlockAccess p_getPackedLightmapCoords_1_, BlockPos p_getPackedLightmapCoords_2_) {
            return this.block.getPackedLightmapCoords(this, p_getPackedLightmapCoords_1_, p_getPackedLightmapCoords_2_);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getAmbientOcclusionLightValue() {
            return this.block.getAmbientOcclusionLightValue(this);
        }

        @Override
        public boolean isBlockNormalCube() {
            return this.block.isBlockNormalCube(this);
        }

        @Override
        public boolean isNormalCube() {
            return this.block.isNormalCube(this);
        }

        @Override
        public boolean canProvidePower() {
            return this.block.canProvidePower(this);
        }

        @Override
        public int getWeakPower(IBlockAccess p_getWeakPower_1_, BlockPos p_getWeakPower_2_, EnumFacing p_getWeakPower_3_) {
            return this.block.getWeakPower(this, p_getWeakPower_1_, p_getWeakPower_2_, p_getWeakPower_3_);
        }

        @Override
        public boolean hasComparatorInputOverride() {
            return this.block.hasComparatorInputOverride(this);
        }

        @Override
        public int getComparatorInputOverride(World p_getComparatorInputOverride_1_, BlockPos p_getComparatorInputOverride_2_) {
            return this.block.getComparatorInputOverride(this, p_getComparatorInputOverride_1_, p_getComparatorInputOverride_2_);
        }

        @Override
        public float getBlockHardness(World p_getBlockHardness_1_, BlockPos p_getBlockHardness_2_) {
            return this.block.getBlockHardness(this, p_getBlockHardness_1_, p_getBlockHardness_2_);
        }

        @Override
        public float getPlayerRelativeBlockHardness(EntityPlayer p_getPlayerRelativeBlockHardness_1_, World p_getPlayerRelativeBlockHardness_2_, BlockPos p_getPlayerRelativeBlockHardness_3_) {
            return this.block.getPlayerRelativeBlockHardness(this, p_getPlayerRelativeBlockHardness_1_, p_getPlayerRelativeBlockHardness_2_, p_getPlayerRelativeBlockHardness_3_);
        }

        @Override
        public int getStrongPower(IBlockAccess p_getStrongPower_1_, BlockPos p_getStrongPower_2_, EnumFacing p_getStrongPower_3_) {
            return this.block.getStrongPower(this, p_getStrongPower_1_, p_getStrongPower_2_, p_getStrongPower_3_);
        }

        @Override
        public EnumPushReaction getMobilityFlag() {
            return this.block.getMobilityFlag(this);
        }

        @Override
        public IBlockState getActualState(IBlockAccess p_getActualState_1_, BlockPos p_getActualState_2_) {
            return this.block.getActualState(this, p_getActualState_1_, p_getActualState_2_);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getSelectedBoundingBox(World p_getSelectedBoundingBox_1_, BlockPos p_getSelectedBoundingBox_2_) {
            return this.block.getSelectedBoundingBox(this, p_getSelectedBoundingBox_1_, p_getSelectedBoundingBox_2_);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean shouldSideBeRendered(IBlockAccess p_shouldSideBeRendered_1_, BlockPos p_shouldSideBeRendered_2_, EnumFacing p_shouldSideBeRendered_3_) {
            return this.block.shouldSideBeRendered(this, p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_);
        }

        @Override
        public boolean isOpaqueCube() {
            return this.block.isOpaqueCube(this);
        }

        @Override
        @Nullable
        public AxisAlignedBB getCollisionBoundingBox(IBlockAccess p_getCollisionBoundingBox_1_, BlockPos p_getCollisionBoundingBox_2_) {
            return this.block.getCollisionBoundingBox(this, p_getCollisionBoundingBox_1_, p_getCollisionBoundingBox_2_);
        }

        @Override
        public void addCollisionBoxToList(World p_addCollisionBoxToList_1_, BlockPos p_addCollisionBoxToList_2_, AxisAlignedBB p_addCollisionBoxToList_3_, List<AxisAlignedBB> p_addCollisionBoxToList_4_, Entity p_addCollisionBoxToList_5_, boolean p_addCollisionBoxToList_6_) {
            this.block.addCollisionBoxToList(this, p_addCollisionBoxToList_1_, p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, p_addCollisionBoxToList_6_);
        }

        @Override
        public AxisAlignedBB getBoundingBox(IBlockAccess p_getBoundingBox_1_, BlockPos p_getBoundingBox_2_) {
            return this.block.getBoundingBox(this, p_getBoundingBox_1_, p_getBoundingBox_2_);
        }

        @Override
        public RayTraceResult collisionRayTrace(World p_collisionRayTrace_1_, BlockPos p_collisionRayTrace_2_, Vec3d p_collisionRayTrace_3_, Vec3d p_collisionRayTrace_4_) {
            return this.block.collisionRayTrace(this, p_collisionRayTrace_1_, p_collisionRayTrace_2_, p_collisionRayTrace_3_, p_collisionRayTrace_4_);
        }

        @Override
        public boolean isFullyOpaque() {
            return this.block.isFullyOpaque(this);
        }

        @Override
        public Vec3d getOffset(IBlockAccess p_getOffset_1_, BlockPos p_getOffset_2_) {
            return this.block.getOffset(this, p_getOffset_1_, p_getOffset_2_);
        }

        @Override
        public boolean onBlockEventReceived(World p_onBlockEventReceived_1_, BlockPos p_onBlockEventReceived_2_, int p_onBlockEventReceived_3_, int p_onBlockEventReceived_4_) {
            return this.block.eventReceived(this, p_onBlockEventReceived_1_, p_onBlockEventReceived_2_, p_onBlockEventReceived_3_, p_onBlockEventReceived_4_);
        }

        @Override
        public void neighborChanged(World p_neighborChanged_1_, BlockPos p_neighborChanged_2_, Block p_neighborChanged_3_, BlockPos p_neighborChanged_4_) {
            this.block.neighborChanged(this, p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_);
        }

        @Override
        public boolean causesSuffocation() {
            return this.block.causesSuffocation(this);
        }

        @Override
        public ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> getPropertyValueTable() {
            return this.propertyValueTable;
        }

        @Override
        public int getLightOpacity(IBlockAccess p_getLightOpacity_1_, BlockPos p_getLightOpacity_2_) {
            return this.block.getLightOpacity(this, p_getLightOpacity_1_, p_getLightOpacity_2_);
        }

        @Override
        public int getLightValue(IBlockAccess p_getLightValue_1_, BlockPos p_getLightValue_2_) {
            return this.block.getLightValue(this, p_getLightValue_1_, p_getLightValue_2_);
        }

        @Override
        public boolean isSideSolid(IBlockAccess p_isSideSolid_1_, BlockPos p_isSideSolid_2_, EnumFacing p_isSideSolid_3_) {
            return this.block.isSideSolid(this, p_isSideSolid_1_, p_isSideSolid_2_, p_isSideSolid_3_);
        }

        @Override
        public boolean doesSideBlockRendering(IBlockAccess p_doesSideBlockRendering_1_, BlockPos p_doesSideBlockRendering_2_, EnumFacing p_doesSideBlockRendering_3_) {
            return this.block.doesSideBlockRendering(this, p_doesSideBlockRendering_1_, p_doesSideBlockRendering_2_, p_doesSideBlockRendering_3_);
        }
    }
}

