/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state.pattern;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BlockPattern {
    private final Predicate<BlockWorldState>[][][] blockMatches;
    private final int fingerLength;
    private final int thumbLength;
    private final int palmLength;

    public BlockPattern(Predicate<BlockWorldState>[][][] p_i45657_1_) {
        this.blockMatches = p_i45657_1_;
        this.fingerLength = p_i45657_1_.length;
        if (this.fingerLength > 0) {
            this.thumbLength = p_i45657_1_[0].length;
            this.palmLength = this.thumbLength > 0 ? p_i45657_1_[0][0].length : 0;
        } else {
            this.thumbLength = 0;
            this.palmLength = 0;
        }
    }

    public int getFingerLength() {
        return this.fingerLength;
    }

    public int getThumbLength() {
        return this.thumbLength;
    }

    public int getPalmLength() {
        return this.palmLength;
    }

    @Nullable
    private PatternHelper checkPatternAt(BlockPos p_checkPatternAt_1_, EnumFacing p_checkPatternAt_2_, EnumFacing p_checkPatternAt_3_, LoadingCache<BlockPos, BlockWorldState> p_checkPatternAt_4_) {
        for (int lvt_5_1_ = 0; lvt_5_1_ < this.palmLength; ++lvt_5_1_) {
            for (int lvt_6_1_ = 0; lvt_6_1_ < this.thumbLength; ++lvt_6_1_) {
                for (int lvt_7_1_ = 0; lvt_7_1_ < this.fingerLength; ++lvt_7_1_) {
                    if (this.blockMatches[lvt_7_1_][lvt_6_1_][lvt_5_1_].apply(p_checkPatternAt_4_.getUnchecked((Object)BlockPattern.translateOffset(p_checkPatternAt_1_, p_checkPatternAt_2_, p_checkPatternAt_3_, lvt_5_1_, lvt_6_1_, lvt_7_1_)))) continue;
                    return null;
                }
            }
        }
        return new PatternHelper(p_checkPatternAt_1_, p_checkPatternAt_2_, p_checkPatternAt_3_, p_checkPatternAt_4_, this.palmLength, this.thumbLength, this.fingerLength);
    }

    @Nullable
    public PatternHelper match(World p_match_1_, BlockPos p_match_2_) {
        LoadingCache<BlockPos, BlockWorldState> lvt_3_1_ = BlockPattern.createLoadingCache(p_match_1_, false);
        int lvt_4_1_ = Math.max(Math.max(this.palmLength, this.thumbLength), this.fingerLength);
        for (BlockPos lvt_6_1_ : BlockPos.getAllInBox(p_match_2_, p_match_2_.add(lvt_4_1_ - 1, lvt_4_1_ - 1, lvt_4_1_ - 1))) {
            for (EnumFacing lvt_10_1_ : EnumFacing.values()) {
                for (EnumFacing lvt_14_1_ : EnumFacing.values()) {
                    PatternHelper lvt_15_1_;
                    if (lvt_14_1_ == lvt_10_1_ || lvt_14_1_ == lvt_10_1_.getOpposite() || (lvt_15_1_ = this.checkPatternAt(lvt_6_1_, lvt_10_1_, lvt_14_1_, lvt_3_1_)) == null) continue;
                    return lvt_15_1_;
                }
            }
        }
        return null;
    }

    public static LoadingCache<BlockPos, BlockWorldState> createLoadingCache(World p_createLoadingCache_0_, boolean p_createLoadingCache_1_) {
        return CacheBuilder.newBuilder().build((com.google.common.cache.CacheLoader)new CacheLoader(p_createLoadingCache_0_, p_createLoadingCache_1_));
    }

    protected static BlockPos translateOffset(BlockPos p_translateOffset_0_, EnumFacing p_translateOffset_1_, EnumFacing p_translateOffset_2_, int p_translateOffset_3_, int p_translateOffset_4_, int p_translateOffset_5_) {
        if (p_translateOffset_1_ == p_translateOffset_2_ || p_translateOffset_1_ == p_translateOffset_2_.getOpposite()) {
            throw new IllegalArgumentException("Invalid forwards & up combination");
        }
        Vec3i lvt_6_1_ = new Vec3i(p_translateOffset_1_.getFrontOffsetX(), p_translateOffset_1_.getFrontOffsetY(), p_translateOffset_1_.getFrontOffsetZ());
        Vec3i lvt_7_1_ = new Vec3i(p_translateOffset_2_.getFrontOffsetX(), p_translateOffset_2_.getFrontOffsetY(), p_translateOffset_2_.getFrontOffsetZ());
        Vec3i lvt_8_1_ = lvt_6_1_.crossProduct(lvt_7_1_);
        return p_translateOffset_0_.add(lvt_7_1_.getX() * -p_translateOffset_4_ + lvt_8_1_.getX() * p_translateOffset_3_ + lvt_6_1_.getX() * p_translateOffset_5_, lvt_7_1_.getY() * -p_translateOffset_4_ + lvt_8_1_.getY() * p_translateOffset_3_ + lvt_6_1_.getY() * p_translateOffset_5_, lvt_7_1_.getZ() * -p_translateOffset_4_ + lvt_8_1_.getZ() * p_translateOffset_3_ + lvt_6_1_.getZ() * p_translateOffset_5_);
    }

    public static class PatternHelper {
        private final BlockPos frontTopLeft;
        private final EnumFacing forwards;
        private final EnumFacing up;
        private final LoadingCache<BlockPos, BlockWorldState> lcache;
        private final int width;
        private final int height;
        private final int depth;

        public PatternHelper(BlockPos p_i46378_1_, EnumFacing p_i46378_2_, EnumFacing p_i46378_3_, LoadingCache<BlockPos, BlockWorldState> p_i46378_4_, int p_i46378_5_, int p_i46378_6_, int p_i46378_7_) {
            this.frontTopLeft = p_i46378_1_;
            this.forwards = p_i46378_2_;
            this.up = p_i46378_3_;
            this.lcache = p_i46378_4_;
            this.width = p_i46378_5_;
            this.height = p_i46378_6_;
            this.depth = p_i46378_7_;
        }

        public BlockPos getFrontTopLeft() {
            return this.frontTopLeft;
        }

        public EnumFacing getForwards() {
            return this.forwards;
        }

        public EnumFacing getUp() {
            return this.up;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public BlockWorldState translateOffset(int p_translateOffset_1_, int p_translateOffset_2_, int p_translateOffset_3_) {
            return (BlockWorldState)this.lcache.getUnchecked((Object)BlockPattern.translateOffset(this.frontTopLeft, this.getForwards(), this.getUp(), p_translateOffset_1_, p_translateOffset_2_, p_translateOffset_3_));
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("up", (Object)this.up).add("forwards", (Object)this.forwards).add("frontTopLeft", (Object)this.frontTopLeft).toString();
        }
    }

    static class CacheLoader
    extends com.google.common.cache.CacheLoader<BlockPos, BlockWorldState> {
        private final World world;
        private final boolean forceLoad;

        public CacheLoader(World p_i46460_1_, boolean p_i46460_2_) {
            this.world = p_i46460_1_;
            this.forceLoad = p_i46460_2_;
        }

        public BlockWorldState load(BlockPos p_load_1_) throws Exception {
            return new BlockWorldState(this.world, p_load_1_, this.forceLoad);
        }

        public /* synthetic */ Object load(Object p_load_1_) throws Exception {
            return this.load((BlockPos)p_load_1_);
        }
    }
}

