/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state.pattern;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;

public class BlockStateMatcher
implements Predicate<IBlockState> {
    public static final Predicate<IBlockState> ANY = new Predicate<IBlockState>(){

        public boolean apply(IBlockState p_apply_1_) {
            return true;
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((IBlockState)p_apply_1_);
        }
    };
    private final BlockStateContainer blockstate;
    private final Map<IProperty<?>, Predicate<?>> propertyPredicates = Maps.newHashMap();

    private BlockStateMatcher(BlockStateContainer p_i45653_1_) {
        this.blockstate = p_i45653_1_;
    }

    public static BlockStateMatcher forBlock(Block p_forBlock_0_) {
        return new BlockStateMatcher(p_forBlock_0_.getBlockState());
    }

    public boolean apply(IBlockState p_apply_1_) {
        if (p_apply_1_ == null || !p_apply_1_.getBlock().equals(this.blockstate.getBlock())) {
            return false;
        }
        for (Map.Entry<IProperty<?>, Predicate<?>> lvt_3_1_ : this.propertyPredicates.entrySet()) {
            if (this.matches(p_apply_1_, lvt_3_1_.getKey(), lvt_3_1_.getValue())) continue;
            return false;
        }
        return true;
    }

    protected <T extends Comparable<T>> boolean matches(IBlockState p_matches_1_, IProperty<T> p_matches_2_, Predicate<?> p_matches_3_) {
        return p_matches_3_.apply(p_matches_1_.getValue(p_matches_2_));
    }

    public <V extends Comparable<V>> BlockStateMatcher where(IProperty<V> p_where_1_, Predicate<? extends V> p_where_2_) {
        if (!this.blockstate.getProperties().contains(p_where_1_)) {
            throw new IllegalArgumentException(this.blockstate + " cannot support property " + p_where_1_);
        }
        this.propertyPredicates.put(p_where_1_, p_where_2_);
        return this;
    }

    public /* synthetic */ boolean apply(Object p_apply_1_) {
        return this.apply((IBlockState)p_apply_1_);
    }
}

