/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MovingSoundMinecart
extends MovingSound {
    private final EntityMinecart minecart;
    private float distance = 0.0f;

    public MovingSoundMinecart(EntityMinecart p_i45105_1_) {
        super(SoundEvents.ENTITY_MINECART_RIDING, SoundCategory.NEUTRAL);
        this.minecart = p_i45105_1_;
        this.repeat = true;
        this.repeatDelay = 0;
    }

    @Override
    public void update() {
        if (this.minecart.isDead) {
            this.donePlaying = true;
            return;
        }
        this.xPosF = (float)this.minecart.posX;
        this.yPosF = (float)this.minecart.posY;
        this.zPosF = (float)this.minecart.posZ;
        float lvt_1_1_ = MathHelper.sqrt(this.minecart.motionX * this.minecart.motionX + this.minecart.motionZ * this.minecart.motionZ);
        if ((double)lvt_1_1_ >= 0.01) {
            this.distance = MathHelper.clamp(this.distance + 0.0025f, 0.0f, 1.0f);
            this.volume = 0.0f + MathHelper.clamp(lvt_1_1_, 0.0f, 0.5f) * 0.7f;
        } else {
            this.distance = 0.0f;
            this.volume = 0.0f;
        }
    }
}

