/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Sound
implements ISoundEventAccessor<Sound> {
    private final ResourceLocation name;
    private final float volume;
    private final float pitch;
    private final int weight;
    private final Type type;
    private final boolean streaming;

    public Sound(String p_i46526_1_, float p_i46526_2_, float p_i46526_3_, int p_i46526_4_, Type p_i46526_5_, boolean p_i46526_6_) {
        this.name = new ResourceLocation(p_i46526_1_);
        this.volume = p_i46526_2_;
        this.pitch = p_i46526_3_;
        this.weight = p_i46526_4_;
        this.type = p_i46526_5_;
        this.streaming = p_i46526_6_;
    }

    public ResourceLocation getSoundLocation() {
        return this.name;
    }

    public ResourceLocation getSoundAsOggLocation() {
        return new ResourceLocation(this.name.getResourceDomain(), "sounds/" + this.name.getResourcePath() + ".ogg");
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public Sound cloneEntry() {
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    @Override
    public /* synthetic */ Object cloneEntry() {
        return this.cloneEntry();
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Type {
        FILE("file"),
        SOUND_EVENT("event");

        private final String name;

        private Type(String p_i46631_3_) {
            this.name = p_i46631_3_;
        }

        public static Type getByName(String p_getByName_0_) {
            for (Type lvt_4_1_ : Type.values()) {
                if (!lvt_4_1_.name.equals(p_getByName_0_)) continue;
                return lvt_4_1_;
            }
            return null;
        }
    }
}

