/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SoundEventAccessor
implements ISoundEventAccessor<Sound> {
    private final List<ISoundEventAccessor<Sound>> accessorList = Lists.newArrayList();
    private final Random rnd = new Random();
    private final ResourceLocation location;
    private final ITextComponent subtitle;

    public SoundEventAccessor(ResourceLocation p_i46521_1_, String p_i46521_2_) {
        this.location = p_i46521_1_;
        this.subtitle = p_i46521_2_ == null ? null : new TextComponentTranslation(p_i46521_2_, new Object[0]);
    }

    @Override
    public int getWeight() {
        int lvt_1_1_ = 0;
        for (ISoundEventAccessor<Sound> lvt_3_1_ : this.accessorList) {
            lvt_1_1_ += lvt_3_1_.getWeight();
        }
        return lvt_1_1_;
    }

    @Override
    public Sound cloneEntry() {
        int lvt_1_1_ = this.getWeight();
        if (this.accessorList.isEmpty() || lvt_1_1_ == 0) {
            return SoundHandler.MISSING_SOUND;
        }
        int lvt_2_1_ = this.rnd.nextInt(lvt_1_1_);
        for (ISoundEventAccessor<Sound> lvt_4_1_ : this.accessorList) {
            if ((lvt_2_1_ -= lvt_4_1_.getWeight()) >= 0) continue;
            return lvt_4_1_.cloneEntry();
        }
        return SoundHandler.MISSING_SOUND;
    }

    public void addSound(ISoundEventAccessor<Sound> p_addSound_1_) {
        this.accessorList.add(p_addSound_1_);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    @Nullable
    public ITextComponent getSubtitle() {
        return this.subtitle;
    }

    @Override
    public /* synthetic */ Object cloneEntry() {
        return this.cloneEntry();
    }
}

