/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundListSerializer;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class SoundHandler
implements IResourceManagerReloadListener,
ITickable {
    public static final Sound MISSING_SOUND = new Sound("meta:missing_sound", 1.0f, 1.0f, 1, Sound.Type.FILE, false);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeAdapter(SoundList.class, (Object)new SoundListSerializer()).create();
    private static final ParameterizedType TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, SoundList.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    private final SoundRegistry soundRegistry = new SoundRegistry();
    private final SoundManager sndManager;
    private final IResourceManager mcResourceManager;

    public SoundHandler(IResourceManager p_i45122_1_, GameSettings p_i45122_2_) {
        this.mcResourceManager = p_i45122_1_;
        this.sndManager = new SoundManager(this, p_i45122_2_);
    }

    @Override
    public void onResourceManagerReload(IResourceManager p_onResourceManagerReload_1_) {
        this.soundRegistry.clearMap();
        for (String lvt_3_1_ : p_onResourceManagerReload_1_.getResourceDomains()) {
            try {
                List<IResource> lvt_4_1_ = p_onResourceManagerReload_1_.getAllResources(new ResourceLocation(lvt_3_1_, "sounds.json"));
                for (IResource lvt_6_1_ : lvt_4_1_) {
                    try {
                        Map<String, SoundList> lvt_7_1_ = this.getSoundMap(lvt_6_1_.getInputStream());
                        for (Map.Entry<String, SoundList> lvt_9_1_ : lvt_7_1_.entrySet()) {
                            this.loadSoundResource(new ResourceLocation(lvt_3_1_, lvt_9_1_.getKey()), lvt_9_1_.getValue());
                        }
                    }
                    catch (RuntimeException lvt_7_2_) {
                        LOGGER.warn("Invalid sounds.json", (Throwable)lvt_7_2_);
                    }
                }
            }
            catch (IOException lvt_4_1_) {
            }
        }
        for (ResourceLocation lvt_3_2_ : this.soundRegistry.getKeys()) {
            String lvt_5_1_;
            SoundEventAccessor lvt_4_2_ = (SoundEventAccessor)this.soundRegistry.getObject(lvt_3_2_);
            if (!(lvt_4_2_.getSubtitle() instanceof TextComponentTranslation) || I18n.hasKey(lvt_5_1_ = ((TextComponentTranslation)lvt_4_2_.getSubtitle()).getKey())) continue;
            LOGGER.debug("Missing subtitle {} for event: {}", new Object[]{lvt_5_1_, lvt_3_2_});
        }
        for (ResourceLocation lvt_3_3_ : this.soundRegistry.getKeys()) {
            if (SoundEvent.REGISTRY.getObject(lvt_3_3_) != null) continue;
            LOGGER.debug("Not having sound event for: {}", new Object[]{lvt_3_3_});
        }
        this.sndManager.reloadSoundSystem();
    }

    protected Map<String, SoundList> getSoundMap(InputStream p_getSoundMap_1_) {
        try {
            Map map = (Map)GSON.fromJson((Reader)new InputStreamReader(p_getSoundMap_1_), (Type)TYPE);
            return map;
        }
        finally {
            IOUtils.closeQuietly((InputStream)p_getSoundMap_1_);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadSoundResource(ResourceLocation p_loadSoundResource_1_, SoundList p_loadSoundResource_2_) {
        boolean lvt_4_1_;
        SoundEventAccessor lvt_3_1_ = (SoundEventAccessor)this.soundRegistry.getObject(p_loadSoundResource_1_);
        boolean bl = lvt_4_1_ = lvt_3_1_ == null;
        if (lvt_4_1_ || p_loadSoundResource_2_.canReplaceExisting()) {
            if (!lvt_4_1_) {
                LOGGER.debug("Replaced sound event location {}", new Object[]{p_loadSoundResource_1_});
            }
            lvt_3_1_ = new SoundEventAccessor(p_loadSoundResource_1_, p_loadSoundResource_2_.getSubtitle());
            this.soundRegistry.add(lvt_3_1_);
        }
        block4: for (Sound lvt_6_1_ : p_loadSoundResource_2_.getSounds()) {
            void lvt_8_3_;
            final ResourceLocation lvt_7_1_ = lvt_6_1_.getSoundLocation();
            switch (lvt_6_1_.getType()) {
                case FILE: {
                    if (!this.validateSoundResource(lvt_6_1_, p_loadSoundResource_1_)) continue block4;
                    Sound lvt_8_1_ = lvt_6_1_;
                    break;
                }
                case SOUND_EVENT: {
                    ISoundEventAccessor<Sound> lvt_8_2_ = new ISoundEventAccessor<Sound>(){

                        @Override
                        public int getWeight() {
                            SoundEventAccessor lvt_1_1_ = (SoundEventAccessor)SoundHandler.this.soundRegistry.getObject(lvt_7_1_);
                            return lvt_1_1_ == null ? 0 : lvt_1_1_.getWeight();
                        }

                        @Override
                        public Sound cloneEntry() {
                            SoundEventAccessor lvt_1_1_ = (SoundEventAccessor)SoundHandler.this.soundRegistry.getObject(lvt_7_1_);
                            return lvt_1_1_ == null ? MISSING_SOUND : lvt_1_1_.cloneEntry();
                        }

                        @Override
                        public /* synthetic */ Object cloneEntry() {
                            return this.cloneEntry();
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SoundEventRegistration type: " + (Object)((Object)lvt_6_1_.getType()));
                }
            }
            lvt_3_1_.addSound((ISoundEventAccessor<Sound>)lvt_8_3_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean validateSoundResource(Sound p_validateSoundResource_1_, ResourceLocation p_validateSoundResource_2_) {
        ResourceLocation lvt_3_1_ = p_validateSoundResource_1_.getSoundAsOggLocation();
        IResource lvt_4_1_ = null;
        try {
            lvt_4_1_ = this.mcResourceManager.getResource(lvt_3_1_);
            lvt_4_1_.getInputStream();
        }
        catch (FileNotFoundException lvt_5_1_) {
            LOGGER.warn("File {} does not exist, cannot add it to event {}", new Object[]{lvt_3_1_, p_validateSoundResource_2_});
            boolean bl = false;
            IOUtils.closeQuietly((Closeable)lvt_4_1_);
            return bl;
        }
        catch (IOException lvt_5_2_) {
            LOGGER.warn("Could not load sound file {}, cannot add it to event {}", new Object[]{lvt_3_1_, p_validateSoundResource_2_, lvt_5_2_});
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(lvt_4_1_);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)lvt_4_1_);
            return bl;
        }
        IOUtils.closeQuietly((Closeable)lvt_4_1_);
        return true;
    }

    @Nullable
    public SoundEventAccessor getAccessor(ResourceLocation p_getAccessor_1_) {
        return (SoundEventAccessor)this.soundRegistry.getObject(p_getAccessor_1_);
    }

    public void playSound(ISound p_playSound_1_) {
        this.sndManager.playSound(p_playSound_1_);
    }

    public void playDelayedSound(ISound p_playDelayedSound_1_, int p_playDelayedSound_2_) {
        this.sndManager.playDelayedSound(p_playDelayedSound_1_, p_playDelayedSound_2_);
    }

    public void setListener(EntityPlayer p_setListener_1_, float p_setListener_2_) {
        this.sndManager.setListener(p_setListener_1_, p_setListener_2_);
    }

    public void pauseSounds() {
        this.sndManager.pauseAllSounds();
    }

    public void stopSounds() {
        this.sndManager.stopAllSounds();
    }

    public void unloadSounds() {
        this.sndManager.unloadSoundSystem();
    }

    @Override
    public void update() {
        this.sndManager.updateAllSounds();
    }

    public void resumeSounds() {
        this.sndManager.resumeAllSounds();
    }

    public void setSoundLevel(SoundCategory p_setSoundLevel_1_, float p_setSoundLevel_2_) {
        if (p_setSoundLevel_1_ == SoundCategory.MASTER && p_setSoundLevel_2_ <= 0.0f) {
            this.stopSounds();
        }
        this.sndManager.setVolume(p_setSoundLevel_1_, p_setSoundLevel_2_);
    }

    public void stopSound(ISound p_stopSound_1_) {
        this.sndManager.stopSound(p_stopSound_1_);
    }

    public boolean isSoundPlaying(ISound p_isSoundPlaying_1_) {
        return this.sndManager.isSoundPlaying(p_isSoundPlaying_1_);
    }

    public void addListener(ISoundEventListener p_addListener_1_) {
        this.sndManager.addListener(p_addListener_1_);
    }

    public void removeListener(ISoundEventListener p_removeListener_1_) {
        this.sndManager.removeListener(p_removeListener_1_);
    }

    public void stop(String p_stop_1_, SoundCategory p_stop_2_) {
        this.sndManager.stop(p_stop_1_, p_stop_2_);
    }
}

