/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundList;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

@SideOnly(value=Side.CLIENT)
public class SoundListSerializer
implements JsonDeserializer<SoundList> {
    public SoundList deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
        JsonObject lvt_4_1_ = JsonUtils.getJsonObject(p_deserialize_1_, "entry");
        boolean lvt_5_1_ = JsonUtils.getBoolean(lvt_4_1_, "replace", false);
        String lvt_6_1_ = JsonUtils.getString(lvt_4_1_, "subtitle", null);
        List<Sound> lvt_7_1_ = this.deserializeSounds(lvt_4_1_);
        return new SoundList(lvt_7_1_, lvt_5_1_, lvt_6_1_);
    }

    private List<Sound> deserializeSounds(JsonObject p_deserializeSounds_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        if (p_deserializeSounds_1_.has("sounds")) {
            JsonArray lvt_3_1_ = JsonUtils.getJsonArray(p_deserializeSounds_1_, "sounds");
            for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_3_1_.size(); ++lvt_4_1_) {
                JsonElement lvt_5_1_ = lvt_3_1_.get(lvt_4_1_);
                if (JsonUtils.isString(lvt_5_1_)) {
                    String lvt_6_1_ = JsonUtils.getString(lvt_5_1_, "sound");
                    lvt_2_1_.add(new Sound(lvt_6_1_, 1.0f, 1.0f, 1, Sound.Type.FILE, false));
                    continue;
                }
                lvt_2_1_.add(this.deserializeSound(JsonUtils.getJsonObject(lvt_5_1_, "sound")));
            }
        }
        return lvt_2_1_;
    }

    private Sound deserializeSound(JsonObject p_deserializeSound_1_) {
        String lvt_2_1_ = JsonUtils.getString(p_deserializeSound_1_, "name");
        Sound.Type lvt_3_1_ = this.deserializeType(p_deserializeSound_1_, Sound.Type.FILE);
        float lvt_4_1_ = JsonUtils.getFloat(p_deserializeSound_1_, "volume", 1.0f);
        Validate.isTrue((lvt_4_1_ > 0.0f ? 1 : 0) != 0, (String)"Invalid volume", (Object[])new Object[0]);
        float lvt_5_1_ = JsonUtils.getFloat(p_deserializeSound_1_, "pitch", 1.0f);
        Validate.isTrue((lvt_5_1_ > 0.0f ? 1 : 0) != 0, (String)"Invalid pitch", (Object[])new Object[0]);
        int lvt_6_1_ = JsonUtils.getInt(p_deserializeSound_1_, "weight", 1);
        Validate.isTrue((lvt_6_1_ > 0 ? 1 : 0) != 0, (String)"Invalid weight", (Object[])new Object[0]);
        boolean lvt_7_1_ = JsonUtils.getBoolean(p_deserializeSound_1_, "stream", false);
        return new Sound(lvt_2_1_, lvt_4_1_, lvt_5_1_, lvt_6_1_, lvt_3_1_, lvt_7_1_);
    }

    private Sound.Type deserializeType(JsonObject p_deserializeType_1_, Sound.Type p_deserializeType_2_) {
        Sound.Type lvt_3_1_ = p_deserializeType_2_;
        if (p_deserializeType_1_.has("type")) {
            lvt_3_1_ = Sound.Type.getByName(JsonUtils.getString(p_deserializeType_1_, "type"));
            Validate.notNull((Object)((Object)lvt_3_1_), (String)"Invalid type", (Object[])new Object[0]);
        }
        return lvt_3_1_;
    }

    public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
        return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
    }
}

