/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.Source;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

@SideOnly(value=Side.CLIENT)
public class SoundManager {
    private static final Marker LOG_MARKER = MarkerManager.getMarker((String)"SOUNDS");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ResourceLocation> UNABLE_TO_PLAY = Sets.newHashSet();
    public final SoundHandler sndHandler;
    private final GameSettings options;
    private SoundSystemStarterThread sndSystem;
    private boolean loaded;
    private int playTime;
    private final Map<String, ISound> playingSounds = HashBiMap.create();
    private final Map<ISound, String> invPlayingSounds = ((BiMap)this.playingSounds).inverse();
    private final Multimap<SoundCategory, String> categorySounds = HashMultimap.create();
    private final List<ITickableSound> tickableSounds = Lists.newArrayList();
    private final Map<ISound, Integer> delayedSounds = Maps.newHashMap();
    private final Map<String, Integer> playingSoundsStopTime = Maps.newHashMap();
    private final List<ISoundEventListener> listeners = Lists.newArrayList();
    private final List<String> pausedChannels = Lists.newArrayList();

    public SoundManager(SoundHandler p_i45119_1_, GameSettings p_i45119_2_) {
        this.sndHandler = p_i45119_1_;
        this.options = p_i45119_2_;
        try {
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
            MinecraftForge.EVENT_BUS.post(new SoundSetupEvent(this));
        }
        catch (SoundSystemException soundsystemexception) {
            LOGGER.error(LOG_MARKER, "Error linking with the LibraryJavaSound plug-in", (Throwable)soundsystemexception);
        }
    }

    public void reloadSoundSystem() {
        UNABLE_TO_PLAY.clear();
        for (SoundEvent soundevent : SoundEvent.REGISTRY) {
            ResourceLocation resourcelocation = soundevent.getSoundName();
            if (this.sndHandler.getAccessor(resourcelocation) != null) continue;
            LOGGER.warn("Missing sound for event: {}", new Object[]{SoundEvent.REGISTRY.getNameForObject(soundevent)});
            UNABLE_TO_PLAY.add(resourcelocation);
        }
        this.unloadSoundSystem();
        this.loadSoundSystem();
        MinecraftForge.EVENT_BUS.post(new SoundLoadEvent(this));
    }

    private synchronized void loadSoundSystem() {
        if (!this.loaded) {
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SoundSystemConfig.setLogger((SoundSystemLogger)new SoundSystemLogger(){

                            public void message(String p_message_1_, int p_message_2_) {
                                if (!p_message_1_.isEmpty()) {
                                    LOGGER.info(p_message_1_);
                                }
                            }

                            public void importantMessage(String p_importantMessage_1_, int p_importantMessage_2_) {
                                if (!p_importantMessage_1_.isEmpty()) {
                                    LOGGER.warn(p_importantMessage_1_);
                                }
                            }

                            public void errorMessage(String p_errorMessage_1_, String p_errorMessage_2_, int p_errorMessage_3_) {
                                if (!p_errorMessage_2_.isEmpty()) {
                                    LOGGER.error("Error in class '{}'", new Object[]{p_errorMessage_1_});
                                    LOGGER.error(p_errorMessage_2_);
                                }
                            }
                        });
                        SoundManager soundManager = SoundManager.this;
                        soundManager.getClass();
                        SoundManager.this.sndSystem = soundManager.new SoundSystemStarterThread();
                        SoundManager.this.loaded = true;
                        SoundManager.this.sndSystem.setMasterVolume(SoundManager.this.options.getSoundLevel(SoundCategory.MASTER));
                        LOGGER.info(LOG_MARKER, "Sound engine started");
                    }
                }, "Sound Library Loader").start();
            }
            catch (RuntimeException runtimeexception) {
                LOGGER.error(LOG_MARKER, "Error starting SoundSystem. Turning off sounds & music", (Throwable)runtimeexception);
                this.options.setSoundLevel(SoundCategory.MASTER, 0.0f);
                this.options.saveOptions();
            }
        }
    }

    private float getVolume(SoundCategory p_getVolume_1_) {
        return p_getVolume_1_ != null && p_getVolume_1_ != SoundCategory.MASTER ? this.options.getSoundLevel(p_getVolume_1_) : 1.0f;
    }

    public void setVolume(SoundCategory p_setVolume_1_, float p_setVolume_2_) {
        if (this.loaded) {
            if (p_setVolume_1_ == SoundCategory.MASTER) {
                this.sndSystem.setMasterVolume(p_setVolume_2_);
            } else {
                for (String s : this.categorySounds.get((Object)p_setVolume_1_)) {
                    ISound isound = this.playingSounds.get(s);
                    float f = this.getClampedVolume(isound);
                    if (f <= 0.0f) {
                        this.stopSound(isound);
                        continue;
                    }
                    this.sndSystem.setVolume(s, f);
                }
            }
        }
    }

    public void unloadSoundSystem() {
        if (this.loaded) {
            this.stopAllSounds();
            this.sndSystem.cleanup();
            this.loaded = false;
        }
    }

    public void stopAllSounds() {
        if (this.loaded) {
            for (String s : this.playingSounds.keySet()) {
                this.sndSystem.stop(s);
            }
            this.pausedChannels.clear();
            this.playingSounds.clear();
            this.delayedSounds.clear();
            this.tickableSounds.clear();
            this.categorySounds.clear();
            this.playingSoundsStopTime.clear();
        }
    }

    public void addListener(ISoundEventListener p_addListener_1_) {
        this.listeners.add(p_addListener_1_);
    }

    public void removeListener(ISoundEventListener p_removeListener_1_) {
        this.listeners.remove(p_removeListener_1_);
    }

    public void updateAllSounds() {
        ++this.playTime;
        for (ITickableSound itickablesound : this.tickableSounds) {
            itickablesound.update();
            if (itickablesound.isDonePlaying()) {
                this.stopSound(itickablesound);
                continue;
            }
            String s = this.invPlayingSounds.get(itickablesound);
            this.sndSystem.setVolume(s, this.getClampedVolume(itickablesound));
            this.sndSystem.setPitch(s, this.getClampedPitch(itickablesound));
            this.sndSystem.setPosition(s, itickablesound.getXPosF(), itickablesound.getYPosF(), itickablesound.getZPosF());
        }
        Iterator<Map.Entry<String, ISound>> iterator = this.playingSounds.entrySet().iterator();
        while (iterator.hasNext()) {
            int i;
            Map.Entry<String, ISound> entry = iterator.next();
            String s1 = entry.getKey();
            ISound isound = entry.getValue();
            if (this.sndSystem.playing(s1) || (i = this.playingSoundsStopTime.get(s1).intValue()) > this.playTime) continue;
            int j = isound.getRepeatDelay();
            if (isound.canRepeat() && j > 0) {
                this.delayedSounds.put(isound, this.playTime + j);
            }
            iterator.remove();
            LOGGER.debug(LOG_MARKER, "Removed channel {} because it's not playing anymore", new Object[]{s1});
            this.sndSystem.removeSource(s1);
            this.playingSoundsStopTime.remove(s1);
            try {
                this.categorySounds.remove((Object)isound.getCategory(), (Object)s1);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(isound instanceof ITickableSound)) continue;
            this.tickableSounds.remove(isound);
        }
        Iterator<Map.Entry<ISound, Integer>> iterator1 = this.delayedSounds.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry<ISound, Integer> entry1 = iterator1.next();
            if (this.playTime < entry1.getValue()) continue;
            ISound isound1 = entry1.getKey();
            if (isound1 instanceof ITickableSound) {
                ((ITickableSound)isound1).update();
            }
            this.playSound(isound1);
            iterator1.remove();
        }
    }

    public boolean isSoundPlaying(ISound p_isSoundPlaying_1_) {
        if (!this.loaded) {
            return false;
        }
        String s = this.invPlayingSounds.get(p_isSoundPlaying_1_);
        return s == null ? false : this.sndSystem.playing(s) || this.playingSoundsStopTime.containsKey(s) && this.playingSoundsStopTime.get(s) <= this.playTime;
    }

    public void stopSound(ISound p_stopSound_1_) {
        String s;
        if (this.loaded && (s = this.invPlayingSounds.get(p_stopSound_1_)) != null) {
            this.sndSystem.stop(s);
        }
    }

    public void playSound(ISound p_playSound_1_) {
        if (this.loaded) {
            if ((p_playSound_1_ = ForgeHooksClient.playSound(this, p_playSound_1_)) == null) {
                return;
            }
            SoundEventAccessor soundeventaccessor = p_playSound_1_.createAccessor(this.sndHandler);
            ResourceLocation resourcelocation = p_playSound_1_.getSoundLocation();
            if (soundeventaccessor == null) {
                if (UNABLE_TO_PLAY.add(resourcelocation)) {
                    LOGGER.warn(LOG_MARKER, "Unable to play unknown soundEvent: {}", new Object[]{resourcelocation});
                }
            } else {
                if (!this.listeners.isEmpty()) {
                    for (ISoundEventListener isoundeventlistener : this.listeners) {
                        isoundeventlistener.soundPlay(p_playSound_1_, soundeventaccessor);
                    }
                }
                if (this.sndSystem.getMasterVolume() <= 0.0f) {
                    LOGGER.debug(LOG_MARKER, "Skipped playing soundEvent: {}, master volume was zero", new Object[]{resourcelocation});
                } else {
                    Sound sound = p_playSound_1_.getSound();
                    if (sound == SoundHandler.MISSING_SOUND) {
                        if (UNABLE_TO_PLAY.add(resourcelocation)) {
                            LOGGER.warn(LOG_MARKER, "Unable to play empty soundEvent: {}", new Object[]{resourcelocation});
                        }
                    } else {
                        float f3 = p_playSound_1_.getVolume();
                        float f = 16.0f;
                        if (f3 > 1.0f) {
                            f *= f3;
                        }
                        SoundCategory soundcategory = p_playSound_1_.getCategory();
                        float f1 = this.getClampedVolume(p_playSound_1_);
                        float f2 = this.getClampedPitch(p_playSound_1_);
                        if (f1 == 0.0f) {
                            LOGGER.debug(LOG_MARKER, "Skipped playing sound {}, volume was zero.", new Object[]{sound.getSoundLocation()});
                        } else {
                            boolean flag = p_playSound_1_.canRepeat() && p_playSound_1_.getRepeatDelay() == 0;
                            String s = MathHelper.getRandomUUID((Random)ThreadLocalRandom.current()).toString();
                            ResourceLocation resourcelocation1 = sound.getSoundAsOggLocation();
                            if (sound.isStreaming()) {
                                this.sndSystem.newStreamingSource(false, s, SoundManager.getURLForSoundResource(resourcelocation1), resourcelocation1.toString(), flag, p_playSound_1_.getXPosF(), p_playSound_1_.getYPosF(), p_playSound_1_.getZPosF(), p_playSound_1_.getAttenuationType().getTypeInt(), f);
                                MinecraftForge.EVENT_BUS.post(new PlayStreamingSourceEvent(this, p_playSound_1_, s));
                            } else {
                                this.sndSystem.newSource(false, s, SoundManager.getURLForSoundResource(resourcelocation1), resourcelocation1.toString(), flag, p_playSound_1_.getXPosF(), p_playSound_1_.getYPosF(), p_playSound_1_.getZPosF(), p_playSound_1_.getAttenuationType().getTypeInt(), f);
                                MinecraftForge.EVENT_BUS.post(new PlaySoundSourceEvent(this, p_playSound_1_, s));
                            }
                            LOGGER.debug(LOG_MARKER, "Playing sound {} for event {} as channel {}", new Object[]{sound.getSoundLocation(), resourcelocation, s});
                            this.sndSystem.setPitch(s, f2);
                            this.sndSystem.setVolume(s, f1);
                            this.sndSystem.play(s);
                            this.playingSoundsStopTime.put(s, this.playTime + 20);
                            this.playingSounds.put(s, p_playSound_1_);
                            this.categorySounds.put((Object)soundcategory, (Object)s);
                            if (p_playSound_1_ instanceof ITickableSound) {
                                this.tickableSounds.add((ITickableSound)p_playSound_1_);
                            }
                        }
                    }
                }
            }
        }
    }

    private float getClampedPitch(ISound p_getClampedPitch_1_) {
        return MathHelper.clamp(p_getClampedPitch_1_.getPitch(), 0.5f, 2.0f);
    }

    private float getClampedVolume(ISound p_getClampedVolume_1_) {
        return MathHelper.clamp(p_getClampedVolume_1_.getVolume() * this.getVolume(p_getClampedVolume_1_.getCategory()), 0.0f, 1.0f);
    }

    public void pauseAllSounds() {
        for (Map.Entry<String, ISound> entry : this.playingSounds.entrySet()) {
            String s = entry.getKey();
            boolean flag = this.isSoundPlaying(entry.getValue());
            if (!flag) continue;
            LOGGER.debug(LOG_MARKER, "Pausing channel {}", new Object[]{s});
            this.sndSystem.pause(s);
            this.pausedChannels.add(s);
        }
    }

    public void resumeAllSounds() {
        for (String s : this.pausedChannels) {
            LOGGER.debug(LOG_MARKER, "Resuming channel {}", new Object[]{s});
            this.sndSystem.play(s);
        }
        this.pausedChannels.clear();
    }

    public void playDelayedSound(ISound p_playDelayedSound_1_, int p_playDelayedSound_2_) {
        this.delayedSounds.put(p_playDelayedSound_1_, this.playTime + p_playDelayedSound_2_);
    }

    private static URL getURLForSoundResource(final ResourceLocation p_getURLForSoundResource_0_) {
        String s = String.format("%s:%s:%s", "mcsounddomain", p_getURLForSoundResource_0_.getResourceDomain(), p_getURLForSoundResource_0_.getResourcePath());
        URLStreamHandler urlstreamhandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL p_openConnection_1_) {
                return new URLConnection(p_openConnection_1_){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Minecraft.getMinecraft().getResourceManager().getResource(p_getURLForSoundResource_0_).getInputStream();
                    }
                };
            }
        };
        try {
            return new URL((URL)null, s, urlstreamhandler);
        }
        catch (MalformedURLException var4) {
            throw new Error("TODO: Sanely handle url exception! :D");
        }
    }

    public void setListener(EntityPlayer p_setListener_1_, float p_setListener_2_) {
        if (this.loaded && p_setListener_1_ != null) {
            float f = p_setListener_1_.prevRotationPitch + (p_setListener_1_.rotationPitch - p_setListener_1_.prevRotationPitch) * p_setListener_2_;
            float f1 = p_setListener_1_.prevRotationYaw + (p_setListener_1_.rotationYaw - p_setListener_1_.prevRotationYaw) * p_setListener_2_;
            double d0 = p_setListener_1_.prevPosX + (p_setListener_1_.posX - p_setListener_1_.prevPosX) * (double)p_setListener_2_;
            double d1 = p_setListener_1_.prevPosY + (p_setListener_1_.posY - p_setListener_1_.prevPosY) * (double)p_setListener_2_ + (double)p_setListener_1_.getEyeHeight();
            double d2 = p_setListener_1_.prevPosZ + (p_setListener_1_.posZ - p_setListener_1_.prevPosZ) * (double)p_setListener_2_;
            float f2 = MathHelper.cos((f1 + 90.0f) * ((float)Math.PI / 180));
            float f3 = MathHelper.sin((f1 + 90.0f) * ((float)Math.PI / 180));
            float f4 = MathHelper.cos(-f * ((float)Math.PI / 180));
            float f5 = MathHelper.sin(-f * ((float)Math.PI / 180));
            float f6 = MathHelper.cos((-f + 90.0f) * ((float)Math.PI / 180));
            float f7 = MathHelper.sin((-f + 90.0f) * ((float)Math.PI / 180));
            float f8 = f2 * f4;
            float f9 = f3 * f4;
            float f10 = f2 * f6;
            float f11 = f3 * f6;
            this.sndSystem.setListenerPosition((float)d0, (float)d1, (float)d2);
            this.sndSystem.setListenerOrientation(f8, f5, f9, f10, f7, f11);
        }
    }

    public void stop(String p_stop_1_, SoundCategory p_stop_2_) {
        if (p_stop_2_ != null) {
            for (String s : this.categorySounds.get((Object)p_stop_2_)) {
                ISound isound = this.playingSounds.get(s);
                if (p_stop_1_.isEmpty()) {
                    this.stopSound(isound);
                    continue;
                }
                if (!isound.getSoundLocation().equals(new ResourceLocation(p_stop_1_))) continue;
                this.stopSound(isound);
            }
        } else if (p_stop_1_.isEmpty()) {
            this.stopAllSounds();
        } else {
            for (ISound isound1 : this.playingSounds.values()) {
                if (!isound1.getSoundLocation().equals(new ResourceLocation(p_stop_1_))) continue;
                this.stopSound(isound1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    class SoundSystemStarterThread
    extends SoundSystem {
        private SoundSystemStarterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean playing(String p_playing_1_) {
            Object object = SoundSystemConfig.THREAD_SYNC;
            synchronized (object) {
                if (this.soundLibrary == null) {
                    return false;
                }
                Source source = (Source)this.soundLibrary.getSources().get(p_playing_1_);
                boolean bl = source == null ? false : source.playing() || source.paused() || source.preLoad;
                return bl;
            }
        }
    }
}

