/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityOtherPlayerMP
extends AbstractClientPlayer {
    private int otherPlayerMPPosRotationIncrements;
    private double otherPlayerMPX;
    private double otherPlayerMPY;
    private double otherPlayerMPZ;
    private double otherPlayerMPYaw;
    private double otherPlayerMPPitch;

    public EntityOtherPlayerMP(World p_i45075_1_, GameProfile p_i45075_2_) {
        super(p_i45075_1_, p_i45075_2_);
        this.stepHeight = 0.0f;
        this.noClip = true;
        this.renderOffsetY = 0.25f;
    }

    @Override
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double lvt_3_1_ = this.getEntityBoundingBox().getAverageEdgeLength() * 10.0;
        if (Double.isNaN(lvt_3_1_)) {
            lvt_3_1_ = 1.0;
        }
        return p_isInRangeToRenderDist_1_ < (lvt_3_1_ *= 64.0 * EntityOtherPlayerMP.getRenderDistanceWeight()) * lvt_3_1_;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        return true;
    }

    @Override
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        this.otherPlayerMPX = p_setPositionAndRotationDirect_1_;
        this.otherPlayerMPY = p_setPositionAndRotationDirect_3_;
        this.otherPlayerMPZ = p_setPositionAndRotationDirect_5_;
        this.otherPlayerMPYaw = p_setPositionAndRotationDirect_7_;
        this.otherPlayerMPPitch = p_setPositionAndRotationDirect_8_;
        this.otherPlayerMPPosRotationIncrements = p_setPositionAndRotationDirect_9_;
    }

    @Override
    public void onUpdate() {
        this.renderOffsetY = 0.0f;
        super.onUpdate();
        this.prevLimbSwingAmount = this.limbSwingAmount;
        double lvt_1_1_ = this.posX - this.prevPosX;
        double lvt_3_1_ = this.posZ - this.prevPosZ;
        float lvt_5_1_ = MathHelper.sqrt(lvt_1_1_ * lvt_1_1_ + lvt_3_1_ * lvt_3_1_) * 4.0f;
        if (lvt_5_1_ > 1.0f) {
            lvt_5_1_ = 1.0f;
        }
        this.limbSwingAmount += (lvt_5_1_ - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }

    @Override
    public void onLivingUpdate() {
        if (this.otherPlayerMPPosRotationIncrements > 0) {
            double lvt_7_1_;
            double lvt_1_1_ = this.posX + (this.otherPlayerMPX - this.posX) / (double)this.otherPlayerMPPosRotationIncrements;
            double lvt_3_1_ = this.posY + (this.otherPlayerMPY - this.posY) / (double)this.otherPlayerMPPosRotationIncrements;
            double lvt_5_1_ = this.posZ + (this.otherPlayerMPZ - this.posZ) / (double)this.otherPlayerMPPosRotationIncrements;
            for (lvt_7_1_ = this.otherPlayerMPYaw - (double)this.rotationYaw; lvt_7_1_ < -180.0; lvt_7_1_ += 360.0) {
            }
            while (lvt_7_1_ >= 180.0) {
                lvt_7_1_ -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + lvt_7_1_ / (double)this.otherPlayerMPPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.otherPlayerMPPitch - (double)this.rotationPitch) / (double)this.otherPlayerMPPosRotationIncrements);
            --this.otherPlayerMPPosRotationIncrements;
            this.setPosition(lvt_1_1_, lvt_3_1_, lvt_5_1_);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        this.prevCameraYaw = this.cameraYaw;
        this.updateArmSwingProgress();
        float lvt_1_2_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float lvt_2_1_ = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (lvt_1_2_ > 0.1f) {
            lvt_1_2_ = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0.0f) {
            lvt_1_2_ = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0.0f) {
            lvt_2_1_ = 0.0f;
        }
        this.cameraYaw += (lvt_1_2_ - this.cameraYaw) * 0.4f;
        this.cameraPitch += (lvt_2_1_ - this.cameraPitch) * 0.8f;
        this.world.theProfiler.startSection("push");
        this.collideWithNearbyEntities();
        this.world.theProfiler.endSection();
    }

    @Override
    public void sendMessage(ITextComponent p_sendMessage_1_) {
        Minecraft.getMinecraft().ingameGUI.getChatGUI().printChatMessage(p_sendMessage_1_);
    }

    @Override
    public boolean canUseCommand(int p_canUseCommand_1_, String p_canUseCommand_2_) {
        return false;
    }

    @Override
    public BlockPos getPosition() {
        return new BlockPos(this.posX + 0.5, this.posY + 0.5, this.posZ + 0.5);
    }
}

