/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.play.server.SPacketUpdateBossInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoLerping;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBossOverlay
extends Gui {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private final Minecraft client;
    private final Map<UUID, BossInfoLerping> mapBossInfos = Maps.newLinkedHashMap();

    public GuiBossOverlay(Minecraft p_i46606_1_) {
        this.client = p_i46606_1_;
    }

    public void renderBossHealth() {
        if (!this.mapBossInfos.isEmpty()) {
            ScaledResolution scaledresolution = new ScaledResolution(this.client);
            int i = scaledresolution.getScaledWidth();
            int j = 12;
            for (BossInfoLerping bossinfolerping : this.mapBossInfos.values()) {
                int k;
                RenderGameOverlayEvent.BossInfo event = ForgeHooksClient.bossBarRenderPre(scaledresolution, bossinfolerping, k = i / 2 - 91, j, 10 + this.client.fontRendererObj.FONT_HEIGHT);
                if (!event.isCanceled()) {
                    GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                    this.client.getTextureManager().bindTexture(GUI_BARS_TEXTURES);
                    this.render(k, j, bossinfolerping);
                    String s = bossinfolerping.getName().getFormattedText();
                    this.client.fontRendererObj.drawStringWithShadow(s, i / 2 - this.client.fontRendererObj.getStringWidth(s) / 2, j - 9, 0xFFFFFF);
                }
                ForgeHooksClient.bossBarRenderPost(scaledresolution);
                if ((j += event.getIncrement()) < scaledresolution.getScaledHeight() / 3) continue;
                break;
            }
        }
    }

    private void render(int p_render_1_, int p_render_2_, BossInfo p_render_3_) {
        int i;
        this.drawTexturedModalRect(p_render_1_, p_render_2_, 0, p_render_3_.getColor().ordinal() * 5 * 2, 182, 5);
        if (p_render_3_.getOverlay() != BossInfo.Overlay.PROGRESS) {
            this.drawTexturedModalRect(p_render_1_, p_render_2_, 0, 80 + (p_render_3_.getOverlay().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i = (int)(p_render_3_.getPercent() * 183.0f)) > 0) {
            this.drawTexturedModalRect(p_render_1_, p_render_2_, 0, p_render_3_.getColor().ordinal() * 5 * 2 + 5, i, 5);
            if (p_render_3_.getOverlay() != BossInfo.Overlay.PROGRESS) {
                this.drawTexturedModalRect(p_render_1_, p_render_2_, 0, 80 + (p_render_3_.getOverlay().ordinal() - 1) * 5 * 2 + 5, i, 5);
            }
        }
    }

    public void read(SPacketUpdateBossInfo p_read_1_) {
        if (p_read_1_.getOperation() == SPacketUpdateBossInfo.Operation.ADD) {
            this.mapBossInfos.put(p_read_1_.getUniqueId(), new BossInfoLerping(p_read_1_));
        } else if (p_read_1_.getOperation() == SPacketUpdateBossInfo.Operation.REMOVE) {
            this.mapBossInfos.remove(p_read_1_.getUniqueId());
        } else {
            this.mapBossInfos.get(p_read_1_.getUniqueId()).updateFromPacket(p_read_1_);
        }
    }

    public void clearBossInfos() {
        this.mapBossInfos.clear();
    }

    public boolean shouldPlayEndBossMusic() {
        if (!this.mapBossInfos.isEmpty()) {
            for (BossInfo bossInfo : this.mapBossInfos.values()) {
                if (!bossInfo.shouldPlayEndBossMusic()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldDarkenSky() {
        if (!this.mapBossInfos.isEmpty()) {
            for (BossInfo bossInfo : this.mapBossInfos.values()) {
                if (!bossInfo.shouldDarkenSky()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldCreateFog() {
        if (!this.mapBossInfos.isEmpty()) {
            for (BossInfo bossInfo : this.mapBossInfos.values()) {
                if (!bossInfo.shouldCreateFog()) continue;
                return true;
            }
        }
        return false;
    }
}

