/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ITabCompleter;
import net.minecraft.util.TabCompleter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiChat
extends GuiScreen
implements ITabCompleter {
    private static final Logger LOGGER = LogManager.getLogger();
    private String historyBuffer = "";
    private int sentHistoryCursor = -1;
    private TabCompleter tabCompleter;
    protected GuiTextField inputField;
    private String defaultInputFieldText = "";

    public GuiChat() {
    }

    public GuiChat(String p_i1024_1_) {
        this.defaultInputFieldText = p_i1024_1_;
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.sentHistoryCursor = this.mc.ingameGUI.getChatGUI().getSentMessages().size();
        this.inputField = new GuiTextField(0, this.fontRendererObj, 4, this.height - 12, this.width - 4, 12);
        this.inputField.setMaxStringLength(256);
        this.inputField.setEnableBackgroundDrawing(false);
        this.inputField.setFocused(true);
        this.inputField.setText(this.defaultInputFieldText);
        this.inputField.setCanLoseFocus(false);
        this.tabCompleter = new ChatTabCompleter(this.inputField);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.mc.ingameGUI.getChatGUI().resetScroll();
    }

    @Override
    public void updateScreen() {
        this.inputField.updateCursorCounter();
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        this.tabCompleter.resetRequested();
        if (p_keyTyped_2_ == 15) {
            this.tabCompleter.complete();
        } else {
            this.tabCompleter.resetDidComplete();
        }
        if (p_keyTyped_2_ == 1) {
            this.mc.displayGuiScreen(null);
        } else if (p_keyTyped_2_ == 28 || p_keyTyped_2_ == 156) {
            String lvt_3_1_ = this.inputField.getText().trim();
            if (!lvt_3_1_.isEmpty()) {
                this.sendChatMessage(lvt_3_1_);
            }
            this.mc.displayGuiScreen(null);
        } else if (p_keyTyped_2_ == 200) {
            this.getSentHistory(-1);
        } else if (p_keyTyped_2_ == 208) {
            this.getSentHistory(1);
        } else if (p_keyTyped_2_ == 201) {
            this.mc.ingameGUI.getChatGUI().scroll(this.mc.ingameGUI.getChatGUI().getLineCount() - 1);
        } else if (p_keyTyped_2_ == 209) {
            this.mc.ingameGUI.getChatGUI().scroll(-this.mc.ingameGUI.getChatGUI().getLineCount() + 1);
        } else {
            this.inputField.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int lvt_1_1_ = Mouse.getEventDWheel();
        if (lvt_1_1_ != 0) {
            if (lvt_1_1_ > 1) {
                lvt_1_1_ = 1;
            }
            if (lvt_1_1_ < -1) {
                lvt_1_1_ = -1;
            }
            if (!GuiChat.isShiftKeyDown()) {
                lvt_1_1_ *= 7;
            }
            this.mc.ingameGUI.getChatGUI().scroll(lvt_1_1_);
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        ITextComponent lvt_4_1_;
        if (p_mouseClicked_3_ == 0 && (lvt_4_1_ = this.mc.ingameGUI.getChatGUI().getChatComponent(Mouse.getX(), Mouse.getY())) != null && this.handleComponentClick(lvt_4_1_)) {
            return;
        }
        this.inputField.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    protected void setText(String p_setText_1_, boolean p_setText_2_) {
        if (p_setText_2_) {
            this.inputField.setText(p_setText_1_);
        } else {
            this.inputField.writeText(p_setText_1_);
        }
    }

    public void getSentHistory(int p_getSentHistory_1_) {
        int lvt_2_1_ = this.sentHistoryCursor + p_getSentHistory_1_;
        int lvt_3_1_ = this.mc.ingameGUI.getChatGUI().getSentMessages().size();
        if ((lvt_2_1_ = MathHelper.clamp(lvt_2_1_, 0, lvt_3_1_)) == this.sentHistoryCursor) {
            return;
        }
        if (lvt_2_1_ == lvt_3_1_) {
            this.sentHistoryCursor = lvt_3_1_;
            this.inputField.setText(this.historyBuffer);
            return;
        }
        if (this.sentHistoryCursor == lvt_3_1_) {
            this.historyBuffer = this.inputField.getText();
        }
        this.inputField.setText(this.mc.ingameGUI.getChatGUI().getSentMessages().get(lvt_2_1_));
        this.sentHistoryCursor = lvt_2_1_;
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        GuiChat.drawRect(2, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        this.inputField.drawTextBox();
        ITextComponent lvt_4_1_ = this.mc.ingameGUI.getChatGUI().getChatComponent(Mouse.getX(), Mouse.getY());
        if (lvt_4_1_ != null && lvt_4_1_.getStyle().getHoverEvent() != null) {
            this.handleComponentHover(lvt_4_1_, p_drawScreen_1_, p_drawScreen_2_);
        }
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public void setCompletions(String ... p_setCompletions_1_) {
        this.tabCompleter.setCompletions(p_setCompletions_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ChatTabCompleter
    extends TabCompleter {
        private final Minecraft clientInstance = Minecraft.getMinecraft();

        public ChatTabCompleter(GuiTextField p_i46749_1_) {
            super(p_i46749_1_, false);
        }

        @Override
        public void complete() {
            super.complete();
            if (this.completions.size() > 1) {
                StringBuilder lvt_1_1_ = new StringBuilder();
                for (String lvt_3_1_ : this.completions) {
                    if (lvt_1_1_.length() > 0) {
                        lvt_1_1_.append(", ");
                    }
                    lvt_1_1_.append(lvt_3_1_);
                }
                this.clientInstance.ingameGUI.getChatGUI().printChatMessageWithOptionalDeletion(new TextComponentString(lvt_1_1_.toString()), 1);
            }
        }

        @Override
        @Nullable
        public BlockPos getTargetBlockPos() {
            BlockPos lvt_1_1_ = null;
            if (this.clientInstance.objectMouseOver != null && this.clientInstance.objectMouseOver.typeOfHit == RayTraceResult.Type.BLOCK) {
                lvt_1_1_ = this.clientInstance.objectMouseOver.getBlockPos();
            }
            return lvt_1_1_;
        }
    }
}

