/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.ITabCompleter;
import net.minecraft.util.TabCompleter;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiCommandBlock
extends GuiScreen
implements ITabCompleter {
    private GuiTextField commandTextField;
    private GuiTextField previousOutputTextField;
    private final TileEntityCommandBlock commandBlock;
    private GuiButton doneBtn;
    private GuiButton cancelBtn;
    private GuiButton outputBtn;
    private GuiButton modeBtn;
    private GuiButton conditionalBtn;
    private GuiButton autoExecBtn;
    private boolean trackOutput;
    private TileEntityCommandBlock.Mode commandBlockMode = TileEntityCommandBlock.Mode.REDSTONE;
    private TabCompleter tabCompleter;
    private boolean conditional;
    private boolean automatic;

    public GuiCommandBlock(TileEntityCommandBlock p_i46596_1_) {
        this.commandBlock = p_i46596_1_;
    }

    @Override
    public void updateScreen() {
        this.commandTextField.updateCursorCounter();
    }

    @Override
    public void initGui() {
        final CommandBlockBaseLogic lvt_1_1_ = this.commandBlock.getCommandBlockLogic();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.doneBtn = this.addButton(new GuiButton(0, this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20, I18n.format("gui.done", new Object[0])));
        this.cancelBtn = this.addButton(new GuiButton(1, this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20, I18n.format("gui.cancel", new Object[0])));
        this.outputBtn = this.addButton(new GuiButton(4, this.width / 2 + 150 - 20, 135, 20, 20, "O"));
        this.modeBtn = this.addButton(new GuiButton(5, this.width / 2 - 50 - 100 - 4, 165, 100, 20, I18n.format("advMode.mode.sequence", new Object[0])));
        this.conditionalBtn = this.addButton(new GuiButton(6, this.width / 2 - 50, 165, 100, 20, I18n.format("advMode.mode.unconditional", new Object[0])));
        this.autoExecBtn = this.addButton(new GuiButton(7, this.width / 2 + 50 + 4, 165, 100, 20, I18n.format("advMode.mode.redstoneTriggered", new Object[0])));
        this.commandTextField = new GuiTextField(2, this.fontRendererObj, this.width / 2 - 150, 50, 300, 20);
        this.commandTextField.setMaxStringLength(32500);
        this.commandTextField.setFocused(true);
        this.previousOutputTextField = new GuiTextField(3, this.fontRendererObj, this.width / 2 - 150, 135, 276, 20);
        this.previousOutputTextField.setMaxStringLength(32500);
        this.previousOutputTextField.setEnabled(false);
        this.previousOutputTextField.setText("-");
        this.doneBtn.enabled = false;
        this.outputBtn.enabled = false;
        this.modeBtn.enabled = false;
        this.conditionalBtn.enabled = false;
        this.autoExecBtn.enabled = false;
        this.tabCompleter = new TabCompleter(this.commandTextField, true){

            @Override
            @Nullable
            public BlockPos getTargetBlockPos() {
                return lvt_1_1_.getPosition();
            }
        };
    }

    public void updateGui() {
        CommandBlockBaseLogic lvt_1_1_ = this.commandBlock.getCommandBlockLogic();
        this.commandTextField.setText(lvt_1_1_.getCommand());
        this.trackOutput = lvt_1_1_.shouldTrackOutput();
        this.commandBlockMode = this.commandBlock.getMode();
        this.conditional = this.commandBlock.isConditional();
        this.automatic = this.commandBlock.isAuto();
        this.updateCmdOutput();
        this.updateMode();
        this.updateConditional();
        this.updateAutoExec();
        this.doneBtn.enabled = true;
        this.outputBtn.enabled = true;
        this.modeBtn.enabled = true;
        this.conditionalBtn.enabled = true;
        this.autoExecBtn.enabled = true;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        CommandBlockBaseLogic lvt_2_1_ = this.commandBlock.getCommandBlockLogic();
        if (p_actionPerformed_1_.id == 1) {
            lvt_2_1_.setTrackOutput(this.trackOutput);
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_.id == 0) {
            PacketBuffer lvt_3_1_ = new PacketBuffer(Unpooled.buffer());
            lvt_2_1_.fillInInfo(lvt_3_1_);
            lvt_3_1_.writeString(this.commandTextField.getText());
            lvt_3_1_.writeBoolean(lvt_2_1_.shouldTrackOutput());
            lvt_3_1_.writeString(this.commandBlockMode.name());
            lvt_3_1_.writeBoolean(this.conditional);
            lvt_3_1_.writeBoolean(this.automatic);
            this.mc.getConnection().sendPacket(new CPacketCustomPayload("MC|AutoCmd", lvt_3_1_));
            if (!lvt_2_1_.shouldTrackOutput()) {
                lvt_2_1_.setLastOutput(null);
            }
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_.id == 4) {
            lvt_2_1_.setTrackOutput(!lvt_2_1_.shouldTrackOutput());
            this.updateCmdOutput();
        } else if (p_actionPerformed_1_.id == 5) {
            this.nextMode();
            this.updateMode();
        } else if (p_actionPerformed_1_.id == 6) {
            this.conditional = !this.conditional;
            this.updateConditional();
        } else if (p_actionPerformed_1_.id == 7) {
            this.automatic = !this.automatic;
            this.updateAutoExec();
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        this.tabCompleter.resetRequested();
        if (p_keyTyped_2_ == 15) {
            this.tabCompleter.complete();
        } else {
            this.tabCompleter.resetDidComplete();
        }
        this.commandTextField.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        this.previousOutputTextField.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        if (p_keyTyped_2_ == 28 || p_keyTyped_2_ == 156) {
            this.actionPerformed(this.doneBtn);
        } else if (p_keyTyped_2_ == 1) {
            this.actionPerformed(this.cancelBtn);
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.commandTextField.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.previousOutputTextField.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, I18n.format("advMode.setCommand", new Object[0]), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRendererObj, I18n.format("advMode.command", new Object[0]), this.width / 2 - 150, 37, 0xA0A0A0);
        this.commandTextField.drawTextBox();
        int lvt_4_1_ = 75;
        int lvt_5_1_ = 0;
        this.drawString(this.fontRendererObj, I18n.format("advMode.nearestPlayer", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, I18n.format("advMode.randomPlayer", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, I18n.format("advMode.allPlayers", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, I18n.format("advMode.allEntities", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "", this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        if (!this.previousOutputTextField.getText().isEmpty()) {
            this.drawString(this.fontRendererObj, I18n.format("advMode.previousOutput", new Object[0]), this.width / 2 - 150, lvt_4_1_ += lvt_5_1_ * this.fontRendererObj.FONT_HEIGHT + 1, 0xA0A0A0);
            this.previousOutputTextField.drawTextBox();
        }
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    private void updateCmdOutput() {
        CommandBlockBaseLogic lvt_1_1_ = this.commandBlock.getCommandBlockLogic();
        if (lvt_1_1_.shouldTrackOutput()) {
            this.outputBtn.displayString = "O";
            if (lvt_1_1_.getLastOutput() != null) {
                this.previousOutputTextField.setText(lvt_1_1_.getLastOutput().getUnformattedText());
            }
        } else {
            this.outputBtn.displayString = "X";
            this.previousOutputTextField.setText("-");
        }
    }

    private void updateMode() {
        switch (this.commandBlockMode) {
            case SEQUENCE: {
                this.modeBtn.displayString = I18n.format("advMode.mode.sequence", new Object[0]);
                break;
            }
            case AUTO: {
                this.modeBtn.displayString = I18n.format("advMode.mode.auto", new Object[0]);
                break;
            }
            case REDSTONE: {
                this.modeBtn.displayString = I18n.format("advMode.mode.redstone", new Object[0]);
            }
        }
    }

    private void nextMode() {
        switch (this.commandBlockMode) {
            case SEQUENCE: {
                this.commandBlockMode = TileEntityCommandBlock.Mode.AUTO;
                break;
            }
            case AUTO: {
                this.commandBlockMode = TileEntityCommandBlock.Mode.REDSTONE;
                break;
            }
            case REDSTONE: {
                this.commandBlockMode = TileEntityCommandBlock.Mode.SEQUENCE;
            }
        }
    }

    private void updateConditional() {
        this.conditionalBtn.displayString = this.conditional ? I18n.format("advMode.mode.conditional", new Object[0]) : I18n.format("advMode.mode.unconditional", new Object[0]);
    }

    private void updateAutoExec() {
        this.autoExecBtn.displayString = this.automatic ? I18n.format("advMode.mode.autoexec.bat", new Object[0]) : I18n.format("advMode.mode.redstoneTriggered", new Object[0]);
    }

    @Override
    public void setCompletions(String ... p_setCompletions_1_) {
        this.tabCompleter.setCompletions(p_setCompletions_1_);
    }
}

