/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiKeyBindingList;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiControls
extends GuiScreen {
    private static final GameSettings.Options[] OPTIONS_ARR = new GameSettings.Options[]{GameSettings.Options.INVERT_MOUSE, GameSettings.Options.SENSITIVITY, GameSettings.Options.TOUCHSCREEN, GameSettings.Options.AUTO_JUMP};
    private final GuiScreen parentScreen;
    protected String screenTitle = "Controls";
    private final GameSettings options;
    public KeyBinding buttonId;
    public long time;
    private GuiKeyBindingList keyBindingList;
    private GuiButton buttonReset;

    public GuiControls(GuiScreen p_i1027_1_, GameSettings p_i1027_2_) {
        this.parentScreen = p_i1027_1_;
        this.options = p_i1027_2_;
    }

    @Override
    public void initGui() {
        this.keyBindingList = new GuiKeyBindingList(this, this.mc);
        this.buttonList.add(new GuiButton(200, this.width / 2 - 155 + 160, this.height - 29, 150, 20, I18n.format("gui.done", new Object[0])));
        this.buttonReset = this.addButton(new GuiButton(201, this.width / 2 - 155, this.height - 29, 150, 20, I18n.format("controls.resetAll", new Object[0])));
        this.screenTitle = I18n.format("controls.title", new Object[0]);
        int i = 0;
        for (GameSettings.Options gamesettings$options : OPTIONS_ARR) {
            if (gamesettings$options.getEnumFloat()) {
                this.buttonList.add(new GuiOptionSlider(gamesettings$options.returnEnumOrdinal(), this.width / 2 - 155 + i % 2 * 160, 18 + 24 * (i >> 1), gamesettings$options));
            } else {
                this.buttonList.add(new GuiOptionButton(gamesettings$options.returnEnumOrdinal(), this.width / 2 - 155 + i % 2 * 160, 18 + 24 * (i >> 1), gamesettings$options, this.options.getKeyBinding(gamesettings$options)));
            }
            ++i;
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.keyBindingList.handleMouseInput();
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (p_actionPerformed_1_.id == 200) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (p_actionPerformed_1_.id == 201) {
            for (KeyBinding keybinding : this.mc.gameSettings.keyBindings) {
                keybinding.setToDefault();
            }
            KeyBinding.resetKeyBindingArrayAndHash();
        } else if (p_actionPerformed_1_.id < 100 && p_actionPerformed_1_ instanceof GuiOptionButton) {
            this.options.setOptionValue(((GuiOptionButton)p_actionPerformed_1_).returnEnumOptions(), 1);
            p_actionPerformed_1_.displayString = this.options.getKeyBinding(GameSettings.Options.getEnumOptions(p_actionPerformed_1_.id));
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        if (this.buttonId != null) {
            this.buttonId.setKeyModifierAndCode(KeyModifier.getActiveModifier(), -100 + p_mouseClicked_3_);
            this.options.setOptionKeyBinding(this.buttonId, -100 + p_mouseClicked_3_);
            this.buttonId = null;
            KeyBinding.resetKeyBindingArrayAndHash();
        } else if (p_mouseClicked_3_ != 0 || !this.keyBindingList.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_)) {
            super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
    }

    @Override
    protected void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        if (p_mouseReleased_3_ != 0 || !this.keyBindingList.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_)) {
            super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (this.buttonId != null) {
            if (p_keyTyped_2_ == 1) {
                this.buttonId.setKeyModifierAndCode(KeyModifier.NONE, 0);
                this.options.setOptionKeyBinding(this.buttonId, 0);
            } else if (p_keyTyped_2_ != 0) {
                this.buttonId.setKeyModifierAndCode(KeyModifier.getActiveModifier(), p_keyTyped_2_);
                this.options.setOptionKeyBinding(this.buttonId, p_keyTyped_2_);
            } else if (p_keyTyped_1_ > '\u0000') {
                this.buttonId.setKeyModifierAndCode(KeyModifier.getActiveModifier(), p_keyTyped_1_ + 256);
                this.options.setOptionKeyBinding(this.buttonId, p_keyTyped_1_ + 256);
            }
            if (!KeyModifier.isKeyCodeModifier(p_keyTyped_2_)) {
                this.buttonId = null;
            }
            this.time = Minecraft.getSystemTime();
            KeyBinding.resetKeyBindingArrayAndHash();
        } else {
            super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.keyBindingList.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, this.screenTitle, this.width / 2, 8, 0xFFFFFF);
        boolean flag = false;
        for (KeyBinding keybinding : this.options.keyBindings) {
            if (keybinding.isSetToDefaultValue()) continue;
            flag = true;
            break;
        }
        this.buttonReset.enabled = flag;
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }
}

