/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiFlatPresets;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCreateFlatWorld
extends GuiScreen {
    private final GuiCreateWorld createWorldGui;
    private FlatGeneratorInfo theFlatGeneratorInfo = FlatGeneratorInfo.getDefaultFlatGenerator();
    private String flatWorldTitle;
    private String materialText;
    private String heightText;
    private Details createFlatWorldListSlotGui;
    private GuiButton addLayerButton;
    private GuiButton editLayerButton;
    private GuiButton removeLayerButton;

    public GuiCreateFlatWorld(GuiCreateWorld p_i1029_1_, String p_i1029_2_) {
        this.createWorldGui = p_i1029_1_;
        this.setPreset(p_i1029_2_);
    }

    public String getPreset() {
        return this.theFlatGeneratorInfo.toString();
    }

    public void setPreset(String p_setPreset_1_) {
        this.theFlatGeneratorInfo = FlatGeneratorInfo.createFlatGeneratorFromString(p_setPreset_1_);
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        this.flatWorldTitle = I18n.format("createWorld.customize.flat.title", new Object[0]);
        this.materialText = I18n.format("createWorld.customize.flat.tile", new Object[0]);
        this.heightText = I18n.format("createWorld.customize.flat.height", new Object[0]);
        this.createFlatWorldListSlotGui = new Details();
        this.addLayerButton = this.addButton(new GuiButton(2, this.width / 2 - 154, this.height - 52, 100, 20, I18n.format("createWorld.customize.flat.addLayer", new Object[0]) + " (NYI)"));
        this.editLayerButton = this.addButton(new GuiButton(3, this.width / 2 - 50, this.height - 52, 100, 20, I18n.format("createWorld.customize.flat.editLayer", new Object[0]) + " (NYI)"));
        this.removeLayerButton = this.addButton(new GuiButton(4, this.width / 2 - 155, this.height - 52, 150, 20, I18n.format("createWorld.customize.flat.removeLayer", new Object[0])));
        this.buttonList.add(new GuiButton(0, this.width / 2 - 155, this.height - 28, 150, 20, I18n.format("gui.done", new Object[0])));
        this.buttonList.add(new GuiButton(5, this.width / 2 + 5, this.height - 52, 150, 20, I18n.format("createWorld.customize.presets", new Object[0])));
        this.buttonList.add(new GuiButton(1, this.width / 2 + 5, this.height - 28, 150, 20, I18n.format("gui.cancel", new Object[0])));
        this.addLayerButton.visible = false;
        this.editLayerButton.visible = false;
        this.theFlatGeneratorInfo.updateLayers();
        this.onLayersChanged();
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.createFlatWorldListSlotGui.handleMouseInput();
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        int lvt_2_1_ = this.theFlatGeneratorInfo.getFlatLayers().size() - this.createFlatWorldListSlotGui.selectedLayer - 1;
        if (p_actionPerformed_1_.id == 1) {
            this.mc.displayGuiScreen(this.createWorldGui);
        } else if (p_actionPerformed_1_.id == 0) {
            this.createWorldGui.chunkProviderSettingsJson = this.getPreset();
            this.mc.displayGuiScreen(this.createWorldGui);
        } else if (p_actionPerformed_1_.id == 5) {
            this.mc.displayGuiScreen(new GuiFlatPresets(this));
        } else if (p_actionPerformed_1_.id == 4 && this.hasSelectedLayer()) {
            this.theFlatGeneratorInfo.getFlatLayers().remove(lvt_2_1_);
            this.createFlatWorldListSlotGui.selectedLayer = Math.min(this.createFlatWorldListSlotGui.selectedLayer, this.theFlatGeneratorInfo.getFlatLayers().size() - 1);
        }
        this.theFlatGeneratorInfo.updateLayers();
        this.onLayersChanged();
    }

    public void onLayersChanged() {
        boolean lvt_1_1_;
        this.removeLayerButton.enabled = lvt_1_1_ = this.hasSelectedLayer();
        this.editLayerButton.enabled = lvt_1_1_;
        this.editLayerButton.enabled = false;
        this.addLayerButton.enabled = false;
    }

    private boolean hasSelectedLayer() {
        return this.createFlatWorldListSlotGui.selectedLayer > -1 && this.createFlatWorldListSlotGui.selectedLayer < this.theFlatGeneratorInfo.getFlatLayers().size();
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.createFlatWorldListSlotGui.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, this.flatWorldTitle, this.width / 2, 8, 0xFFFFFF);
        int lvt_4_1_ = this.width / 2 - 92 - 16;
        this.drawString(this.fontRendererObj, this.materialText, lvt_4_1_, 32, 0xFFFFFF);
        this.drawString(this.fontRendererObj, this.heightText, lvt_4_1_ + 2 + 213 - this.fontRendererObj.getStringWidth(this.heightText), 32, 0xFFFFFF);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @SideOnly(value=Side.CLIENT)
    class Details
    extends GuiSlot {
        public int selectedLayer;

        public Details() {
            super(GuiCreateFlatWorld.this.mc, GuiCreateFlatWorld.this.width, GuiCreateFlatWorld.this.height, 43, GuiCreateFlatWorld.this.height - 60, 24);
            this.selectedLayer = -1;
        }

        private void drawItem(int p_drawItem_1_, int p_drawItem_2_, ItemStack p_drawItem_3_) {
            this.drawItemBackground(p_drawItem_1_ + 1, p_drawItem_2_ + 1);
            GlStateManager.enableRescaleNormal();
            if (!p_drawItem_3_.isEmpty()) {
                RenderHelper.enableGUIStandardItemLighting();
                GuiCreateFlatWorld.this.itemRender.renderItemIntoGUI(p_drawItem_3_, p_drawItem_1_ + 2, p_drawItem_2_ + 2);
                RenderHelper.disableStandardItemLighting();
            }
            GlStateManager.disableRescaleNormal();
        }

        private void drawItemBackground(int p_drawItemBackground_1_, int p_drawItemBackground_2_) {
            this.drawItemBackground(p_drawItemBackground_1_, p_drawItemBackground_2_, 0, 0);
        }

        private void drawItemBackground(int p_drawItemBackground_1_, int p_drawItemBackground_2_, int p_drawItemBackground_3_, int p_drawItemBackground_4_) {
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            this.mc.getTextureManager().bindTexture(Gui.STAT_ICONS);
            float lvt_5_1_ = 0.0078125f;
            float lvt_6_1_ = 0.0078125f;
            int lvt_7_1_ = 18;
            int lvt_8_1_ = 18;
            Tessellator lvt_9_1_ = Tessellator.getInstance();
            VertexBuffer lvt_10_1_ = lvt_9_1_.getBuffer();
            lvt_10_1_.begin(7, DefaultVertexFormats.POSITION_TEX);
            lvt_10_1_.pos(p_drawItemBackground_1_ + 0, p_drawItemBackground_2_ + 18, GuiCreateFlatWorld.this.zLevel).tex((float)(p_drawItemBackground_3_ + 0) * 0.0078125f, (float)(p_drawItemBackground_4_ + 18) * 0.0078125f).endVertex();
            lvt_10_1_.pos(p_drawItemBackground_1_ + 18, p_drawItemBackground_2_ + 18, GuiCreateFlatWorld.this.zLevel).tex((float)(p_drawItemBackground_3_ + 18) * 0.0078125f, (float)(p_drawItemBackground_4_ + 18) * 0.0078125f).endVertex();
            lvt_10_1_.pos(p_drawItemBackground_1_ + 18, p_drawItemBackground_2_ + 0, GuiCreateFlatWorld.this.zLevel).tex((float)(p_drawItemBackground_3_ + 18) * 0.0078125f, (float)(p_drawItemBackground_4_ + 0) * 0.0078125f).endVertex();
            lvt_10_1_.pos(p_drawItemBackground_1_ + 0, p_drawItemBackground_2_ + 0, GuiCreateFlatWorld.this.zLevel).tex((float)(p_drawItemBackground_3_ + 0) * 0.0078125f, (float)(p_drawItemBackground_4_ + 0) * 0.0078125f).endVertex();
            lvt_9_1_.draw();
        }

        @Override
        protected int getSize() {
            return GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().size();
        }

        @Override
        protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
            this.selectedLayer = p_elementClicked_1_;
            GuiCreateFlatWorld.this.onLayersChanged();
        }

        @Override
        protected boolean isSelected(int p_isSelected_1_) {
            return p_isSelected_1_ == this.selectedLayer;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            String lvt_13_3_;
            FlatLayerInfo lvt_7_1_ = GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().get(GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().size() - p_drawSlot_1_ - 1);
            IBlockState lvt_8_1_ = lvt_7_1_.getLayerMaterial();
            Block lvt_9_1_ = lvt_8_1_.getBlock();
            Item lvt_10_1_ = Item.getItemFromBlock(lvt_9_1_);
            if (lvt_10_1_ == Items.AIR) {
                if (lvt_9_1_ == Blocks.WATER || lvt_9_1_ == Blocks.FLOWING_WATER) {
                    lvt_10_1_ = Items.WATER_BUCKET;
                } else if (lvt_9_1_ == Blocks.LAVA || lvt_9_1_ == Blocks.FLOWING_LAVA) {
                    lvt_10_1_ = Items.LAVA_BUCKET;
                }
            }
            ItemStack lvt_11_1_ = new ItemStack(lvt_10_1_, 1, lvt_10_1_.getHasSubtypes() ? lvt_9_1_.getMetaFromState(lvt_8_1_) : 0);
            String lvt_12_1_ = lvt_10_1_.getItemStackDisplayName(lvt_11_1_);
            this.drawItem(p_drawSlot_2_, p_drawSlot_3_, lvt_11_1_);
            GuiCreateFlatWorld.this.fontRendererObj.drawString(lvt_12_1_, p_drawSlot_2_ + 18 + 5, p_drawSlot_3_ + 3, 0xFFFFFF);
            if (p_drawSlot_1_ == 0) {
                String lvt_13_1_ = I18n.format("createWorld.customize.flat.layer.top", lvt_7_1_.getLayerCount());
            } else if (p_drawSlot_1_ == GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().size() - 1) {
                String lvt_13_2_ = I18n.format("createWorld.customize.flat.layer.bottom", lvt_7_1_.getLayerCount());
            } else {
                lvt_13_3_ = I18n.format("createWorld.customize.flat.layer", lvt_7_1_.getLayerCount());
            }
            GuiCreateFlatWorld.this.fontRendererObj.drawString(lvt_13_3_, p_drawSlot_2_ + 2 + 213 - GuiCreateFlatWorld.this.fontRendererObj.getStringWidth(lvt_13_3_), p_drawSlot_3_ + 3, 0xFFFFFF);
        }

        @Override
        protected int getScrollBarX() {
            return this.width - 70;
        }
    }
}

